/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.helper.callbacks.handler;

import java.text.Collator;
import java.util.concurrent.atomic.AtomicInteger;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.test.helper.SampleException;
import org.junit.jupiter.api.Assertions;
import org.slf4j.LoggerFactory;

public class CallbackHandlerImpl
implements CallbackHandler<String> {
    private final AtomicInteger testHandleCalls = new AtomicInteger(0);
    private final AtomicInteger testErrorCalls = new AtomicInteger(0);
    private String lastError;

    public void handle(String _r) {
        this.testHandleCalls.incrementAndGet();
        LoggerFactory.getLogger(this.getClass()).debug("Handling callback: " + _r);
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        if (0 != col.compare("This Is A UTF-8 Name: \ufeb1 !!", _r)) {
            this.lastError = "call with callback, wrong return value";
        }
    }

    public void handleError(DBusExecutionException _e) {
        this.testErrorCalls.incrementAndGet();
        LoggerFactory.getLogger(this.getClass()).debug("Handling error callback: " + String.valueOf((Object)_e) + " message = '" + _e.getMessage() + "'");
        if (!(_e instanceof SampleException)) {
            Assertions.fail((String)"Exception is of the wrong sort");
        }
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        if (0 != col.compare("test", _e.getMessage())) {
            this.lastError = "Exception has the wrong message";
        }
    }

    public int getTestHandleCalls() {
        return this.testHandleCalls.get();
    }

    public int getTestErrorCalls() {
        return this.testErrorCalls.get();
    }

    public String getLastError() {
        return this.lastError;
    }
}

