/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.helper.cross;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.freedesktop.dbus.annotations.IntrospectionDescription;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.helper.cross.CrossTestClient;
import org.freedesktop.dbus.test.helper.interfaces.Binding;
import org.freedesktop.dbus.test.helper.interfaces.SamplesInterface;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;

public class CrossTestServer
implements SamplesInterface,
Binding.SingleSample,
DBusSigHandler<Binding.SampleClient.Trigger> {
    private final DBusConnection conn;
    private volatile boolean run = true;
    private Set<String> done = new TreeSet<String>();
    private Set<String> notdone = new TreeSet<String>();

    public CrossTestServer(DBusConnection _conn) {
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Identity");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityByte");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityBool");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt16");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt16");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt32");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt32");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt64");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt64");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityDouble");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityString");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityByteArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityBoolArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt16Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt16Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt32Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt32Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt64Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt64Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityDoubleArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityStringArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Sum");
        this.notdone.add("org.freedesktop.DBus.Binding.SingleTests.Sum");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.InvertMapping");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.DeStruct");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Primitize");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Invert");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Trigger");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Exit");
        this.notdone.add("org.freedesktop.DBus.Binding.TestClient.Trigger");
        this.conn = _conn;
    }

    public boolean isRemote() {
        return false;
    }

    public String getObjectPath() {
        return null;
    }

    public boolean isRun() {
        return this.run;
    }

    public void setRun(boolean _run) {
        this.run = _run;
    }

    public Set<String> getDone() {
        return this.done;
    }

    public void setDone(Set<String> _done) {
        this.done = _done;
    }

    public Set<String> getNotdone() {
        return this.notdone;
    }

    public void setNotdone(Set<String> _notdone) {
        this.notdone = _notdone;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public <T> Variant<T> Identity(Variant<T> _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Identity");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Identity");
        return new Variant(_input.getValue());
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public byte IdentityByte(byte _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityByte");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityByte");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public boolean IdentityBool(boolean _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityBool");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityBool");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public short IdentityInt16(short _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt16");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt16");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public UInt16 IdentityUInt16(UInt16 _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt16");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt16");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public int IdentityInt32(int _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt32");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt32");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public UInt32 IdentityUInt32(UInt32 _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt32");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt32");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public long IdentityInt64(long _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt64");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt64");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public UInt64 IdentityUInt64(UInt64 _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt64");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt64");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public double IdentityDouble(double _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityDouble");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityDouble");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public String IdentityString(String _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityString");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityString");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public <T> Variant<T>[] IdentityArray(Variant<T>[] _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityArray");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public byte[] IdentityByteArray(byte[] _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityByteArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityByteArray");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public boolean[] IdentityBoolArray(boolean[] _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityBoolArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityBoolArray");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public short[] IdentityInt16Array(short[] _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt16Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt16Array");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public UInt16[] IdentityUInt16Array(UInt16[] _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt16Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt16Array");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public int[] IdentityInt32Array(int[] _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt32Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt32Array");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public UInt32[] IdentityUInt32Array(UInt32[] _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt32Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt32Array");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public long[] IdentityInt64Array(long[] _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt64Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt64Array");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public UInt64[] IdentityUInt64Array(UInt64[] _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt64Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt64Array");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public double[] IdentityDoubleArray(double[] _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityDoubleArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityDoubleArray");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public String[] IdentityStringArray(String[] _input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityStringArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityStringArray");
        return _input;
    }

    @Override
    @IntrospectionDescription(value="Returns the sum of the values in the input list")
    public long Sum(int[] _a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Sum");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Sum");
        long sum = 0L;
        for (int b : _a) {
            sum += (long)b;
        }
        return sum;
    }

    @Override
    @IntrospectionDescription(value="Returns the sum of the values in the input list")
    public UInt32 Sum(byte[] _a) {
        this.done.add("org.freedesktop.DBus.Binding.SingleTests.Sum");
        this.notdone.remove("org.freedesktop.DBus.Binding.SingleTests.Sum");
        int sum = 0;
        for (int n : _a) {
            sum += n < 0 ? n + 256 : n;
        }
        return new UInt32((long)sum % 0x100000000L);
    }

    @Override
    @IntrospectionDescription(value="Given a map of A => B, should return a map of B => a list of all the As which mapped to B")
    public Map<String, List<String>> InvertMapping(Map<String, String> _a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.InvertMapping");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.InvertMapping");
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        for (String s : _a.keySet()) {
            String b = _a.get(s);
            ArrayList<String> l = (ArrayList<String>)m.get(b);
            if (null == l) {
                l = new ArrayList<String>();
                m.put(b, l);
            }
            l.add(s);
        }
        return m;
    }

    @Override
    @IntrospectionDescription(value="This method returns the contents of a struct as separate values")
    public Binding.Triplet<String, UInt32, Short> DeStruct(Binding.CrossSampleStruct _a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.DeStruct");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.DeStruct");
        return new Binding.Triplet<String, UInt32, Short>(_a.getSampleString(), _a.getSampleUint32(), _a.getSampleShort());
    }

    @Override
    @IntrospectionDescription(value="Given any compound type as a variant, return all the primitive types recursively contained within as an array of variants")
    public List<Variant<Object>> Primitize(Variant<Object> _a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Primitize");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Primitize");
        return CrossTestClient.primitizeRecurse(_a.getValue(), _a.getType());
    }

    @Override
    @IntrospectionDescription(value="inverts it's input")
    public boolean Invert(boolean _a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Invert");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Invert");
        return !_a;
    }

    @Override
    @IntrospectionDescription(value="triggers sending of a signal from the supplied object with the given parameter")
    public void Trigger(String _a, UInt64 _b) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Trigger");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Trigger");
        try {
            this.conn.sendMessage((Message)new Binding.SampleSignals.Triggered(_a, _b));
        }
        catch (DBusException _exD) {
            throw new DBusExecutionException(_exD.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Exit() {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Exit");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Exit");
        this.run = false;
        CrossTestServer crossTestServer = this;
        synchronized (crossTestServer) {
            this.notifyAll();
        }
    }

    public void handle(Binding.SampleClient.Trigger _t) {
        this.done.add("org.freedesktop.DBus.Binding.TestClient.Trigger");
        this.notdone.remove("org.freedesktop.DBus.Binding.TestClient.Trigger");
        try {
            Binding.SampleClient cb = (Binding.SampleClient)this.conn.getRemoteObject(_t.getSource(), "/TestClient", Binding.SampleClient.class);
            cb.Response(_t.getSampleUint16(), _t.getSampleDouble());
        }
        catch (DBusException _exD) {
            throw new DBusExecutionException(_exD.getMessage());
        }
    }
}

