/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.lang.reflect.Method;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusMemberName;
import org.freedesktop.dbus.annotations.DeprecatedOnDBus;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.utils.DBusNamingUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DBusNamingUtilTest {
    DBusNamingUtilTest() {
    }

    @Test
    void testGetInterfaceName() {
        Assertions.assertEquals((Object)"org.freedesktop.dbus.utils.DBusNamingUtilTest.Foo", (Object)DBusNamingUtil.getInterfaceName(Foo.class));
        Assertions.assertEquals((Object)"com.example.Bar", (Object)DBusNamingUtil.getInterfaceName(Bar.class));
    }

    @Test
    void testGetMethodName() throws NoSuchMethodException {
        Method method1 = InterfaceWithMethodsAndSignals.class.getMethod("method1", new Class[0]);
        Assertions.assertEquals((Object)"method1", (Object)DBusNamingUtil.getMethodName((Method)method1));
        Method method2 = InterfaceWithMethodsAndSignals.class.getMethod("method2", new Class[0]);
        Assertions.assertEquals((Object)"methodAnnotationName", (Object)DBusNamingUtil.getMethodName((Method)method2));
    }

    @Test
    void testGetSignalName() {
        Class<InterfaceWithMethodsAndSignals.Signal1> signal1 = InterfaceWithMethodsAndSignals.Signal1.class;
        Assertions.assertEquals((Object)"Signal1", (Object)DBusNamingUtil.getSignalName(signal1));
        Class<InterfaceWithMethodsAndSignals.Signal2> signal2 = InterfaceWithMethodsAndSignals.Signal2.class;
        Assertions.assertEquals((Object)"SignalAnnotationName", (Object)DBusNamingUtil.getSignalName(signal2));
    }

    @Test
    void testGetAnnotationName() {
        Assertions.assertEquals((Object)"org.freedesktop.DBus.Deprecated", (Object)DBusNamingUtil.getAnnotationName(DeprecatedOnDBus.class));
    }

    static interface Foo
    extends DBusInterface {
    }

    @DBusInterfaceName(value="com.example.Bar")
    static interface Bar
    extends DBusInterface {
    }

    static interface InterfaceWithMethodsAndSignals
    extends DBusInterface {
        public void method1();

        @DBusMemberName(value="methodAnnotationName")
        public void method2();

        @DBusMemberName(value="SignalAnnotationName")
        public static class Signal2
        extends DBusSignal {
            Signal2(String _objectPath, Object ... _args) throws DBusException {
                super(_objectPath, _args);
            }
        }

        public static class Signal1
        extends DBusSignal {
            Signal1(String _objectPath, Object ... _args) throws DBusException {
                super(_objectPath, _args);
            }
        }
    }
}

