/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.time.Duration;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.freedesktop.dbus.utils.TimeMeasure;
import org.junit.jupiter.api.Test;

public class TimeMeasureTest
extends AbstractBaseTest {
    @Test
    public void testTimeMeasure() {
        TimeMeasure tm = new TimeMeasure();
        TimeMeasureTest.assertTrue((tm.getElapsed() >= 0L ? 1 : 0) != 0);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException _ex) {
            TimeMeasureTest.assertTrue((boolean)true);
        }
        TimeMeasureTest.assertTrue((tm.getElapsed() >= 100L ? 1 : 0) != 0);
        TimeMeasureTest.assertTrue((boolean)tm.toString().matches("^[0-9]+ms$"), (String)("toString() returned " + String.valueOf(tm)));
        tm.reset();
        long elapsed = tm.getElapsed();
        TimeMeasureTest.assertTrue((elapsed < 10L ? 1 : 0) != 0);
        tm.setStartTm(Duration.ofMillis(Duration.ofNanos(tm.getStartTime()).toMillis() - 10000L).toNanos());
        elapsed = tm.getElapsed();
        TimeMeasureTest.assertTrue((elapsed >= 10000L ? 1 : 0) != 0, (String)("Elapsed was " + elapsed));
        String toStringResult = tm.toString();
        TimeMeasureTest.assertTrue((boolean)toStringResult.matches("^[0-9]+\\.[0-9]s$"), (String)("toString() returned " + toStringResult));
    }

    @Test
    public void testTimeMeasureFormatter() {
        TimeMeasure tm = new TimeMeasure();
        String oneSecond = tm.getElapsedFormatted(null, 1000L);
        TimeMeasureTest.assertEquals((Object)"00:00:01.000", (Object)oneSecond);
        String oneMinuteoneSecond = tm.getElapsedFormatted(null, 61000L);
        TimeMeasureTest.assertEquals((Object)"00:01:01.000", (Object)oneMinuteoneSecond);
        String threeSecondsAfewMillis = tm.getElapsedFormatted(null, 3721L);
        TimeMeasureTest.assertEquals((Object)"00:00:03.721", (Object)threeSecondsAfewMillis);
    }
}

