/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.freedesktop.dbus.bin.DBusDaemon;
import org.freedesktop.dbus.bin.EmbeddedDBusDaemon;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.matchrules.DBusMatchRule;
import org.freedesktop.dbus.matchrules.DBusMatchRuleBuilder;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.freedesktop.dbus.test.helper.signals.SampleSignals;
import org.freedesktop.dbus.types.UInt32;
import org.junit.jupiter.api.Test;

class EmbeddedDBusDaemonTest
extends AbstractBaseTest {
    EmbeddedDBusDaemonTest() {
    }

    @Test
    void testAddMatchRule() throws DBusException, InterruptedException {
        this.doWithEmbeddedDaemon((daemon, addr) -> {
            try {
                CountDownLatch countDown = new CountDownLatch(1);
                AtomicInteger counter = new AtomicInteger();
                try (DBusConnection handlerConn = DBusConnectionBuilder.forAddress((BusAddress)addr).withShared(false).build();
                     DBusConnection senderConn = DBusConnectionBuilder.forAddress((BusAddress)addr).withShared(false).build();){
                    DBusMatchRule rule = DBusMatchRuleBuilder.create().withInterface(SampleSignals.class.getName()).withSender(senderConn.getUniqueName()).build();
                    handlerConn.addSigHandler(rule, s -> {
                        this.logger.info(">>> Got signal: {}", (Object)s);
                        counter.incrementAndGet();
                        countDown.countDown();
                    });
                    senderConn.sendMessage((Message)new SampleSignals.TestSignal("/some/rule/Test", "XXX", new UInt32(21L)));
                    countDown.await(5L, TimeUnit.SECONDS);
                    EmbeddedDBusDaemonTest.assertEquals((int)1, (int)counter.get(), (String)"Expected signal to be handled");
                }
            }
            catch (Exception _ex) {
                EmbeddedDBusDaemonTest.fail((Throwable)_ex);
            }
        });
    }

    @Test
    void testStartAndConnectEmbeddedDBusDaemon() throws DBusException {
        this.doWithEmbeddedDaemon((daemon, addr) -> {
            try (DBusConnection conn = DBusConnectionBuilder.forAddress((BusAddress)addr).build();){
                this.logger.debug("Connected to embedded DBus {}", addr);
            }
            catch (Exception _ex) {
                EmbeddedDBusDaemonTest.fail((String)"Connection to EmbeddedDbusDaemon failed", (Throwable)_ex);
                this.logger.error("Error connecting to EmbeddedDbusDaemon", (Throwable)_ex);
            }
        });
    }

    private void doWithEmbeddedDaemon(BiConsumer<EmbeddedDBusDaemon, BusAddress> _handler) {
        String protocolType = (String)TransportBuilder.getRegisteredBusTypes().get(0);
        String newAddress = TransportBuilder.createDynamicSession((String)protocolType, (boolean)false);
        BusAddress busAddress = BusAddress.of((String)newAddress);
        BusAddress listenBusAddress = BusAddress.of((String)(newAddress + ",listen=true"));
        this.logger.debug("Starting embedded bus on address {})", (Object)listenBusAddress);
        try (EmbeddedDBusDaemon daemon = new EmbeddedDBusDaemon(listenBusAddress);){
            this.logger.debug("Started embedded bus on address {}", (Object)listenBusAddress);
            daemon.startInBackgroundAndWait(MAX_WAIT);
            if (_handler != null) {
                _handler.accept(daemon, busAddress);
            }
        }
        catch (IOException _ex) {
            EmbeddedDBusDaemonTest.fail((String)"Failed to start EmbeddedDbusDaemon", (Throwable)_ex);
            this.logger.error("Error starting EmbeddedDbusDaemon", (Throwable)_ex);
        }
    }

    @Test
    void testStartStop() throws Exception {
        for (int i = 0; i < 2; ++i) {
            String address = TransportBuilder.createDynamicSession((String)((String)TransportBuilder.getRegisteredBusTypes().get(0)), (boolean)true);
            BusAddress busAddress = BusAddress.of((String)address);
            EmbeddedDBusDaemon daemon = new EmbeddedDBusDaemon(busAddress);
            if (busAddress.isBusType("TCP")) {
                String addrStr = busAddress.removeParameter("listen").toString();
                System.setProperty("DBUS_SESSION_BUS_ADDRESS", addrStr);
            }
            AtomicReference exception = new AtomicReference();
            Thread daemonThread = new Thread(() -> {
                try {
                    daemon.startInForeground();
                }
                catch (Exception _ex) {
                    exception.set(_ex);
                    _ex.printStackTrace();
                }
            });
            daemonThread.start();
            Thread.sleep(1000L);
            daemon.close();
            EmbeddedDBusDaemonTest.assertEquals(null, exception.get());
        }
        Map.Entry<Thread, StackTraceElement[]> elems = null;
        for (Map.Entry<Thread, StackTraceElement[]> stacks : Thread.getAllStackTraces().entrySet()) {
            if (!stacks.getKey().getName().startsWith(DBusDaemon.class.getSimpleName())) continue;
            elems = stacks;
            break;
        }
        if (elems != null) {
            System.out.println("Found possibly running instances: " + ((Thread)elems.getKey()).getName());
            for (StackTraceElement st : (StackTraceElement[])elems.getValue()) {
                System.out.println("\t" + st.toString());
            }
            EmbeddedDBusDaemonTest.fail((String)"All dbus daemon threads should have been terminated");
        }
    }
}

