/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.base;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.freedesktop.dbus.connections.base.ReceivingService;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfigBuilder;
import org.freedesktop.dbus.connections.shared.ExecutorNames;
import org.freedesktop.dbus.connections.shared.IThreadPoolRetryHandler;
import org.freedesktop.dbus.exceptions.IllegalThreadPoolStateException;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.junit.jupiter.api.Test;

class ReceivingServiceTest
extends AbstractBaseTest {
    ReceivingServiceTest() {
    }

    @Test
    void testRetryHandlerNotUsed() {
        ReceivingServiceConfig build = new ReceivingServiceConfigBuilder(null).withRetryHandler(null).build();
        ReceivingService service = new ReceivingService("", build){

            ExecutorService getExecutor(ExecutorNames _executor) {
                return new NoOpExecutorService();
            }
        };
        int fails = service.execOrFail(ExecutorNames.SIGNAL, () -> this.logger.debug("hi"));
        ReceivingServiceTest.assertEquals((int)0, (int)fails, (String)"No retry attempt expected");
    }

    @Test
    void testRetryHandlerCalled5Times() {
        IThreadPoolRetryHandler handler = new IThreadPoolRetryHandler(){
            private int count = 0;

            public boolean handle(ExecutorNames _executor, Exception _ex) {
                ++this.count;
                return this.count < 5;
            }
        };
        ReceivingServiceConfig build = new ReceivingServiceConfigBuilder(null).withRetryHandler(handler).build();
        ReceivingService service = new ReceivingService("", build){

            ExecutorService getExecutor(ExecutorNames _executor) {
                return new NoOpExecutorService();
            }
        };
        int fails = service.execSignalHandler(() -> this.logger.debug("hi"));
        ReceivingServiceTest.assertEquals((int)5, (int)fails, (String)"5 retry attempts expected");
    }

    @Test
    void testDefaultRetryHandler() {
        ReceivingServiceConfig build = new ReceivingServiceConfigBuilder(null).build();
        ReceivingService service = new ReceivingService("", build){

            ExecutorService getExecutor(ExecutorNames _executor) {
                return new NoOpExecutorService();
            }
        };
        int fails = service.execMethodCallHandler(() -> this.logger.debug("hi"));
        ReceivingServiceTest.assertEquals((int)10, (int)fails, (String)"10 retry attempts expected");
    }

    @Test
    void testRetryHandlerHardLimit() {
        IThreadPoolRetryHandler handler = (executor, ex) -> true;
        ReceivingServiceConfig build = new ReceivingServiceConfigBuilder(null).withRetryHandler(handler).build();
        ReceivingService service = new ReceivingService("", build){

            ExecutorService getExecutor(ExecutorNames _executor) {
                return new NoOpExecutorService();
            }
        };
        int fails = service.execMethodReturnHandler(() -> this.logger.debug("hi"));
        ReceivingServiceTest.assertEquals((int)50, (int)fails, (String)"50 retry attempts expected");
    }

    @Test
    void testExecuteAnyNull() {
        ReceivingServiceConfig build = new ReceivingServiceConfigBuilder(null).withRetryHandler(null).build();
        ReceivingService service = new ReceivingService("", build){

            ExecutorService getExecutor(ExecutorNames _executor) {
                return new NoOpExecutorService();
            }
        };
        int noExecName = service.execOrFail(null, () -> this.logger.debug("hi"));
        int noRunnable = service.execOrFail(ExecutorNames.METHODCALL, null);
        int nonOfAll = service.execOrFail(null, null);
        ReceivingServiceTest.assertEquals((int)-1, (int)noExecName, (String)"-1 retries expected");
        ReceivingServiceTest.assertEquals((int)-1, (int)noRunnable, (String)"-1 retries expected");
        ReceivingServiceTest.assertEquals((int)-1, (int)nonOfAll, (String)"-1 retries expected");
    }

    @Test
    void testRetryHandlerNotCalledBecauseNoFailure() {
        AtomicBoolean handlerWasCalled = new AtomicBoolean();
        IThreadPoolRetryHandler handler = (executor, ex) -> {
            handlerWasCalled.set(true);
            return true;
        };
        ReceivingServiceConfig build = new ReceivingServiceConfigBuilder(null).withRetryHandler(handler).build();
        ReceivingService service = new ReceivingService("", build){

            ExecutorService getExecutor(ExecutorNames _executor) {
                NoOpExecutorService noOpExecutorService = new NoOpExecutorService();
                noOpExecutorService.throwException = false;
                return noOpExecutorService;
            }
        };
        int fails = service.execErrorHandler(() -> this.logger.debug("hi"));
        ReceivingServiceTest.assertEquals((int)0, (int)fails, (String)"0 retry attempts expected");
        ReceivingServiceTest.assertFalse((boolean)handlerWasCalled.get(), (String)"Handler should not have been called");
    }

    @Test
    void testExecutorNull() {
        ReceivingServiceConfig build = new ReceivingServiceConfigBuilder(null).withRetryHandler(null).build();
        ReceivingService service = new ReceivingService("", build){

            ExecutorService getExecutor(ExecutorNames _executor) {
                return null;
            }
        };
        IllegalThreadPoolStateException ex = (IllegalThreadPoolStateException)ReceivingServiceTest.assertThrows(IllegalThreadPoolStateException.class, () -> service.execOrFail(ExecutorNames.SIGNAL, () -> this.logger.debug("hi")));
        ReceivingServiceTest.assertEquals((Object)("No executor found for " + String.valueOf(ExecutorNames.SIGNAL)), (Object)ex.getMessage());
    }

    @Test
    void testExecutorShutdownOrTerminated() {
        ReceivingServiceConfig build = new ReceivingServiceConfigBuilder(null).withRetryHandler(null).build();
        final NoOpExecutorService exec = new NoOpExecutorService();
        exec.shutdown = true;
        ReceivingService service = new ReceivingService(this, "", build){
            final /* synthetic */ ReceivingServiceTest this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1);
            }

            ExecutorService getExecutor(ExecutorNames _executor) {
                return exec;
            }
        };
        IllegalThreadPoolStateException ex = (IllegalThreadPoolStateException)ReceivingServiceTest.assertThrows(IllegalThreadPoolStateException.class, () -> service.execOrFail(ExecutorNames.SIGNAL, () -> this.logger.debug("hi")));
        ReceivingServiceTest.assertEquals((Object)"Receiving service already closed", (Object)ex.getMessage());
        exec.shutdown = false;
        exec.terminated = true;
        IllegalThreadPoolStateException ex2 = (IllegalThreadPoolStateException)ReceivingServiceTest.assertThrows(IllegalThreadPoolStateException.class, () -> service.execOrFail(ExecutorNames.SIGNAL, () -> this.logger.debug("hi")));
        ReceivingServiceTest.assertEquals((Object)"Receiving service already closed", (Object)ex2.getMessage());
    }

    @Test
    void testReceivingServiceClosed() {
        ReceivingServiceConfig build = new ReceivingServiceConfigBuilder(null).withRetryHandler(null).build();
        ReceivingService service = new ReceivingService("", build){

            ExecutorService getExecutor(ExecutorNames _executor) {
                return new NoOpExecutorService();
            }
        };
        service.shutdownNow();
        IllegalThreadPoolStateException ex = (IllegalThreadPoolStateException)ReceivingServiceTest.assertThrows(IllegalThreadPoolStateException.class, () -> service.execOrFail(ExecutorNames.SIGNAL, () -> this.logger.debug("hi")));
        ReceivingServiceTest.assertEquals((Object)"Receiving service already closed", (Object)ex.getMessage());
    }

    class NoOpExecutorService
    implements ExecutorService {
        private boolean throwException = true;
        private boolean shutdown;
        private boolean terminated;

        NoOpExecutorService() {
        }

        @Override
        public void execute(Runnable _command) {
            if (this.throwException) {
                throw new NullPointerException("This executor is broken");
            }
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return this.shutdown;
        }

        @Override
        public boolean isTerminated() {
            return this.terminated;
        }

        @Override
        public boolean awaitTermination(long _timeout, TimeUnit _unit) throws InterruptedException {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> _task) {
            return null;
        }

        @Override
        public <T> Future<T> submit(Runnable _task, T _result) {
            return null;
        }

        @Override
        public Future<?> submit(Runnable _task) {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> _tasks) throws InterruptedException {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> _tasks, long _timeout, TimeUnit _unit) throws InterruptedException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> _tasks) throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> _tasks, long _timeout, TimeUnit _unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }
}

