/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.matchrules;

import org.freedesktop.dbus.matchrules.DBusMatchRule;
import org.freedesktop.dbus.matchrules.DBusMatchRuleBuilder;
import org.freedesktop.dbus.messages.constants.MessageTypes;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.junit.jupiter.api.Test;

public class DBusMatchRuleBuilderTest
extends AbstractBaseTest {
    @Test
    void testEmptyBuild() {
        DBusMatchRuleBuilderTest.assertThrows(IllegalStateException.class, () -> DBusMatchRuleBuilder.create().build());
    }

    @Test
    void testArgTooLarge() {
        DBusMatchRuleBuilderTest.assertThrows(IllegalArgumentException.class, () -> DBusMatchRuleBuilder.create().withArg0123(100, this.getShortTestMethodName()).build());
        DBusMatchRuleBuilderTest.assertThrows(IllegalArgumentException.class, () -> DBusMatchRuleBuilder.create().withArg0123(-1, this.getShortTestMethodName()).build());
    }

    @Test
    void testInvalidCombination() {
        DBusMatchRuleBuilderTest.assertThrows(IllegalArgumentException.class, () -> DBusMatchRuleBuilder.create().withPath("xx").withPathNamespace("y").build());
        DBusMatchRuleBuilderTest.assertThrows(IllegalArgumentException.class, () -> DBusMatchRuleBuilder.create().withPathNamespace("!").withPath("?").build());
    }

    @Test
    void testBuild() {
        DBusMatchRule dBusMatchRule = DBusMatchRuleBuilder.create().withType(MessageTypes.ERROR).withDestination("foo").withInterface("x.y").withSender("sen.der").build();
        DBusMatchRuleBuilderTest.assertEquals((Object)MessageTypes.ERROR.getMatchRuleName(), (Object)dBusMatchRule.getMessageType());
        DBusMatchRuleBuilderTest.assertEquals((Object)"foo", (Object)dBusMatchRule.getDestination());
        DBusMatchRuleBuilderTest.assertEquals((Object)"x.y", (Object)dBusMatchRule.getInterface());
        DBusMatchRuleBuilderTest.assertEquals((Object)"sen.der", (Object)dBusMatchRule.getSender());
    }
}

