/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.matchrules;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.matchrules.MatchRuleField;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.constants.MessageTypes;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class MatchRuleFieldTest
extends AbstractBaseTest {
    @Test
    void testMatchArg0Namespace() throws DBusException {
        Message msg = new Message(){

            public String getSig() {
                return "s";
            }

            public Object[] getParameters() throws DBusException {
                return new Object[]{"/com/example/foo/bar"};
            }
        };
        MatchRuleFieldTest.assertTrue((boolean)MatchRuleField.ARG0NAMESPACE.getSingleMatcher().test(msg, "/com/example/foo"));
        MatchRuleFieldTest.assertTrue((boolean)MatchRuleField.ARG0NAMESPACE.getSingleMatcher().test(msg, "/com/example/foo/bar"));
        MatchRuleFieldTest.assertFalse((boolean)MatchRuleField.ARG0NAMESPACE.getSingleMatcher().test(msg, "/com/example/foobar"));
    }

    @Test
    void testMatchPathNamespace() throws DBusException {
        Message msg = new Message(){

            public String getPath() {
                return "/com/example/foo/bar";
            }
        };
        MatchRuleFieldTest.assertTrue((boolean)MatchRuleField.PATH_NAMESPACE.getSingleMatcher().test(msg, "/com/example/foo"));
        MatchRuleFieldTest.assertTrue((boolean)MatchRuleField.PATH_NAMESPACE.getSingleMatcher().test(msg, "/com/example/foo/bar"));
        MatchRuleFieldTest.assertFalse((boolean)MatchRuleField.PATH_NAMESPACE.getSingleMatcher().test(msg, "/com/example/foobar"));
    }

    @Test
    void testMatchMsgType() throws DBusException {
        Message msg = new Message(){

            public byte getType() {
                return MessageTypes.SIGNAL.getId();
            }
        };
        MatchRuleFieldTest.assertTrue((boolean)MatchRuleField.TYPE.getSingleMatcher().test(msg, "signal"));
        MatchRuleFieldTest.assertFalse((boolean)MatchRuleField.TYPE.getSingleMatcher().test(msg, "error"));
    }

    @Test
    void testMatchSender() throws DBusException {
        Message msg = new Message(){

            public String getSource() {
                return "org.freedesktop.Hal";
            }
        };
        MatchRuleFieldTest.assertTrue((boolean)MatchRuleField.SENDER.getSingleMatcher().test(msg, "org.freedesktop.Hal"));
        MatchRuleFieldTest.assertFalse((boolean)MatchRuleField.PATH.getSingleMatcher().test(msg, "org.freedesktop.DBus"));
    }

    @Test
    void testMatchPath() throws DBusException {
        Message msg = new Message(){

            public String getPath() {
                return "/org/freedesktop/Hal/Manager";
            }
        };
        MatchRuleFieldTest.assertTrue((boolean)MatchRuleField.PATH.getSingleMatcher().test(msg, "/org/freedesktop/Hal/Manager"));
        MatchRuleFieldTest.assertFalse((boolean)MatchRuleField.PATH.getSingleMatcher().test(msg, "/org/freedesktop/Hal/ObjectMapper"));
    }

    @Test
    void testMatchMember() throws DBusException {
        Message msg = new Message(){

            public String getName() {
                return "NameOwnerChanged";
            }
        };
        MatchRuleFieldTest.assertTrue((boolean)MatchRuleField.MEMBER.getSingleMatcher().test(msg, "NameOwnerChanged"));
        MatchRuleFieldTest.assertFalse((boolean)MatchRuleField.MEMBER.getSingleMatcher().test(msg, "NameOwner"));
    }

    @Test
    void testMatchInterface() throws DBusException {
        Message msg = new Message(){

            public String getInterface() {
                return "org.freedesktop.Interface";
            }
        };
        MatchRuleFieldTest.assertTrue((boolean)MatchRuleField.INTERFACE.getSingleMatcher().test(msg, "org.freedesktop.Interface"));
        MatchRuleFieldTest.assertFalse((boolean)MatchRuleField.INTERFACE.getSingleMatcher().test(msg, "org.freedesktop.Other"));
    }

    @Test
    void testMatchDestination() throws DBusException {
        Message msg = new Message(){

            public String getDestination() {
                return "dest";
            }
        };
        MatchRuleFieldTest.assertTrue((boolean)MatchRuleField.DESTINATION.getSingleMatcher().test(msg, "dest"));
        MatchRuleFieldTest.assertFalse((boolean)MatchRuleField.DESTINATION.getSingleMatcher().test(msg, "xxx"));
    }

    @ParameterizedTest
    @MethodSource(value={"createArg0123PathTestData"})
    void testMatchArg0123Path(List<Object> _results, Map<Integer, String> _matcher, boolean _matchResult) throws DBusException {
        this.multiArgsTest(MatchRuleField.ARG0123PATH, _results, _matcher, _matchResult);
    }

    @ParameterizedTest
    @MethodSource(value={"createArg0123TestData"})
    void testMatchArg0123(List<Object> _results, Map<Integer, String> _matcher, boolean _matchResult) throws DBusException {
        this.multiArgsTest(MatchRuleField.ARG0123, _results, _matcher, _matchResult);
    }

    private void multiArgsTest(MatchRuleField _field, final List<Object> _results, Map<Integer, String> _matcher, boolean _matchResult) throws DBusException {
        Type[] dataTypes = (Type[])_results.stream().map(e -> e.getClass()).toArray(Type[]::new);
        final String dBusType = Marshalling.getDBusType((Type[])dataTypes);
        Message msg = new Message(this){
            final /* synthetic */ MatchRuleFieldTest this$0;
            {
                this.this$0 = this$0;
            }

            public String getSig() {
                return dBusType;
            }

            public Object[] getParameters() throws DBusException {
                return _results.toArray();
            }
        };
        MatchRuleFieldTest.assertEquals((Object)_matchResult, (Object)_field.getMultiMatcher().test(msg, _matcher));
    }

    static Stream<Arguments> createArg0123TestData() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{List.of("test"), Map.of(0, "test"), true}), Arguments.arguments((Object[])new Object[]{List.of("test", Integer.valueOf(1)), Map.of(0, "foo"), false}), Arguments.arguments((Object[])new Object[]{List.of("test"), Map.of(0, "te"), false}));
    }

    static Stream<Arguments> createArg0123PathTestData() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/"), Map.of(0, "/"), true}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/"), Map.of(0, "/aa/"), true}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/"), Map.of(0, "/aa/bb/"), true}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/cc/"), Map.of(0, "/aa/bb/"), true}), Arguments.arguments((Object[])new Object[]{List.of(new DBusPath("/aa/bb/cc")), Map.of(0, "/aa/bb/"), true}), Arguments.arguments((Object[])new Object[]{List.of("/aa/b"), Map.of(0, "/aa/bb/"), false}), Arguments.arguments((Object[])new Object[]{List.of("/aa"), Map.of(0, "/aa/bb/"), false}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb"), Map.of(0, "/aa/bb/"), false}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/", "/foo/"), Map.of(0, "/", 1, "/"), true}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/", "/foo/"), Map.of(0, "/aa/", 1, "/foo/"), true}));
    }
}

