/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.matchrules;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.matchrules.MatchRuleMatcher;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class MatchRuleMatcherTest
extends AbstractBaseTest {
    MatchRuleMatcherTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"createArg0123PathTestData"})
    void testMatchArg0123Path(final List<Object> _results, Map<Integer, String> _matcher, boolean _matchResult) throws DBusException {
        Type[] dataTypes = (Type[])_results.stream().map(e -> e.getClass()).toArray(Type[]::new);
        final String dBusType = Marshalling.getDBusType((Type[])dataTypes);
        Message msg = new Message(this){
            final /* synthetic */ MatchRuleMatcherTest this$0;
            {
                this.this$0 = this$0;
            }

            public String getSig() {
                return dBusType;
            }

            public Object[] getParameters() throws DBusException {
                return _results.toArray();
            }
        };
        MatchRuleMatcherTest.assertEquals((Object)_matchResult, (Object)MatchRuleMatcher.matchArg0123Path((Message)msg, _matcher));
    }

    @ParameterizedTest
    @MethodSource(value={"createArg0123TestData"})
    void testMatchArg0123(final List<Object> _results, Map<Integer, String> _matcher, boolean _matchResult) throws DBusException {
        Type[] dataTypes = (Type[])_results.stream().map(e -> e.getClass()).toArray(Type[]::new);
        final String dBusType = Marshalling.getDBusType((Type[])dataTypes);
        Message msg = new Message(this){
            final /* synthetic */ MatchRuleMatcherTest this$0;
            {
                this.this$0 = this$0;
            }

            public String getSig() {
                return dBusType;
            }

            public Object[] getParameters() throws DBusException {
                return _results.toArray();
            }
        };
        MatchRuleMatcherTest.assertEquals((Object)_matchResult, (Object)MatchRuleMatcher.matchArg0123((Message)msg, _matcher));
    }

    static Stream<Arguments> createArg0123TestData() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{List.of("test"), Map.of(0, "test"), true}), Arguments.arguments((Object[])new Object[]{List.of("test", Integer.valueOf(1)), Map.of(0, "foo"), false}), Arguments.arguments((Object[])new Object[]{List.of("test"), Map.of(0, "te"), false}));
    }

    static Stream<Arguments> createArg0123PathTestData() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/"), Map.of(0, "/"), true}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/"), Map.of(0, "/aa/"), true}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/"), Map.of(0, "/aa/bb/"), true}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/cc/"), Map.of(0, "/aa/bb/"), true}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/cc"), Map.of(0, "/aa/bb/"), true}), Arguments.arguments((Object[])new Object[]{List.of("/aa/b"), Map.of(0, "/aa/bb/"), false}), Arguments.arguments((Object[])new Object[]{List.of("/aa"), Map.of(0, "/aa/bb/"), false}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb"), Map.of(0, "/aa/bb/"), false}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/", "/foo/"), Map.of(0, "/", 1, "/"), true}), Arguments.arguments((Object[])new Object[]{List.of("/aa/bb/", "/foo/"), Map.of(0, "/aa/", 1, "/foo/"), true}));
    }
}

