/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class MessageTest
extends AbstractBaseTest {
    @Test
    public void testReadMessageHeader() throws Exception {
        byte[] headerBytes = new byte[]{61, 0, 0, 0, 0, 0, 0, 0, 6, 1, 115, 0, 5, 0, 0, 0, 58, 49, 46, 50, 48, 0, 0, 0, 5, 1, 117, 0, 1, 0, 0, 0, 8, 1, 103, 0, 1, 115, 0, 0, 7, 1, 115, 0, 20, 0, 0, 0, 111, 114, 103, 46, 102, 114, 101, 101, 100, 101, 115, 107, 116, 111, 112, 46, 68, 66, 117, 115, 0, 0, 0, 0};
        Object[] extractHeader = new Message().extractHeader(headerBytes);
        MessageTest.assertEquals((int)1, (int)extractHeader.length);
        MessageTest.assertInstanceOf(List.class, (Object)extractHeader[0]);
        List objectList = (List)extractHeader[0];
        MessageTest.assertEquals((int)4, (int)objectList.size());
        for (Object object : objectList) {
            Object[] o = (Object[])object;
            this.logger.debug("{} ---> {}", (Object)String.valueOf(o[0]), o[1]);
        }
        Object[] entry1 = (Object[])objectList.get(0);
        MessageTest.assertEquals((Object)6, (Object)entry1[0]);
        MessageTest.assertEquals((Object)":1.20", (Object)entry1[1]);
        Object[] entry2 = (Object[])objectList.get(1);
        MessageTest.assertEquals((Object)5, (Object)entry2[0]);
        MessageTest.assertEquals((Object)new UInt32(1L), (Object)entry2[1]);
        Object[] entry3 = (Object[])objectList.get(2);
        MessageTest.assertEquals((Object)8, (Object)entry3[0]);
        MessageTest.assertEquals((Object)"s", (Object)entry3[1]);
        Object[] entry4 = (Object[])objectList.get(3);
        MessageTest.assertEquals((Object)7, (Object)entry4[0]);
        MessageTest.assertEquals((Object)"org.freedesktop.DBus", (Object)entry4[1]);
    }

    static Stream<ParameterData> parameterSource() {
        return Stream.of(new ParameterData("Complex constructor", List.of(new Type[]{Long.TYPE, String.class, byte[].class, String.class, Map.class}, new Type[]{String.class}), List.of(Long.class, String.class, new DBusListType(Byte.class), String.class, new DBusMapType(CharSequence.class, Variant.class)), List.of(Message.ConstructorArgType.NOT_ARRAY_TYPE, Message.ConstructorArgType.NOT_ARRAY_TYPE, Message.ConstructorArgType.PRIMITIVE_ARRAY, Message.ConstructorArgType.NOT_ARRAY_TYPE, Message.ConstructorArgType.NOT_ARRAY_TYPE)), new ParameterData("Byte array constructor", List.of(new Type[]{Byte[].class, String.class}, new Type[]{Integer.class, String.class}), List.of(new DBusListType(Byte.class), String.class), List.of(Message.ConstructorArgType.ARRAY, Message.ConstructorArgType.NOT_ARRAY_TYPE)), new ParameterData("Primitive Byte array constructor", List.of(new Type[]{byte[].class, String.class}, new Type[]{Integer.class, String.class}), List.of(new DBusListType(Byte.TYPE), String.class), List.of(Message.ConstructorArgType.PRIMITIVE_ARRAY, Message.ConstructorArgType.NOT_ARRAY_TYPE)), new ParameterData("Byte array and List of Array constructor", List.of(new Type[]{byte[].class, String.class}, new Type[]{new DBusListType(Byte.class), String.class}), List.of(new DBusListType(Byte.TYPE), String.class), List.of(Message.ConstructorArgType.PRIMITIVE_ARRAY, Message.ConstructorArgType.NOT_ARRAY_TYPE)), new ParameterData("Byte array and different second argument", List.of(new Type[]{byte[].class, Long.TYPE}, new Type[]{byte[].class, String.class}), List.of(new DBusListType(Byte.TYPE), String.class), List.of(Message.ConstructorArgType.PRIMITIVE_ARRAY, Message.ConstructorArgType.NOT_ARRAY_TYPE)), new ParameterData("Byte List constructor", List.of(new Type[]{List.class, Integer.TYPE}, new Type[]{Long.class}), List.of(new DBusListType(Byte.class), Integer.TYPE), List.of(Message.ConstructorArgType.COLLECTION, Message.ConstructorArgType.NOT_ARRAY_TYPE)), new ParameterData("No arrays in constructor", List.of(new Type[]{Integer.class, String.class}, new Type[]{Integer.class, Integer.class}), List.of(String.class, String.class, Integer.class), List.of()));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameterSource"})
    void testExtractParameter(ParameterData _data) {
        MessageTest.assertEquals(_data.expected(), (Object)Message.usesPrimitives(_data.constructorArgs(), _data.wanted()));
    }

    record ParameterData(String name, List<Type[]> constructorArgs, List<Type> wanted, List<Message.ConstructorArgType> expected) {
        @Override
        public String toString() {
            return this.name;
        }
    }
}

