/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Optional;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseTest
extends Assertions {
    protected static final long MAX_WAIT = Duration.ofSeconds(30L).toMillis();
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TestInfo lastTestInfo;

    @BeforeEach
    public final void setTestMethodName(TestInfo _testInfo) {
        this.lastTestInfo = _testInfo;
    }

    protected final String getTestMethodName() {
        if (this.lastTestInfo != null && this.lastTestInfo.getTestClass().isPresent()) {
            return ((Class)this.lastTestInfo.getTestClass().get()).getName() + "." + ((Method)this.lastTestInfo.getTestMethod().get()).getName();
        }
        return null;
    }

    protected final String getShortTestMethodName() {
        Optional testMethod = this.lastTestInfo == null ? Optional.empty() : this.lastTestInfo.getTestMethod();
        return testMethod.map(Method::getName).orElse(null);
    }

    @BeforeEach
    public final void logTestBegin(TestInfo _testInfo) {
        this.logTestBeginEnd("BGN", _testInfo);
    }

    @AfterEach
    public final void logTestEnd(TestInfo _testInfo) {
        this.logTestBeginEnd("END", _testInfo);
    }

    protected void logTestBeginEnd(String _prefix, TestInfo _testInfo) {
        if (!_testInfo.getTestMethod().isPresent() || _testInfo.getDisplayName().startsWith(((Method)_testInfo.getTestMethod().get()).getName())) {
            this.logger.info(">>>>>>>>>> {} Test: {} <<<<<<<<<<", (Object)_prefix, (Object)_testInfo.getDisplayName());
        } else {
            this.logger.info(">>>>>>>>>> {} Test: {} ({}) <<<<<<<<<<", new Object[]{_prefix, ((Method)_testInfo.getTestMethod().get()).getName(), _testInfo.getDisplayName()});
        }
    }
}

