/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusDaemonBaseTest;
import org.freedesktop.dbus.test.helper.SampleClass;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractDBusBaseTest
extends AbstractDBusDaemonBaseTest {
    protected DBusConnection serverconn = null;
    protected DBusConnection clientconn = null;
    protected SampleClass tclass;

    @BeforeEach
    public void setUp() throws DBusException {
        this.serverconn = DBusConnectionBuilder.forSessionBus().withShared(false).build();
        this.clientconn = DBusConnectionBuilder.forSessionBus().withShared(false).build();
        this.serverconn.requestBusName(this.getTestBusName());
        this.logger.info("Client-Conn UniqueID: {}, Server-Conn Unique-ID: {}", (Object)this.clientconn.getUniqueName(), (Object)this.serverconn.getUniqueName());
        this.tclass = new SampleClass(this.serverconn);
        this.serverconn.exportObject(this.getTestObjectPath(), (DBusInterface)this.tclass);
        this.serverconn.addFallback(this.getTestObjectPath() + "FallbackTest", (DBusInterface)this.tclass);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.logger.debug("Checking for outstanding errors");
        DBusExecutionException dbee = this.serverconn.getError();
        if (null != dbee) {
            throw dbee;
        }
        dbee = this.clientconn.getError();
        if (null != dbee) {
            throw dbee;
        }
        this.logger.debug("Disconnecting");
        this.clientconn.disconnect();
        this.serverconn.releaseBusName(this.getTestBusName());
        this.serverconn.disconnect();
    }

    protected String getTestObjectPath() {
        return "/" + ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected String getTestBusName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

