/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.errors.ServiceUnknown;
import org.freedesktop.dbus.errors.UnknownObject;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBus;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Peer;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.freedesktop.dbus.test.helper.SampleException;
import org.freedesktop.dbus.test.helper.SampleSerializable;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface2;
import org.freedesktop.dbus.utils.TimeMeasure;
import org.junit.jupiter.api.Test;

public class BaseFunctionsTest
extends AbstractDBusBaseTest {
    @Test
    public void testPing() throws DBusException {
        this.logger.debug("Pinging ourselves");
        Peer peer = (Peer)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), Peer.class);
        TimeMeasure timeMeasure = new TimeMeasure();
        BaseFunctionsTest.assertDoesNotThrow(() -> {
            for (int i = 0; i < 10; ++i) {
                timeMeasure.reset();
                peer.Ping();
                this.logger.debug("Ping returned in " + timeMeasure.getElapsed() + "ms.");
            }
        });
    }

    @Test
    public void testDbusNames() throws DBusException {
        DBus dbus = (DBus)this.clientconn.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        Object[] names = dbus.ListNames();
        this.logger.debug("Names on bus: {}", (Object)Arrays.toString(names));
        BaseFunctionsTest.assertTrue((boolean)Arrays.asList(names).contains(this.getTestBusName()));
    }

    @Test
    public void testSerialization() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface2.class);
        ArrayList<Integer> v = new ArrayList<Integer>();
        v.add(1);
        v.add(2);
        v.add(3);
        SampleSerializable<String> s = new SampleSerializable<String>(1, "woo", v);
        s = tri2.testSerializable((byte)12, s, 13);
        this.logger.debug("returned: " + String.valueOf(s));
        if (s.getInt() != 1 || !s.getString().equals("woo") || s.getList().size() != 3 || s.getList().get(0) != 1 || s.getList().get(1) != 2 || s.getList().get(2) != 3) {
            BaseFunctionsTest.fail((String)"Didn't get back the same TestSerializable");
        }
    }

    @Test
    public void testIntrospection() throws DBusException {
        this.logger.debug("Getting our introspection data");
        Introspectable intro = (Introspectable)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), Introspectable.class);
        String data = intro.Introspect();
        BaseFunctionsTest.assertNotNull((Object)data);
        BaseFunctionsTest.assertTrue((boolean)data.startsWith("<!DOCTYPE"));
    }

    @Test
    public void testExportPath() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface2.class);
        this.logger.debug("Calling the other introspect method: ");
        String intro2 = tri2.Introspect();
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        if (0 != col.compare("Not XML", intro2)) {
            BaseFunctionsTest.fail((String)"Introspect return value incorrect");
        }
    }

    @Test
    public void testGetProperties() throws DBusException {
        Properties prop = (Properties)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), Properties.class);
        DBusPath prv = (DBusPath)prop.Get("foo.bar", "foo");
        this.logger.debug("Got path " + String.valueOf(prv));
        BaseFunctionsTest.assertEquals((Object)"/nonexistant/path", (Object)prv.getPath());
    }

    @Test
    public void testException() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject(this.getTestBusName(), this.getTestObjectPath());
        SampleException ex = (SampleException)((Object)BaseFunctionsTest.assertThrows(SampleException.class, () -> tri.throwme()));
        BaseFunctionsTest.assertEquals((Object)"test", (Object)ex.getMessage(), (String)("Remote Method Failed with: " + ((Object)((Object)ex)).getClass().getName() + " " + ex.getMessage()));
    }

    @Test
    public void testFails() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject(this.getTestBusName(), this.getTestObjectPath());
        try {
            this.logger.debug("Calling Method2");
            tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.NotATest", "/Moofle", SampleRemoteInterface.class);
            this.logger.debug("(mth2) Got Remote Name: {}", (Object)tri.getName());
            BaseFunctionsTest.fail((String)"(mth2) Method Execution should have failed");
        }
        catch (ServiceUnknown _ex) {
            this.logger.debug("(mth2) Remote Method Failed with: {} {}", (Object)((Object)((Object)_ex)).getClass().getName(), (Object)_ex.getMessage());
        }
        try {
            this.logger.debug("Calling Method3");
            tri = (SampleRemoteInterface)this.clientconn.getRemoteObject(this.getTestBusName(), "/Moofle", SampleRemoteInterface.class);
            this.logger.debug("(mth3) Got Remote Name: {}", (Object)tri.getName());
            BaseFunctionsTest.fail((String)"Method Execution should have failed");
        }
        catch (UnknownObject _ex) {
            this.logger.debug("(mth3) Remote Method Failed with: {} {}", (Object)((Object)((Object)_ex)).getClass().getName(), (Object)_ex.getMessage());
        }
        try {
            this.logger.debug("Calling Method4");
            tri = (SampleRemoteInterface)this.clientconn.getRemoteObject(this.getTestBusName(), "/BadTest", SampleRemoteInterface.class);
            this.logger.debug("(mth4) Got Remote Name: {}", (Object)tri.getName());
            BaseFunctionsTest.fail((String)"Method Execution should have failed");
        }
        catch (UnknownObject _ex) {
            this.logger.debug("(mth4) Remote Method Failed with: {} {}", (Object)((Object)((Object)_ex)).getClass().getName(), (Object)_ex.getMessage());
        }
    }

    @Test
    public void testOverload() throws DBusException {
        this.logger.debug("testing method overloading...");
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface2.class);
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface.class);
        BaseFunctionsTest.assertEquals((int)1, (int)tri2.overload("foo"));
        BaseFunctionsTest.assertEquals((int)2, (int)tri2.overload((byte)0));
        BaseFunctionsTest.assertEquals((int)3, (int)tri2.overload());
        BaseFunctionsTest.assertEquals((int)4, (int)tri.overload());
    }
}

