/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.freedesktop.dbus.TypeRef;
import org.freedesktop.dbus.annotations.DBusBoundProperty;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusProperty;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.test.AbstractDBusDaemonBaseTest;
import org.freedesktop.dbus.test.helper.structs.SampleStruct;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.Test;

public class BoundPropertiesTest
extends AbstractDBusDaemonBaseTest {
    @Test
    public void testGetAllProperties() throws IOException, DBusException {
        try (DBusConnection conn = DBusConnectionBuilder.forSessionBus().withShared(false).build();){
            MyObject obj = new MyObject();
            conn.requestBusName("com.acme");
            conn.exportObject((DBusInterface)obj);
            try (DBusConnection innerConn = DBusConnectionBuilder.forSessionBus().withShared(false).build();){
                Properties remotePropObj = (Properties)innerConn.getRemoteObject("com.acme", "/com/acme/MyObject", Properties.class);
                Map allProps = remotePropObj.GetAll("com.acme");
                BoundPropertiesTest.assertIterableEquals(List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(11)), (Iterable)((List)((Variant)allProps.get("AList")).getValue()));
                BoundPropertiesTest.assertEquals(new TreeMap<String, Long>(Map.of("Key 1", 123L, "Key 2", Long.MAX_VALUE, "Key 3", Long.MIN_VALUE)), (Object)((Variant)allProps.get("AMap")).getValue());
            }
        }
    }

    @Test
    public void testGetAllPropertiesFromMixed() throws IOException, DBusException {
        try (DBusConnection conn = DBusConnectionBuilder.forSessionBus().withShared(false).build();){
            MixedPropObj obj = new MixedPropObj();
            conn.requestBusName("com.acme.mixed");
            conn.exportObject((DBusInterface)obj);
            try (DBusConnection innerConn = DBusConnectionBuilder.forSessionBus().withShared(false).build();){
                Properties remotePropObj = (Properties)innerConn.getRemoteObject("com.acme.mixed", "/com/acme/mixed/MyMixedObject", Properties.class);
                Map allProps = remotePropObj.GetAll("com.acme.mixed");
                BoundPropertiesTest.assertIterableEquals(List.of("x", "y"), (Iterable)((List)((Variant)allProps.get("list")).getValue()));
                BoundPropertiesTest.assertIterableEquals(List.of(Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)), (Iterable)((List)((Variant)allProps.get("intlist")).getValue()));
            }
        }
    }

    @Test
    public void testProperties() throws IOException, DBusException {
        try (DBusConnection conn = DBusConnectionBuilder.forSessionBus().withShared(false).build();){
            MyObject obj = new MyObject();
            conn.requestBusName("com.acme");
            conn.exportObject((DBusInterface)obj);
            try (DBusConnection innerConn = DBusConnectionBuilder.forSessionBus().withShared(false).build();){
                MyInterface myObject = (MyInterface)innerConn.getRemoteObject("com.acme", "/com/acme/MyObject", MyInterface.class);
                BoundPropertiesTest.assertEquals((Object)"Hello!", (Object)myObject.sayHello());
                BoundPropertiesTest.assertEquals((Object)"Initial value", (Object)myObject.getMyProperty());
                BoundPropertiesTest.assertFalse((boolean)myObject.isMyOtherProperty());
                BoundPropertiesTest.assertEquals((long)123L, (long)myObject.getMyAltProperty());
                BoundPropertiesTest.assertEquals((Object)((Object)AnEnum.ABC), (Object)((Object)myObject.getAnEnum()));
                BoundPropertiesTest.assertArrayEquals((Object[])new String[]{"Item 1", "Item 2"}, (Object[])myObject.getArrayOfStuff());
                BoundPropertiesTest.assertEquals(Arrays.asList(1, 3, 5, 7, 11), myObject.getAList());
                BoundPropertiesTest.assertEquals(Map.of("Key 1", 123L, "Key 2", Long.MAX_VALUE, "Key 3", Long.MIN_VALUE), myObject.getAMap());
                SampleStruct struct = myObject.getStruct();
                BoundPropertiesTest.assertEquals((Object)"A", (Object)struct.getStringValue());
                BoundPropertiesTest.assertEquals((Object)new UInt32(123L), (Object)struct.getInt32Value());
                BoundPropertiesTest.assertEquals((Object)new Variant((Object)true), struct.getVariantValue());
                myObject.setMyProperty("New value");
                myObject.setMyOtherProperty(true);
                myObject.setMyAltProperty(987L);
                myObject.setAnEnum(AnEnum.DEF);
                myObject.setArrayOfStuff(new String[]{"Another Item A", "Another Item B", "Another Item C"});
                SampleStruct struct2 = new SampleStruct("XXXX", new UInt32(999L), new Variant((Object)false));
                myObject.setStruct(struct2);
                myObject.setAList(Arrays.asList(999, 998, 997, 996));
                myObject.setAMap(Map.of("Key 4", 567L, "Key 5", 0x3FFFFFFFFFFFFFFFL, "Key 6", -4611686018427387904L));
                BoundPropertiesTest.assertEquals((Object)"New value", (Object)myObject.getMyProperty());
                BoundPropertiesTest.assertTrue((boolean)myObject.isMyOtherProperty());
                BoundPropertiesTest.assertEquals((long)987L, (long)myObject.getMyAltProperty());
                BoundPropertiesTest.assertEquals((Object)((Object)AnEnum.DEF), (Object)((Object)myObject.getAnEnum()));
                BoundPropertiesTest.assertArrayEquals((Object[])new String[]{"Another Item A", "Another Item B", "Another Item C"}, (Object[])myObject.getArrayOfStuff());
                struct2 = myObject.getStruct();
                BoundPropertiesTest.assertEquals((Object)"XXXX", (Object)struct2.getStringValue());
                BoundPropertiesTest.assertEquals((Object)new UInt32(999L), (Object)struct2.getInt32Value());
                BoundPropertiesTest.assertEquals((Object)new Variant((Object)false), struct2.getVariantValue());
                BoundPropertiesTest.assertEquals(Arrays.asList(999, 998, 997, 996), myObject.getAList());
                BoundPropertiesTest.assertEquals(Map.of("Key 4", 567L, "Key 5", 0x3FFFFFFFFFFFFFFFL, "Key 6", -4611686018427387904L), myObject.getAMap());
            }
        }
    }

    @Test
    public void testMixedProperties() throws IOException, DBusException {
        try (DBusConnection conn = DBusConnectionBuilder.forSessionBus().withShared(false).build();){
            MixedPropObj obj = new MixedPropObj();
            conn.requestBusName("com.acme.mixed");
            conn.exportObject((DBusInterface)obj);
            try (DBusConnection innerConn = DBusConnectionBuilder.forSessionBus().withShared(false).build();){
                MixedProperties myObject = (MixedProperties)innerConn.getRemoteObject("com.acme.mixed", "/com/acme/mixed/MyMixedObject", MixedProperties.class);
                BoundPropertiesTest.assertEquals((Object)"Value by Annotation", (Object)myObject.getAnnotationProperty());
                BoundPropertiesTest.assertEquals((Object)"Mixed value", (Object)myObject.Get("com.acme.mixed.MixedProperties", "mixed"));
                myObject.setAnnotationProperty("Another Value by Annotation");
                myObject.Set("com.acme.mixed.MixedProperties", "mixed", "New mix");
                myObject.Set("com.acme.mixed.MixedProperties", "more", "More mix");
                BoundPropertiesTest.assertEquals((Object)"Another Value by Annotation", (Object)myObject.getAnnotationProperty());
                BoundPropertiesTest.assertEquals((Object)"Mixed value", (Object)myObject.Get("com.acme.mixed.MixedProperties", "mixed"));
                BoundPropertiesTest.assertEquals((Object)"More mix", (Object)myObject.Get("com.acme.mixed.MixedProperties", "more"));
                List<AbstractMap.SimpleEntry<String, Variant>> expected = List.of(new AbstractMap.SimpleEntry<String, Variant>("AnnotationProperty", new Variant((Object)"Another Value by Annotation")), new AbstractMap.SimpleEntry<String, Variant>("more", new Variant((Object)"More mix")));
                Map all = myObject.GetAll("com.acme.mixed.MixedProperties");
                for (Map.Entry entry : expected) {
                    BoundPropertiesTest.assertTrue((boolean)all.containsKey(entry.getKey()), (String)("Key not found: " + (String)entry.getKey()));
                    BoundPropertiesTest.assertEquals(entry.getValue(), all.get(entry.getKey()));
                }
            }
        }
    }

    public class MyObject
    implements MyInterface {
        private String myProperty = "Initial value";
        private boolean myOtherProperty;
        private long myAltProperty = 123L;
        private AnEnum anEnum = AnEnum.ABC;
        private SampleStruct struct = new SampleStruct("A", new UInt32(123L), new Variant((Object)true));
        private String[] arrayOfStuff = new String[]{"Item 1", "Item 2"};
        private Map<String, Long> aMap = new TreeMap<String, Long>(Map.of("Key 1", 123L, "Key 2", Long.MAX_VALUE, "Key 3", Long.MIN_VALUE));
        private List<Integer> aList = List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(11));

        @Override
        public List<Integer> getAList() {
            return this.aList;
        }

        @Override
        public void setAList(List<Integer> _aList) {
            this.aList = _aList;
        }

        @Override
        public SampleStruct getStruct() {
            return this.struct;
        }

        @Override
        public void setStruct(SampleStruct _struct) {
            this.struct = _struct;
        }

        @Override
        public AnEnum getAnEnum() {
            return this.anEnum;
        }

        @Override
        public void setAnEnum(AnEnum _anEnum) {
            this.anEnum = _anEnum;
        }

        public String getObjectPath() {
            return "/com/acme/MyObject";
        }

        @Override
        public String sayHello() {
            return "Hello!";
        }

        @Override
        public long getMyAltProperty() {
            return this.myAltProperty;
        }

        @Override
        public void setMyAltProperty(long _myAltProperty) {
            this.myAltProperty = _myAltProperty;
        }

        @Override
        public String getMyProperty() {
            return this.myProperty;
        }

        @Override
        public void setMyProperty(String _property) {
            this.myProperty = _property;
        }

        @Override
        public boolean isMyOtherProperty() {
            return this.myOtherProperty;
        }

        @Override
        public void setMyOtherProperty(boolean _property) {
            this.myOtherProperty = _property;
        }

        public boolean isRemote() {
            return false;
        }

        @Override
        public String[] getArrayOfStuff() {
            return this.arrayOfStuff;
        }

        @Override
        public void setArrayOfStuff(String[] _arrayOfStuff) {
            this.arrayOfStuff = _arrayOfStuff;
        }

        @Override
        public Map<String, Long> getAMap() {
            return this.aMap;
        }

        @Override
        public void setAMap(Map<String, Long> _aMap) {
            this.aMap = _aMap;
        }
    }

    public static class MixedPropObj
    implements MixedProperties {
        private final Map<String, Variant<?>> propVals = new HashMap();
        private String annotPropVal = "Value by Annotation";

        public MixedPropObj() {
            this.propVals.put("mixed", new Variant((Object)"Mixed value"));
            this.propVals.put("list", new Variant(List.of("x", "y"), "as"));
            this.propVals.put("intlist", new Variant(List.of(Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)), "ai"));
        }

        public <A> A Get(String _interfaceName, String _propertyName) {
            if ("mixed".equals(_propertyName)) {
                return (A)"Mixed value";
            }
            return (A)this.propVals.get(_propertyName);
        }

        public <A> void Set(String _interfaceName, String _propertyName, A _value) {
            this.propVals.put(_propertyName, new Variant(_value));
        }

        public Map<String, Variant<?>> GetAll(String _interfaceName) {
            return this.propVals;
        }

        public String getObjectPath() {
            return "/com/acme/mixed/MyMixedObject";
        }

        @Override
        public String getAnnotationProperty() {
            return this.annotPropVal;
        }

        @Override
        public void setAnnotationProperty(String _property) {
            this.annotPropVal = _property;
        }

        public String toString() {
            return "MixedPropObj [annotPropVal=" + this.annotPropVal + ", hash=" + this.hashCode() + "]";
        }
    }

    @DBusInterfaceName(value="com.acme.MyInterface")
    public static interface MyInterface
    extends DBusInterface {
        public String sayHello();

        @DBusBoundProperty(access=DBusProperty.Access.READ, name="MyProperty")
        public String getMyProperty();

        @DBusBoundProperty(access=DBusProperty.Access.WRITE, name="MyProperty")
        public void setMyProperty(String var1);

        @DBusBoundProperty(access=DBusProperty.Access.READ, name="ZZZZZZZ")
        public long getMyAltProperty();

        @DBusBoundProperty(access=DBusProperty.Access.WRITE, name="ZZZZZZZ")
        public void setMyAltProperty(long var1);

        @DBusBoundProperty
        public boolean isMyOtherProperty();

        @DBusBoundProperty
        public void setMyOtherProperty(boolean var1);

        @DBusBoundProperty
        public AnEnum getAnEnum();

        @DBusBoundProperty
        public void setAnEnum(AnEnum var1);

        @DBusBoundProperty
        public void setStruct(SampleStruct var1);

        @DBusBoundProperty
        public SampleStruct getStruct();

        @DBusBoundProperty
        public String[] getArrayOfStuff();

        @DBusBoundProperty
        public void setArrayOfStuff(String[] var1);

        @DBusBoundProperty(type=LongMap.class)
        public Map<String, Long> getAMap();

        @DBusBoundProperty(type=LongMap.class)
        public void setAMap(Map<String, Long> var1);

        @DBusBoundProperty(type=IntegerList.class)
        public List<Integer> getAList();

        @DBusBoundProperty(type=IntegerList.class)
        public void setAList(List<Integer> var1);
    }

    public static enum AnEnum {
        ABC,
        DEF,
        GHI,
        JKL;

    }

    @DBusInterfaceName(value="com.acme.mixed.MixedProperties")
    public static interface MixedProperties
    extends DBusInterface,
    Properties {
        @DBusBoundProperty(access=DBusProperty.Access.READ, name="AnnotationProperty")
        public String getAnnotationProperty();

        @DBusBoundProperty(access=DBusProperty.Access.WRITE, name="AnnotationProperty")
        public void setAnnotationProperty(String var1);
    }

    static interface LongMap
    extends TypeRef<Map<String, Long>> {
    }

    static interface IntegerList
    extends TypeRef<List<Integer>> {
    }
}

