/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.freedesktop.dbus.test.helper.NestedListCallbackHandler;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface2;
import org.freedesktop.dbus.test.helper.structs.IntStruct;
import org.freedesktop.dbus.test.helper.structs.SampleStruct4;
import org.junit.jupiter.api.Test;

public class CollectionTest
extends AbstractDBusBaseTest {
    @Test
    public void testNestedListsAsync() throws DBusException, InterruptedException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface2.class);
        ArrayList lli = new ArrayList();
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(57);
        lli.add(li);
        DBusAsyncReply checklistReply = this.clientconn.callMethodAsync((DBusInterface)tri2, "checklist", new Object[]{lli});
        Thread.sleep(500L);
        CollectionTest.assertIterableEquals(lli, (Iterable)((Iterable)checklistReply.getReply()), (String)"did not get back the same as sent in async");
        CollectionTest.assertIterableEquals(li, (Iterable)((Iterable)((List)checklistReply.getReply()).get(0)));
    }

    @Test
    public void testNestedListsCallback() throws DBusException, InterruptedException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface2.class);
        ArrayList lli = new ArrayList();
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(25);
        lli.add(li);
        NestedListCallbackHandler cbHandle = new NestedListCallbackHandler();
        this.clientconn.callWithCallback((DBusInterface)tri2, "checklist", (CallbackHandler)cbHandle, new Object[]{lli});
        Thread.sleep(500L);
        CollectionTest.assertIterableEquals(lli, cbHandle.getRetval(), (String)"did not get back the same as sent in async");
        CollectionTest.assertIterableEquals(li, (Iterable)cbHandle.getRetval().get(0));
    }

    @Test
    public void testNestedLists() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface2.class);
        ArrayList<List<Integer>> lli = new ArrayList<List<Integer>>();
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(1);
        lli.add(li);
        List<List<Integer>> reti = tri2.checklist(lli);
        if (reti.size() != 1 || reti.get(0).size() != 1 || reti.get(0).get(0) != 1) {
            CollectionTest.fail((String)"Failed to check nested lists");
        }
    }

    @Test
    public void testListOfStruct() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject(this.getTestBusName(), this.getTestObjectPath());
        IntStruct elem1 = new IntStruct(3, 7);
        IntStruct elem2 = new IntStruct(9, 14);
        List<IntStruct> list = Arrays.asList(elem1, elem2);
        SampleStruct4 param = new SampleStruct4(list);
        int[][] out = tri.testListstruct(param);
        if (out.length != 2) {
            CollectionTest.fail((String)("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out)));
        }
        CollectionTest.assertEquals((int)elem1.getValue1(), (int)out[0][0]);
        CollectionTest.assertEquals((int)elem1.getValue2(), (int)out[0][1]);
        CollectionTest.assertEquals((int)elem2.getValue1(), (int)out[1][0]);
        CollectionTest.assertEquals((int)elem2.getValue2(), (int)out[1][1]);
    }
}

