/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.errors.UnknownMethod;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.freedesktop.dbus.test.helper.SampleNewInterfaceClass;
import org.freedesktop.dbus.test.helper.interfaces.SampleNewInterface;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface2;
import org.freedesktop.dbus.test.helper.structs.SampleStruct;
import org.freedesktop.dbus.test.helper.structs.SampleTuple;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.Test;

public class ComplexTest
extends AbstractDBusBaseTest {
    @Test
    public void testDbusIgnore() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject(this.getTestBusName(), this.getTestObjectPath());
        ComplexTest.assertThrowsExactly(UnknownMethod.class, tri::thisShouldBeIgnored);
    }

    @Test
    public void testFrob() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject(this.getTestBusName(), this.getTestObjectPath());
        this.logger.debug("frobnicating");
        ArrayList<Long> ls = new ArrayList<Long>();
        ls.add(2L);
        ls.add(5L);
        ls.add(71L);
        HashMap<UInt16, Short> mus = new HashMap<UInt16, Short>();
        mus.put(new UInt16(4), (short)5);
        mus.put(new UInt16(5), (short)6);
        mus.put(new UInt16(6), (short)7);
        HashMap<String, Map<UInt16, Short>> msmus = new HashMap<String, Map<UInt16, Short>>();
        msmus.put("stuff", mus);
        int rint = tri.frobnicate(ls, msmus, 13);
        if (-5 != rint) {
            ComplexTest.fail((String)"frobnicate return value incorrect");
        }
    }

    @Test
    public void testResponse() throws DBusException, InterruptedException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface2.class);
        this.logger.debug(tri2.Introspect());
        SampleTuple<String, List<Integer>, Boolean> rv = tri2.show(234);
        this.logger.debug("Show returned: " + String.valueOf(rv));
        if (!this.clientconn.getUniqueName().equals(rv.getFirstValue()) || 1 != rv.getSecondValue().size() || 1953 != rv.getSecondValue().get(0) || !rv.getThirdValue().booleanValue()) {
            ComplexTest.fail((String)("show return value incorrect (" + rv.getFirstValue() + "," + String.valueOf(rv.getSecondValue()) + "," + String.valueOf(rv.getThirdValue()) + ")"));
        }
        this.logger.debug("Doing stuff asynchronously");
        DBusAsyncReply stuffreply = this.clientconn.callMethodAsync((DBusInterface)tri2, "dostuff", new Object[]{new SampleStruct("bar", new UInt32(52L), new Variant((Object)Boolean.TRUE))});
        Thread.sleep(500L);
        ComplexTest.assertFalse((boolean)tri2.check(), (String)"bools are broken");
        ComplexTest.assertTrue((boolean)((Boolean)stuffreply.getReply()), (String)"dostuff return value incorrect");
    }

    @Test
    public void testComplex() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface2.class);
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("cow", "moo");
        tri2.complexv((Variant<? extends Object>)new Variant(m, "a{ss}"));
        this.logger.debug("done");
        this.logger.debug("testing recursion...");
        if (0 != col.compare("This Is A UTF-8 Name: \ufeb1 !!", tri2.recursionTest(this.getTestBusName(), this.getTestObjectPath()))) {
            ComplexTest.fail((String)"recursion test failed");
        }
        this.logger.debug("done");
        this.logger.debug("testing method overloading...");
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface.class);
        if (1 != tri2.overload("foo")) {
            ComplexTest.fail((String)"wrong overloaded method called");
        }
        if (2 != tri2.overload((byte)0)) {
            ComplexTest.fail((String)"wrong overloaded method called");
        }
        if (3 != tri2.overload()) {
            ComplexTest.fail((String)"wrong overloaded method called");
        }
        if (4 != tri.overload()) {
            ComplexTest.fail((String)"wrong overloaded method called");
        }
    }

    @Test
    public void testRegression13291() {
        ComplexTest.assertDoesNotThrow(() -> {
            SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface.class);
            this.logger.debug("reg13291...");
            byte[] as = new byte[10];
            for (int i = 0; i < 10; ++i) {
                as[i] = (byte)(100 - i);
            }
            tri.reg13291(as, as);
            this.logger.debug("done");
        });
    }

    @Test
    public void testDynamicObjectCreation() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface2.class);
        SampleNewInterface tni = tri2.getNew();
        ComplexTest.assertEquals((Object)tni.getName(), (Object)SampleNewInterfaceClass.class.getSimpleName());
    }
}

