/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.InvalidInterfaceSignature;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusDaemonBaseTest;
import org.junit.jupiter.api.Test;

public class DBusConnectionTest
extends AbstractDBusDaemonBaseTest {
    @Test
    public void testBusnamesShouldBeAutoReleasedOnCloseOfNonSharedConnection() throws Exception {
        String busName = "org.freedesktop.dbus.test.TestBus";
        DBusConnection connection1 = DBusConnectionBuilder.forSessionBus().withShared(false).build();
        DBusConnection connection2 = DBusConnectionBuilder.forSessionBus().withShared(false).build();
        DBusConnectionTest.assertNotEquals((Object)connection1.getUniqueName(), (Object)connection2.getUniqueName());
        connection1.requestBusName(busName);
        DBusConnectionTest.assertThrows(DBusException.class, () -> connection2.requestBusName(busName));
        connection1.close();
        connection2.requestBusName(busName);
        connection2.close();
    }

    @Test
    public void testExportOnlyAllPublic() throws Exception {
        try (DBusConnection conn = DBusConnectionBuilder.forSessionBus().withShared(false).build();){
            ExportedObj exportedObj = new ExportedObj();
            conn.requestBusName(((Object)((Object)this)).getClass().getName());
            DBusConnectionTest.assertThrows(InvalidInterfaceSignature.class, () -> conn.exportObject((DBusInterface)exportedObj));
        }
    }

    public static class ExportedObj
    implements NonPublicInterface {
        public String getObjectPath() {
            return "/" + this.getClass().getSimpleName().toLowerCase();
        }
    }

    static interface NonPublicInterface
    extends DBusInterface {
    }
}

