/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusDaemonBaseTest;
import org.junit.jupiter.api.Test;

public class ExportNestedTest
extends AbstractDBusDaemonBaseTest {
    @Test
    public void testExportNested() throws IOException, DBusException {
        try (DBusConnection conn = DBusConnectionBuilder.forSessionBus().build();){
            MyObjectPart part1 = new MyObjectPart();
            part1.setVal1("ABC");
            part1.setVal2("123");
            MyObjectPart part2 = new MyObjectPart();
            part2.setVal1("DEF");
            part2.setVal2("456");
            MyObject myIface = new MyObject();
            myIface.getParts().addAll(Arrays.asList(part1, part2));
            conn.requestBusName("com.acme");
            conn.exportObject((DBusInterface)part1);
            conn.exportObject((DBusInterface)part2);
            conn.exportObject((DBusInterface)myIface);
            try (DBusConnection innerConn = DBusConnectionBuilder.forSessionBus().build();){
                MyInterface myObject = (MyInterface)innerConn.getRemoteObject("com.acme", "/com/acme/MyObject", MyInterface.class);
                ExportNestedTest.assertEquals((Object)"Hello!", (Object)myObject.sayHello());
                List<String> partNames = myObject.getPartNames();
                ExportNestedTest.assertEquals((int)2, (int)partNames.size());
                ExportNestedTest.assertEquals((Object)"ABC", (Object)partNames.get(0));
                ExportNestedTest.assertEquals((Object)"DEF", (Object)partNames.get(1));
                List<MyInterfacePart> parts = myObject.getParts();
                ExportNestedTest.assertEquals((int)2, (int)parts.size());
                ExportNestedTest.assertEquals((Object)"123", (Object)parts.get(0).getVal2());
                ExportNestedTest.assertEquals((Object)"456", (Object)parts.get(1).getVal2());
            }
        }
    }

    public static class MyObjectPart
    implements MyInterfacePart {
        private String val1;
        private String val2;

        @Override
        public String getVal1() {
            return this.val1;
        }

        public void setVal1(String _val1) {
            this.val1 = _val1;
        }

        @Override
        public String getVal2() {
            return this.val2;
        }

        public void setVal2(String _val2) {
            this.val2 = _val2;
        }

        public String getObjectPath() {
            return "/com/acme/MyPart" + this.val1;
        }
    }

    public static class MyObject
    implements MyInterface {
        private final List<MyInterfacePart> parts = new ArrayList<MyInterfacePart>();

        @Override
        public String sayHello() {
            return "Hello!";
        }

        @Override
        public List<MyInterfacePart> getParts() {
            return this.parts;
        }

        public String getObjectPath() {
            return "/com/acme/MyObject";
        }

        @Override
        public List<String> getPartNames() {
            return this.parts.stream().map(MyInterfacePart::getVal1).toList();
        }
    }

    @DBusInterfaceName(value="com.acme.MyInterface")
    public static interface MyInterface
    extends DBusInterface {
        public String sayHello();

        public List<MyInterfacePart> getParts();

        public List<String> getPartNames();
    }

    @DBusInterfaceName(value="com.acme.MyInterfacePart")
    public static interface MyInterfacePart
    extends DBusInterface {
        public String getVal1();

        public String getVal2();
    }
}

