/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.IOException;
import java.util.stream.Stream;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusDaemonBaseTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIf;

@EnabledIf(value="isFileDescriptorSupported", disabledReason="file descriptors not supported with the current transport")
public class FileDescriptorsTest
extends AbstractDBusDaemonBaseTest {
    public static final String TEST_OBJECT_PATH = "/FileDescriptorsTest";
    private DBusConnection serverconn = null;
    private DBusConnection clientconn = null;

    @BeforeEach
    public void setUp() throws DBusException {
        this.serverconn = DBusConnectionBuilder.forSessionBus().withShared(false).build();
        this.clientconn = DBusConnectionBuilder.forSessionBus().withShared(false).build();
        this.serverconn.requestBusName("foo.bar.Test");
        this.serverconn.exportObject(TEST_OBJECT_PATH, (DBusInterface)new FDPassingImpl());
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.logger.debug("Checking for outstanding errors");
        DBusExecutionException dbee = this.serverconn.getError();
        if (null != dbee) {
            throw dbee;
        }
        dbee = this.clientconn.getError();
        if (null != dbee) {
            throw dbee;
        }
        this.logger.debug("Disconnecting");
        this.clientconn.disconnect();
        this.serverconn.releaseBusName("foo.bar.Test");
        this.serverconn.disconnect();
    }

    public static boolean isFileDescriptorSupported() throws DBusException, IOException {
        if (!TransportBuilder.getRegisteredBusTypes().contains("UNIX")) {
            return false;
        }
        try (DBusConnection conn = DBusConnectionBuilder.forSessionBus().build();){
            boolean bl = conn.isFileDescriptorSupported();
            return bl;
        }
    }

    @Test
    public void fileDescriptorPassing() throws DBusException {
        FDPassing remoteObject = (FDPassing)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, FDPassing.class);
        Stream.of(0, 1, 2).map(FileDescriptor::new).forEach(fd -> FileDescriptorsTest.assertNotEquals((int)fd.getIntFileDescriptor(), (int)remoteObject.doNothing((FileDescriptor)fd).getIntFileDescriptor()));
    }

    private static final class FDPassingImpl
    implements FDPassing {
        private FDPassingImpl() {
        }

        public String getObjectPath() {
            return FileDescriptorsTest.TEST_OBJECT_PATH;
        }

        @Override
        public FileDescriptor doNothing(FileDescriptor _fd) {
            return _fd;
        }
    }

    public static interface FDPassing
    extends DBusInterface {
        public FileDescriptor doNothing(FileDescriptor var1);
    }
}

