/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBus;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.matchrules.DBusMatchRule;
import org.freedesktop.dbus.matchrules.DBusMatchRuleBuilder;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.constants.MessageTypes;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterfaceEnum;
import org.freedesktop.dbus.test.helper.signals.SampleSignals;
import org.freedesktop.dbus.test.helper.signals.handler.ArraySignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.BadArraySignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.EmptySignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.EnumSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.GenericHandlerWithDecode;
import org.freedesktop.dbus.test.helper.signals.handler.GenericSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.ObjectSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.PathSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.RenamedSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.SignalHandler;
import org.freedesktop.dbus.test.helper.structs.SampleStruct2;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.Test;

public class HandlerTest
extends AbstractDBusBaseTest {
    @Test
    public void testSignalHandlers() throws DBusException, InterruptedException {
        SignalHandler sigh = new SignalHandler(1, new UInt32(42L), "Bar");
        RenamedSignalHandler rsh = new RenamedSignalHandler(1, new UInt32(42L), "Bar");
        EmptySignalHandler esh = new EmptySignalHandler(1);
        ArraySignalHandler ash = new ArraySignalHandler(1);
        ObjectSignalHandler osh = new ObjectSignalHandler(1);
        PathSignalHandler psh = new PathSignalHandler(1);
        EnumSignalHandler ensh = new EnumSignalHandler(1);
        SampleRemoteInterface peer = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject(this.getTestBusName(), this.getTestObjectPath());
        DBus dbus = (DBus)this.clientconn.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        this.logger.debug("Listening for signals...");
        this.clientconn.addSigHandler(SampleSignals.TestEmptySignal.class, (DBusSigHandler)esh);
        this.clientconn.addSigHandler(SampleSignals.TestSignal.class, (DBusSigHandler)sigh);
        this.clientconn.addSigHandler(SampleSignals.TestRenamedSignal.class, (DBusSigHandler)rsh);
        String source = dbus.GetNameOwner(this.getTestBusName());
        this.clientconn.addSigHandler(SampleSignals.TestArraySignal.class, source, (DBusInterface)peer, (DBusSigHandler)ash);
        this.clientconn.addSigHandler(SampleSignals.TestObjectSignal.class, (DBusSigHandler)osh);
        this.clientconn.addSigHandler(SampleSignals.TestPathSignal.class, (DBusSigHandler)psh);
        this.clientconn.addSigHandler(SampleSignals.TestEnumSignal.class, (DBusSigHandler)ensh);
        BadArraySignalHandler bash = new BadArraySignalHandler(1);
        this.clientconn.addSigHandler(SampleSignals.TestSignal.class, bash);
        this.clientconn.removeSigHandler(SampleSignals.TestSignal.class, bash);
        this.logger.debug("done");
        this.logger.debug("Sending Signals");
        this.serverconn.sendMessage((Message)new SampleSignals.TestSignal("/foo/bar/Wibble", "Bar", new UInt32(42L)));
        this.serverconn.sendMessage((Message)new SampleSignals.TestEmptySignal("/foo/bar/Wibble"));
        this.serverconn.sendMessage((Message)new SampleSignals.TestRenamedSignal("/foo/bar/Wibble", "Bar", new UInt32(42L)));
        this.logger.debug("Sending Path Signal...");
        DBusPath path = new DBusPath("/nonexistantwooooooo");
        DBusPath p = peer.pathrv(path);
        this.logger.debug(path.toString() + " => " + p.toString());
        HandlerTest.assertEquals((Object)path, (Object)p, (String)"pathrv incorrect");
        ArrayList<DBusPath> paths = new ArrayList<DBusPath>();
        paths.add(path);
        List<DBusPath> ps = peer.pathlistrv(paths);
        this.logger.debug(((Object)paths).toString() + " => " + ps.toString());
        HashMap<DBusPath, DBusPath> pathm = new HashMap<DBusPath, DBusPath>();
        pathm.put(path, path);
        this.serverconn.sendMessage((Message)new SampleSignals.TestPathSignal(this.getTestObjectPath(), path, paths, pathm));
        this.logger.debug("Sending Array Signal...");
        ArrayList<SampleStruct2> tsl = new ArrayList<SampleStruct2>();
        ArrayList<String> l = new ArrayList<String>();
        l.add("hi");
        l.add("hello");
        l.add("hej");
        l.add("hey");
        l.add("aloha");
        tsl.add(new SampleStruct2(l, (Variant<? extends Object>)new Variant((Object)new UInt64(567L))));
        HashMap<UInt32, SampleStruct2> tsm = new HashMap<UInt32, SampleStruct2>();
        tsm.put(new UInt32(1L), new SampleStruct2(l, (Variant<? extends Object>)new Variant((Object)new UInt64(678L))));
        tsm.put(new UInt32(42L), new SampleStruct2(l, (Variant<? extends Object>)new Variant((Object)new UInt64(789L))));
        this.serverconn.sendMessage((Message)new SampleSignals.TestArraySignal(this.getTestObjectPath(), tsl, tsm));
        this.logger.debug("Sending Object Signal...");
        this.serverconn.sendMessage((Message)new SampleSignals.TestObjectSignal(this.getTestObjectPath(), this.tclass));
        this.logger.debug("Sending Enum Signal...");
        this.serverconn.sendMessage((Message)new SampleSignals.TestEnumSignal(this.getTestObjectPath(), SampleRemoteInterfaceEnum.TestEnum.TESTVAL1, Arrays.asList(SampleRemoteInterfaceEnum.TestEnum.TESTVAL2, SampleRemoteInterfaceEnum.TestEnum.TESTVAL3)));
        Thread.sleep(1000L);
        HandlerTest.assertEquals((int)1, (int)sigh.getActualTestRuns(), (String)"SignalHandler should have been called");
        HandlerTest.assertEquals((int)1, (int)esh.getActualTestRuns(), (String)"EmptySignalHandler should have been called");
        HandlerTest.assertEquals((int)1, (int)rsh.getActualTestRuns(), (String)"RenamedSignalHandler should have been called");
        HandlerTest.assertEquals((int)1, (int)ash.getActualTestRuns(), (String)"ArraySignalHandler should have been called");
        HandlerTest.assertEquals((int)1, (int)ensh.getActualTestRuns(), (String)"EnumSignalHandler should have been called");
        HandlerTest.assertEquals((int)1, (int)psh.getActualTestRuns(), (String)"PathSignalHandler should have been called");
        HandlerTest.assertEquals((int)1, (int)osh.getActualTestRuns(), (String)"ObjectSignalHandler should have been called");
        HandlerTest.assertDoesNotThrow(sigh::throwAssertionError);
        HandlerTest.assertDoesNotThrow(esh::throwAssertionError);
        HandlerTest.assertDoesNotThrow(rsh::throwAssertionError);
        HandlerTest.assertDoesNotThrow(ash::throwAssertionError);
        HandlerTest.assertDoesNotThrow(ensh::throwAssertionError);
        HandlerTest.assertDoesNotThrow(psh::throwAssertionError);
        HandlerTest.assertDoesNotThrow(osh::throwAssertionError);
        this.clientconn.removeSigHandler(SampleSignals.TestSignal.class, (DBusSigHandler)sigh);
        this.clientconn.removeSigHandler(SampleSignals.TestEmptySignal.class, (DBusSigHandler)esh);
        this.clientconn.removeSigHandler(SampleSignals.TestRenamedSignal.class, (DBusSigHandler)rsh);
        this.clientconn.removeSigHandler(SampleSignals.TestArraySignal.class, (DBusSigHandler)ash);
        this.clientconn.removeSigHandler(SampleSignals.TestObjectSignal.class, (DBusSigHandler)osh);
        this.clientconn.removeSigHandler(SampleSignals.TestPathSignal.class, (DBusSigHandler)psh);
        this.clientconn.removeSigHandler(SampleSignals.TestEnumSignal.class, (DBusSigHandler)ensh);
    }

    @Test
    public void testGenericSignalHandler() throws DBusException, InterruptedException {
        GenericSignalHandler genericHandler = new GenericSignalHandler();
        DBusMatchRule signalRule = DBusMatchRuleBuilder.create().withType(MessageTypes.SIGNAL).withInterface("org.foo").withMember("methodnoarg").withPath("/").build();
        this.clientconn.addGenericSigHandler(signalRule, (DBusSigHandler)genericHandler);
        DBusSignal signalToSend = this.clientconn.getMessageFactory().createSignal(null, "/", "org.foo", "methodnoarg", null, new Object[0]);
        this.serverconn.sendMessage((Message)signalToSend);
        Thread.sleep(1000L);
        HandlerTest.assertEquals((int)1, (int)genericHandler.getActualTestRuns(), (String)"GenericHandler should have been called");
        this.clientconn.removeGenericSigHandler(signalRule, (DBusSigHandler)genericHandler);
    }

    @Test
    public void testGenericDecodeSignalHandler() throws DBusException, InterruptedException {
        GenericHandlerWithDecode genericDecode = new GenericHandlerWithDecode(new UInt32(42L), "SampleString");
        DBusMatchRule signalRule = DBusMatchRuleBuilder.create().withType(MessageTypes.SIGNAL).withInterface("org.foo").withMember("methodarg").withPath("/").build();
        this.clientconn.addGenericSigHandler(signalRule, (DBusSigHandler)genericDecode);
        DBusSignal signalToSend = this.serverconn.getMessageFactory().createSignal(null, "/", "org.foo", "methodarg", "us", new Object[]{new UInt32(42L), "SampleString"});
        this.serverconn.sendMessage((Message)signalToSend);
        Thread.sleep(1000L);
        HandlerTest.assertDoesNotThrow(() -> {
            genericDecode.incomingSameAsExpected();
            this.clientconn.removeGenericSigHandler(signalRule, (DBusSigHandler)genericDecode);
        });
        HandlerTest.assertNull((Object)genericDecode.getAssertionError());
    }

    @Test
    public void testGenericHandlerWithNoInterface() throws DBusException, InterruptedException {
        GenericHandlerWithDecode genericDecode = new GenericHandlerWithDecode(new UInt32(42L), "SampleString");
        DBusMatchRule signalRule = DBusMatchRuleBuilder.create().withType(MessageTypes.SIGNAL).withMember("methodargNoIface").withPath("/").build();
        this.clientconn.addGenericSigHandler(signalRule, (DBusSigHandler)genericDecode);
        DBusSignal signalToSend = this.clientconn.getMessageFactory().createSignal(null, "/", "org.foo", "methodargNoIface", "us", new Object[]{new UInt32(42L), "SampleString"});
        this.serverconn.sendMessage((Message)signalToSend);
        Thread.sleep(1000L);
        HandlerTest.assertDoesNotThrow(() -> {
            genericDecode.incomingSameAsExpected();
            this.clientconn.removeGenericSigHandler(signalRule, (DBusSigHandler)genericDecode);
        });
        HandlerTest.assertNull((Object)genericDecode.getAssertionError());
    }

    @Test
    public void testFallbackHandler() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath() + "FallbackTest/0/1", SampleRemoteInterface.class);
        Introspectable intro = (Introspectable)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath() + "FallbackTest/0/4", Introspectable.class);
        HandlerTest.assertEquals((Object)"This Is A UTF-8 Name: \u0633 !!", (Object)tri.getName());
        HandlerTest.assertTrue((boolean)intro.Introspect().startsWith("<!DOCTYPE"));
    }
}

