/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MessageFactory;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.test.AbstractDBusDaemonBaseTest;
import org.freedesktop.dbus.utils.AddressBuilder;
import org.junit.jupiter.api.Test;

public class LowLevelTest
extends AbstractDBusDaemonBaseTest {
    @Test
    public void testLowLevel() {
        BusAddress address = BusAddress.of((BusAddress)AddressBuilder.getSessionConnection(null));
        this.logger.debug("Testing using address: {}", (Object)address);
        LowLevelTest.assertDoesNotThrow(() -> {
            try (AbstractTransport conn = TransportBuilder.create((BusAddress)address).build();){
                LowLevelTest.waitIfTcp();
                MessageFactory messageFactory = conn.getTransportConnection().getMessageFactory();
                MethodCall m = messageFactory.createMethodCall("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "Hello", (byte)0, null, new Object[0]);
                conn.writeMessage((Message)m);
                LowLevelTest.waitIfTcp();
                m = conn.readMessage();
                this.logger.debug(String.valueOf(m.getClass()));
                this.logger.debug(String.valueOf(m));
                m = conn.readMessage();
                this.logger.debug(String.valueOf(m.getClass()));
                this.logger.debug(String.valueOf(m));
                m = messageFactory.createMethodCall("org.freedesktop.DBus", "/", null, "Hello", (byte)0, null, new Object[0]);
                conn.writeMessage((Message)m);
                LowLevelTest.waitIfTcp();
                m = conn.readMessage();
                this.logger.debug(String.valueOf(m));
                m = messageFactory.createMethodCall("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "RequestName", (byte)0, "su", new Object[]{"org.testname", 0});
                conn.writeMessage((Message)m);
                LowLevelTest.waitIfTcp();
                m = conn.readMessage();
                this.logger.debug(String.valueOf(m));
                m = messageFactory.createSignal(null, "/foo", "org.foo", "Foo", null, new Object[0]);
                conn.writeMessage((Message)m);
                LowLevelTest.waitIfTcp();
                m = conn.readMessage();
                this.logger.debug(String.valueOf(m));
            }
        });
    }
}

