/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusTypeConversationRuntimeException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MessageFactory;
import org.freedesktop.dbus.messages.constants.MessageTypes;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.freedesktop.dbus.test.helper.structs.MarkTuple;
import org.freedesktop.dbus.test.helper.structs.SampleStruct;
import org.freedesktop.dbus.test.helper.structs.SampleTuple;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class MarshallingTest
extends AbstractBaseTest {
    MarshallingTest() {
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"createClassToSigData"})
    void testJavaClassToDBusSignature(ClassToSigData _data) {
        MarshallingTest.assertThrows(DBusTypeConversationRuntimeException.class, () -> Marshalling.convertJavaClassesToSignature((Class[])new Class[0]));
        MarshallingTest.assertEquals((Object)_data.signature(), (Object)Marshalling.convertJavaClassesToSignature((Class[])((Class[])_data.classes().toArray(Class[]::new))));
    }

    static List<ClassToSigData> createClassToSigData() {
        return List.of(new ClassToSigData("as", List.of(List.class, String.class), "List of String"), new ClassToSigData("ai", List.of(List.class, Integer.class), "List of Integer"), new ClassToSigData("as", List.of(Set.class, String.class), "Set of String"), new ClassToSigData("ai", List.of(Set.class, Integer.class), "Set of Integer"), new ClassToSigData("av", List.of(List.class, Variant.class), "List of Variant"), new ClassToSigData("a(suv)", List.of(List.class, SampleStruct.class), "List of SampleStruct"), new ClassToSigData("a", List.of(List.class, SampleTuple.class), "List of SampleTuple"), new ClassToSigData("aas", List.of(List.class, List.class, String.class), "List of List String"), new ClassToSigData("aai", List.of(List.class, List.class, Integer.class), "List of List Integer"), new ClassToSigData("a{si}", List.of(Map.class, String.class, Integer.class), "Map of String<>Integer"), new ClassToSigData("a{ii}", List.of(Map.class, Integer.class, Integer.class), "Map of Integer<>Integer"), new ClassToSigData("a{bv}", List.of(Map.class, Boolean.class, Variant.class), "Map of Boolean<>Variant"));
    }

    @Test
    void parseComplexMessageReturnsCorrectTypes() throws DBusException {
        ArrayList temp = new ArrayList();
        Marshalling.getJavaType((String)"a(oa{sv})ao", temp, (int)-1);
        MarshallingTest.assertEquals((int)2, (int)temp.size(), (String)"result must contain two types");
        MarshallingTest.assertTrue((boolean)(temp.get(0) instanceof DBusListType));
        MarshallingTest.assertTrue((boolean)(temp.get(1) instanceof DBusListType));
    }

    @Test
    void parseStructReturnsCorrectParsedCharsCount() throws Exception {
        ArrayList temp = new ArrayList();
        int parsedCharsCount = Marshalling.getJavaType((String)"(oa{sv})ao", temp, (int)1);
        MarshallingTest.assertEquals((int)8, (int)parsedCharsCount);
    }

    private static byte[] streamReader(String _file) throws IOException {
        return Files.readAllBytes(new File(_file).toPath());
    }

    @Test
    void testMarshalling() throws Exception {
        Type[] types = null;
        if (null == types) {
            Constructor<?> con = IServicesChanged.ServicesChanged.class.getDeclaredConstructors()[0];
            Type[] ts = con.getGenericParameterTypes();
            types = new Type[ts.length - 1];
            for (int i = 1; i < ts.length; ++i) {
                if (ts[i] instanceof TypeVariable) {
                    Type[] typeArray = ((TypeVariable)ts[i]).getBounds();
                    int n = typeArray.length;
                    for (int j = 0; j < n; ++j) {
                        Type b;
                        types[i - 1] = b = typeArray[j];
                    }
                    continue;
                }
                types[i - 1] = ts[i];
            }
        }
        Message msg = MessageFactory.createMessage((byte)MessageTypes.SIGNAL.getId(), (byte[])MarshallingTest.streamReader("src/test/resources/" + ((Object)((Object)this)).getClass().getSimpleName() + "/connman_sample_buf.bin"), (byte[])MarshallingTest.streamReader("src/test/resources/" + ((Object)((Object)this)).getClass().getSimpleName() + "/connman_sample_header.bin"), (byte[])MarshallingTest.streamReader("src/test/resources/" + ((Object)((Object)this)).getClass().getSimpleName() + "/connman_sample_body.bin"), null);
        Object[] params = Marshalling.deSerializeParameters((Object[])msg.getParameters(), (Type[])types, null);
        MarshallingTest.assertTrue((boolean)(params[0] instanceof List), (String)"First param is not a List");
        MarshallingTest.assertTrue((boolean)(params[1] instanceof List), (String)"Second param is not a List");
    }

    @Test
    void testDeserializeParametersWithTuple() throws Exception {
        Object[] ob = new Object[]{"rootfs.1", "marked slot rootfs.1 as good"};
        Method m = Installer.class.getDeclaredMethod("Mark", String.class, String.class);
        Type[] ts = new Type[]{m.getGenericReturnType()};
        Object[] params = Marshalling.deSerializeParameters((Object[])ob, (Type[])ts, null);
        MarshallingTest.assertTrue((boolean)(params[0] instanceof MarkTuple), (String)"First param is not a MarkTuple");
        MarkTuple mt = (MarkTuple)((Object)params[0]);
        MarshallingTest.assertEquals((Object)"rootfs.1", (Object)mt.getSlotName(), (String)"Slot name does not match after deSerialization");
        MarshallingTest.assertEquals((Object)"marked slot rootfs.1 as good", (Object)mt.getMessage(), (String)"Message does not match after deSerialization");
    }

    @Test
    void testDeserializeParametersVariant() throws Exception {
        Variant varList = new Variant(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), "ai");
        Type[] types = new Type[]{varList.getType()};
        Object[] convertParameters = Marshalling.convertParameters((Object[])new Object[]{varList}, (Type[])types, (String[])new String[]{"v"}, null);
        Object[] params = Marshalling.deSerializeParameters((Object[])convertParameters, (Type[])types, null);
        MarshallingTest.assertTrue((boolean)(params[0] instanceof Variant), (String)"Variant expected");
        Variant mt = (Variant)params[0];
        MarshallingTest.assertEquals((int)1, (Integer)((Integer)((List)mt.getValue()).get(0)), (String)"1 expected");
        MarshallingTest.assertEquals((int)2, (Integer)((Integer)((List)mt.getValue()).get(1)), (String)"2 expected");
        MarshallingTest.assertEquals((int)3, (Integer)((Integer)((List)mt.getValue()).get(2)), (String)"3 expected");
    }

    @Test
    void testDeserializeMap() throws Exception {
        DBusPath key = new DBusPath("/foo");
        DBusPath val = new DBusPath("/bar");
        Map<DBusPath, DBusPath> testMap = Map.of(key, val);
        Type[] types = new Type[]{testMap.getClass()};
        Object[] deSerializeParameters = Marshalling.deSerializeParameters((Object[])new Object[]{testMap}, (Type[])types, null);
        MarshallingTest.assertNotNull((Object)deSerializeParameters);
        Map deserializedMap = (Map)deSerializeParameters[0];
        MarshallingTest.assertNotSame(testMap, (Object)deserializedMap, (String)"Expected new object");
        MarshallingTest.assertSame(LinkedHashMap.class, deserializedMap.getClass(), (String)"Expected new LinkedHashMap");
        Map.Entry next = deserializedMap.entrySet().iterator().next();
        MarshallingTest.assertEquals((Object)key, next.getKey());
        MarshallingTest.assertEquals((Object)val, next.getValue());
        MarshallingTest.assertTrue((boolean)deserializedMap.containsKey(key));
    }

    public record ClassToSigData(String signature, List<Class<?>> classes, String description) {
        @Override
        public String toString() {
            return this.description;
        }
    }

    @DBusInterfaceName(value="net.connman.Manager")
    static interface IServicesChanged
    extends DBusInterface {

        public static class ServicesChanged
        extends DBusSignal {
            final String objectPath;
            final List<SomeData> changed;
            final List<DBusPath> removed;

            ServicesChanged(String _objectPath, List<SomeData> _k, List<DBusPath> _removedItems) throws DBusException {
                super(_objectPath, new Object[]{_k, _removedItems});
                this.objectPath = _objectPath;
                this.changed = _k;
                this.removed = _removedItems;
            }

            String getObjectPath() {
                return this.objectPath;
            }

            List<SomeData> getChanged() {
                return this.changed;
            }

            List<DBusPath> getRemoved() {
                return this.removed;
            }
        }
    }

    public static interface Installer
    extends DBusInterface {
        public MarkTuple Mark(String var1, String var2);
    }

    public record SomeData(@Position(value=0) DBusPath objectPath, @Position(value=1) Map<String, Variant<?>> properties) {
    }
}

