/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.freedesktop.dbus.test.helper.SampleException;
import org.freedesktop.dbus.test.helper.callbacks.handler.CallbackHandlerImpl;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface;
import org.junit.jupiter.api.Test;

public class MethodTest
extends AbstractDBusBaseTest {
    @Test
    public void testCallRemoteMethod() throws DBusException {
        this.logger.debug("Calling Method0/1");
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject(this.getTestBusName(), this.getTestObjectPath());
        this.logger.debug("Got Remote Object: " + String.valueOf(tri));
        String rname = tri.getName();
        this.logger.debug("Got Remote Name: " + rname);
        ArrayList ts = new ArrayList();
        Marshalling.getJavaType((String)"ya{si}", ts, (int)-1);
        tri.sig(ts.toArray(new Type[0]));
        DBusPath path = new DBusPath("/nonexistantwooooooo");
        DBusPath p = tri.pathrv(path);
        this.logger.debug(path.toString() + " => " + p.toString());
        MethodTest.assertEquals((Object)path, (Object)p, (String)"pathrv incorrect");
        ArrayList<DBusPath> paths = new ArrayList<DBusPath>();
        paths.add(path);
        List<DBusPath> ps = tri.pathlistrv(paths);
        this.logger.debug(((Object)paths).toString() + " => " + ps.toString());
        MethodTest.assertEquals(paths, ps, (String)"pathlistrv incorrect");
        HashMap<DBusPath, DBusPath> pathm = new HashMap<DBusPath, DBusPath>();
        pathm.put(path, path);
        Map<DBusPath, DBusPath> pm = tri.pathmaprv(pathm);
        MethodTest.assertNotEquals(pathm.getClass(), pm.getClass(), (String)"Expected different map implementations");
        this.logger.debug("{} => {}", pathm, pm);
        this.logger.debug("{} {} {}", new Object[]{pm.containsKey(path), pm.get(path), path.equals((Object)pm.get(path))});
        this.logger.debug("{} {} {}", new Object[]{pm.containsKey(p), pm.get(p), p.equals((Object)pm.get(p))});
        System.out.println("path hashcode: " + path.hashCode());
        System.out.println("pm key hashcode: " + pm.keySet().iterator().next().hashCode());
        MethodTest.assertTrue((boolean)pm.containsKey(path), (String)"pathmaprv missing in map");
        MethodTest.assertEquals((Object)path, (Object)pm.get(path), (String)"pathmaprv incorrect value");
    }

    @Test
    public void testCallWithCallback() throws DBusException, InterruptedException {
        CallbackHandlerImpl cbWhichThrows;
        CallbackHandlerImpl cbWhichWorks;
        block2: {
            SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath());
            this.logger.debug("Doing stuff asynchronously with callback");
            cbWhichWorks = new CallbackHandlerImpl();
            this.clientconn.callWithCallback((DBusInterface)tri, "getName", (CallbackHandler)cbWhichWorks, new Object[0]);
            this.logger.debug("Doing stuff asynchronously with callback, which throws an error");
            cbWhichThrows = new CallbackHandlerImpl();
            this.clientconn.callWithCallback((DBusInterface)tri, "getNameAndThrow", (CallbackHandler)cbWhichThrows, new Object[0]);
            try {
                this.logger.debug("Throwing stuff");
                tri.throwme();
                MethodTest.fail((String)"Method Execution should have failed");
            }
            catch (SampleException _ex) {
                this.logger.debug("Remote Method Failed with: " + ((Object)((Object)_ex)).getClass().getName() + " " + _ex.getMessage());
                if (_ex.getMessage().equals("test")) break block2;
                MethodTest.fail((String)"Error message was not correct");
            }
        }
        Thread.sleep(500L);
        MethodTest.assertNull((Object)cbWhichThrows.getLastError());
        MethodTest.assertNull((Object)cbWhichWorks.getLastError());
        MethodTest.assertEquals((int)1, (int)cbWhichWorks.getTestHandleCalls());
        MethodTest.assertEquals((int)0, (int)cbWhichThrows.getTestHandleCalls());
        MethodTest.assertEquals((int)0, (int)cbWhichWorks.getTestErrorCalls());
        MethodTest.assertEquals((int)1, (int)cbWhichThrows.getTestErrorCalls());
    }
}

