/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Peer;
import org.freedesktop.dbus.test.AbstractDBusDaemonBaseTest;
import org.freedesktop.dbus.test.helper.cross.CrossTestClient;
import org.freedesktop.dbus.test.helper.cross.CrossTestServer;
import org.freedesktop.dbus.test.helper.interfaces.Binding;
import org.freedesktop.dbus.test.helper.interfaces.SamplesInterface;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCross
extends AbstractDBusDaemonBaseTest {
    private ServerThread serverThread;
    private CrossTestServer cts;
    private volatile boolean serverReady = false;

    @BeforeEach
    public void before() {
        this.serverThread = new ServerThread();
        this.serverThread.setName("Server Thread");
        this.serverThread.start();
    }

    @AfterEach
    public void after() {
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
    }

    @Test
    public void testCross() throws InterruptedException {
        while (!this.serverReady) {
            Thread.sleep(500L);
        }
        try (DBusConnection conn = DBusConnectionBuilder.forSessionBus().build();){
            CrossTestClient client = new CrossTestClient(conn);
            conn.exportObject("/TestClient", (DBusInterface)client);
            conn.addSigHandler(Binding.SampleSignals.Triggered.class, (DBusSigHandler)client);
            SamplesInterface tests = (SamplesInterface)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", SamplesInterface.class);
            Binding.SingleSample singletests = (Binding.SingleSample)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", Binding.SingleSample.class);
            Peer peer = (Peer)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", Peer.class);
            Introspectable intro = (Introspectable)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", Introspectable.class);
            Introspectable rootintro = (Introspectable)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/", Introspectable.class);
            client.doTests(peer, intro, rootintro, tests, singletests);
            for (String string : client.getPassed()) {
                this.logger.info(string + " pass");
            }
            for (Map.Entry entry : client.getFailed().entrySet()) {
                for (String msg : (List)entry.getValue()) {
                    this.logger.error((String)entry.getKey() + " failed: " + msg);
                }
            }
        }
        catch (IOException | DBusException _exDbe) {
            _exDbe.printStackTrace();
            TestCross.fail((String)"Exception while processing DBus");
        }
        while (this.serverThread.isAlive()) {
            Thread.sleep(300L);
        }
        TestCross.assertTrue((boolean)this.cts.getNotdone().isEmpty(), (String)("All tests should have been run, following failed: " + String.join((CharSequence)", ", this.cts.getNotdone())));
        TestCross.assertNull((Object)this.serverThread.error);
    }

    private final class ServerThread
    extends Thread {
        private Exception error;

        private ServerThread() {
        }

        @Override
        public void run() {
            try (DBusConnection conn = DBusConnectionBuilder.forSessionBus().build();){
                conn.requestBusName("org.freedesktop.DBus.Binding.TestServer");
                TestCross.this.cts = new CrossTestServer(conn);
                conn.addSigHandler(Binding.SampleClient.Trigger.class, (DBusSigHandler)TestCross.this.cts);
                conn.exportObject("/Test", (DBusInterface)TestCross.this.cts);
                TestCross.this.serverReady = true;
                while (TestCross.this.cts.isRun()) {
                    try {
                        ServerThread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                for (String s : TestCross.this.cts.getDone()) {
                    TestCross.this.logger.info(s + " ok");
                }
                for (String s : TestCross.this.cts.getNotdone()) {
                    TestCross.this.logger.warn("---> " + s + " untested");
                }
                conn.disconnect();
            }
            catch (IOException | DBusException _exDe) {
                _exDe.printStackTrace();
                this.error = _exDe;
            }
        }
    }
}

