/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.IOException;
import org.freedesktop.dbus.connections.impl.DirectConnection;
import org.freedesktop.dbus.connections.impl.DirectConnectionBuilder;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Peer;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.freedesktop.dbus.test.helper.P2pTestServer;
import org.freedesktop.dbus.test.helper.SampleException;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

public class TestPeer2Peer
extends AbstractBaseTest {
    private static final String CONNECTION_ADDRESS = TransportBuilder.createDynamicSession((String)((String)TransportBuilder.getRegisteredBusTypes().get(0)), (boolean)false);
    private volatile boolean finished = false;

    @Test
    public void testP2p() throws InterruptedException {
        P2pServer p2pServer = new P2pServer();
        p2pServer.start();
        try (DirectConnection dc = DirectConnectionBuilder.forAddress((String)CONNECTION_ADDRESS).build();){
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Client: Connected: {}", (Object)dc);
            SampleRemoteInterface tri = (SampleRemoteInterface)dc.getRemoteObject("/Test");
            this.logger.debug("{}", (Object)tri.getName());
            this.logger.debug("{}", (Object)Float.valueOf(tri.testfloat(new float[]{17.093f, -23.0f, 0.0f, 31.42f})));
            try {
                tri.throwme();
            }
            catch (SampleException _ex) {
                this.logger.debug("Caught exception: {}", (Object)_ex.getMessage());
            }
            Peer peer = (Peer)dc.getRemoteObject("/Test", Peer.class);
            peer.Ping();
            Introspectable intro = (Introspectable)dc.getRemoteObject("/Test", Introspectable.class);
            String introspect = intro.Introspect();
            TestPeer2Peer.assertTrue((boolean)introspect.startsWith("<!DOCTYPE"));
            dc.disconnect();
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Client: Disconnected");
            this.finished = true;
        }
        catch (IOException | DBusException _ex) {
            TestPeer2Peer.fail((String)"Exception in client", (Throwable)_ex);
        }
    }

    private final class P2pServer
    extends Thread {
        P2pServer() {
            this.setName("P2pServerThread");
        }

        @Override
        public void run() {
            try (DirectConnection dc = DirectConnectionBuilder.forAddress((String)(CONNECTION_ADDRESS + ",listen=true")).build();){
                dc.exportObject("/Test", (DBusInterface)new P2pTestServer());
                LoggerFactory.getLogger(this.getClass()).info("Server: Export created");
                LoggerFactory.getLogger(this.getClass()).info("Server: Listening");
                dc.listen();
                while (!TestPeer2Peer.this.finished) {
                    P2pServer.sleep(500L);
                }
            }
            catch (IOException | InterruptedException | DBusException _ex) {
                Assertions.fail((String)"Exception in server", (Throwable)_ex);
            }
        }
    }
}

