/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.IOException;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.AbstractDBusDaemonBaseTest;
import org.freedesktop.dbus.test.helper.interfaces.TwoPartInterface;
import org.freedesktop.dbus.test.helper.interfaces.TwoPartObject;
import org.freedesktop.dbus.test.helper.twopart.TwoPartTestClient;
import org.freedesktop.dbus.test.helper.twopart.TwoPartTestServer;
import org.junit.jupiter.api.Test;

public class TestTwoPart
extends AbstractDBusDaemonBaseTest {
    private volatile boolean serverReady = false;

    @Test
    public void testTwoPart() throws InterruptedException {
        TwoPartServer twoPartServer = new TwoPartServer();
        twoPartServer.start();
        while (!this.serverReady) {
            Thread.sleep(1500L);
        }
        try (DBusConnection conn = DBusConnectionBuilder.forSessionBus().withShared(false).build();){
            this.logger.debug("get remote");
            TwoPartInterface remote = (TwoPartInterface)conn.getRemoteObject("org.freedesktop.dbus.test.two_part_server", "/", TwoPartInterface.class);
            TestTwoPart.assertNotNull((Object)remote);
            this.logger.debug("get object");
            TwoPartObject o = remote.getNew();
            TestTwoPart.assertNotNull((Object)o);
            this.logger.debug("get name");
            TestTwoPart.assertEquals((Object)"give name", (Object)o.getName());
            TwoPartTestClient.TwoPartTestObject tpto = new TwoPartTestClient.TwoPartTestObject();
            conn.exportObject("/TestObject", (DBusInterface)tpto);
            TwoPartInterface.TwoPartSignal message = new TwoPartInterface.TwoPartSignal("/FromObject", tpto);
            long signalSerial = message.getSerial();
            conn.sendMessage((Message)message);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TestTwoPart.assertNull((Object)twoPartServer.error, (String)("No error expected but got: " + twoPartServer.error));
            TestTwoPart.assertTrue((signalSerial < twoPartServer.receivedSignalSerial ? 1 : 0) != 0, (String)"Expected received signal serial to be larger than created serial");
        }
        catch (IOException | DBusException _ex) {
            TestTwoPart.fail((String)"Exception in client", (Throwable)_ex);
        }
    }

    private class TwoPartServer
    extends Thread {
        private long receivedSignalSerial;
        private String error;

        TwoPartServer() {
            super("TwoPartServerThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try (DBusConnection conn = DBusConnectionBuilder.forSessionBus().withShared(false).build();){
                conn.requestBusName("org.freedesktop.dbus.test.two_part_server");
                TwoPartTestServer server = new TwoPartTestServer(conn);
                conn.exportObject("/", (DBusInterface)server);
                conn.addSigHandler(TwoPartInterface.TwoPartSignal.class, (DBusSigHandler)server);
                TestTwoPart.this.serverReady = true;
                do {
                    try {
                        TwoPartServer.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (server.getSignalSerial() == 0L);
                this.error = server.getError();
                this.receivedSignalSerial = server.getSignalSerial();
            }
            catch (IOException | DBusException _ex) {
                TestTwoPart.this.logger.error("Exception while running TwoPartServer", _ex);
                throw new RuntimeException("Exception in server");
            }
        }
    }
}

