/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface2;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterfaceEnum;
import org.freedesktop.dbus.test.helper.structs.SampleStruct;
import org.freedesktop.dbus.test.helper.structs.SampleStruct2;
import org.freedesktop.dbus.test.helper.structs.SampleStruct3;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.Test;

public class TypeTest
extends AbstractDBusBaseTest {
    @Test
    public void testEnum() throws DBusException {
        SampleRemoteInterfaceEnum tri = (SampleRemoteInterfaceEnum)this.clientconn.getPeerRemoteObject(this.getTestBusName(), this.getTestObjectPath());
        TypeTest.assertEquals((Object)((Object)SampleRemoteInterfaceEnum.TestEnum.TESTVAL2), (Object)((Object)tri.getEnumValue()));
    }

    @Test
    public void testArrays() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface2.class);
        ArrayList<String> l = new ArrayList<String>();
        l.add("hi");
        l.add("hello");
        l.add("hej");
        l.add("hey");
        l.add("aloha");
        this.logger.debug("Sampling Arrays:");
        List<Integer> is = tri2.sampleArray(l, new Integer[]{1, 5, 7, 9}, new long[]{2L, 6L, 8L, 12L});
        this.logger.debug("sampleArray returned an array:");
        for (Integer i : is) {
            this.logger.debug("--" + i);
        }
        TypeTest.assertEquals((int)5, (int)is.size());
        TypeTest.assertEquals((int)-1, (int)is.get(0));
        TypeTest.assertEquals((int)-5, (int)is.get(1));
        TypeTest.assertEquals((int)-7, (int)is.get(2));
        TypeTest.assertEquals((int)-12, (int)is.get(3));
        TypeTest.assertEquals((int)-18, (int)is.get(4));
    }

    @Test
    public void testFloats() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject(this.getTestBusName(), this.getTestObjectPath());
        this.logger.debug("sending it to sleep");
        tri.waitawhile();
        this.logger.debug("testing floats");
        if (17.093f != tri.testfloat(new float[]{17.093f, -23.0f, 0.0f, 31.42f})) {
            TypeTest.fail((String)"testfloat returned the wrong thing");
        }
    }

    @Test
    public void testStruct() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject(this.getTestBusName(), this.getTestObjectPath());
        ArrayList<List<Integer>> lli = new ArrayList<List<Integer>>();
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(1);
        li.add(2);
        li.add(3);
        lli.add(li);
        lli.add(li);
        lli.add(li);
        SampleStruct3 ts3 = new SampleStruct3(new SampleStruct2(new ArrayList<String>(), (Variant<? extends Object>)new Variant((Object)0)), lli);
        int[][] out = tri.teststructstruct(ts3);
        if (out.length != 3) {
            TypeTest.fail((String)("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out)));
        }
        for (int[] o : out) {
            if (o.length == 3 && o[0] == 1 && o[1] == 2 && o[2] == 3) continue;
            TypeTest.fail((String)("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out)));
        }
    }

    @Test
    public void testStructAsync() throws DBusException, InterruptedException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject(this.getTestBusName(), this.getTestObjectPath(), SampleRemoteInterface2.class);
        SampleStruct struct = new SampleStruct("fizbuzz", new UInt32(5248L), new Variant((Object)2234));
        DBusAsyncReply structReply = this.clientconn.callMethodAsync((DBusInterface)tri2, "returnSamplestruct", new Object[]{struct});
        Thread.sleep(500L);
        TypeTest.assertEquals((Object)((Object)struct), (Object)structReply.getReply(), (String)"struct did not match");
    }

    @Test
    public void testCallGetUtf8String() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject(this.getTestBusName(), this.getTestObjectPath());
        String rname = tri.getName();
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        if (0 != col.compare("This Is A UTF-8 Name: \ufeb1 !!", rname)) {
            TypeTest.fail((String)"getName return value incorrect");
        }
    }
}

