/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.IOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.connections.impl.BaseConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MessageFactory;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.messages.MethodReturn;
import org.freedesktop.dbus.spi.message.InputStreamMessageReader;
import org.freedesktop.dbus.spi.message.OutputStreamMessageWriter;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class VariantTest
extends AbstractBaseTest {
    VariantTest() {
    }

    @Test
    void testVariant() {
        Variant strVariant = new Variant((Object)"String");
        Variant intVariant = new Variant((Object)1);
        VariantTest.assertEquals((Object)"String", (Object)strVariant.getValue());
        VariantTest.assertEquals(String.class, (Object)strVariant.getType());
        VariantTest.assertEquals((int)1, (Integer)((Integer)intVariant.getValue()));
        VariantTest.assertEquals(Integer.class, (Object)intVariant.getType());
        Variant listStrVariant = new Variant(List.of("str", "ing"), "as");
        Variant listIntVariant = new Variant(List.of(Integer.valueOf(1), Integer.valueOf(2)), "ai");
        VariantTest.assertEquals(List.of("str", "ing"), (Object)listStrVariant.getValue());
        VariantTest.assertEquals(List.class, (Object)((DBusListType)listStrVariant.getType()).getRawType());
        VariantTest.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2)), (Object)listIntVariant.getValue());
        VariantTest.assertEquals(List.class, (Object)((DBusListType)listIntVariant.getType()).getRawType());
    }

    static List<VariantData> createTestData() {
        return List.of(new VariantData(new Variant(Map.of("val1", 1, "val2", 2), "a{si}"), "String Int Map", DBusMapType.class, LinkedHashMap.class, Map.of("val1", 1, "val2", 2)), new VariantData(new Variant(List.of("str", "ing"), "as"), "String List Variant", DBusListType.class, ArrayList.class, List.of("str", "ing")), new VariantData(new Variant(List.of(Integer.valueOf(1), Integer.valueOf(2)), "ai"), "Integer List Variant", DBusListType.class, ArrayList.class, List.of(Integer.valueOf(1), Integer.valueOf(2))), new VariantData(new Variant(List.of(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)), "ab"), "Boolean List Variant", DBusListType.class, ArrayList.class, List.of(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false))));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"createTestData"})
    void testVariantSerializeDeserialize(VariantData _data) throws DBusException, IOException, InterruptedException {
        String dbusSig = Arrays.stream(Marshalling.getDBusType(_data.variantData.getClass())).collect(Collectors.joining());
        this.logger.info("BusType {}: {}", (Object)_data.description(), (Object)dbusSig);
        MessageFactory factory = new MessageFactory(BaseConnectionBuilder.getSystemEndianness());
        MethodCall methodCall = factory.createMethodCall("variant.test.Tv", "/variant/test/Tv", "variant.test.Tv", "Sample", (byte)0, dbusSig, new Object[]{_data.variantData()});
        MethodReturn methodReturn = factory.createMethodReturn(methodCall, dbusSig, new Object[]{_data.variantData()});
        Path unixPath = Path.of(System.getProperty("java.io.tmpdir"), this.getShortTestMethodName());
        Files.deleteIfExists(unixPath);
        UnixDomainSocketAddress usx = UnixDomainSocketAddress.of(unixPath);
        CountDownLatch readWait = new CountDownLatch(1);
        CountDownLatch writeWait = new CountDownLatch(1);
        AtomicReference ref = new AtomicReference();
        Thread thread = new Thread(() -> {
            try (ServerSocketChannel chan = ServerSocketChannel.open(StandardProtocolFamily.UNIX).bind(usx);
                 OutputStreamMessageWriter out = new OutputStreamMessageWriter(chan.accept());){
                this.logger.debug("Sending --> {}", (Object)methodReturn);
                out.writeMessage((Message)methodReturn);
                writeWait.countDown();
                readWait.await(10L, TimeUnit.SECONDS);
            }
            catch (Exception _ex) {
                ref.set(_ex);
            }
        }, this.getTestMethodName() + "Thread");
        thread.setDaemon(true);
        thread.start();
        Thread.sleep(300L);
        try (SocketChannel chan = SocketChannel.open(usx);
             InputStreamMessageReader in = new InputStreamMessageReader(chan);){
            writeWait.await(10L, TimeUnit.SECONDS);
            Message message = in.readMessage();
            this.logger.debug("Receiving <-- {}", (Object)message);
            Variant t = (Variant)message.getParameters()[0];
            VariantTest.assertSame(_data.expectedType(), t.getType().getClass());
            VariantTest.assertSame(_data.expectedValueClass(), t.getValue().getClass());
            VariantTest.assertEquals((Object)_data.expected(), (Object)t.getValue());
            readWait.countDown();
        }
        if (ref.get() != null) {
            VariantTest.fail((Throwable)((Throwable)ref.get()));
        }
    }

    record VariantData(Variant<?> variantData, String description, Class<?> expectedType, Class<?> expectedValueClass, Object expected) {
        @Override
        public String toString() {
            return this.description;
        }
    }
}

