/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.collections.empty.structs;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.test.collections.empty.structs.IEmptyCollectionStruct;
import org.freedesktop.dbus.test.helper.structs.IntStruct;

public final class MapArrayStruct
extends Struct
implements IEmptyCollectionStruct<Map<String, IntStruct[]>> {
    @Position(value=0)
    private final Map<String, IntStruct[]> map;
    @Position(value=1)
    private final String validationValue;

    public MapArrayStruct(Map<String, IntStruct[]> _map, String _validationValue) {
        this.map = _map;
        this.validationValue = _validationValue;
    }

    @Override
    public Map<String, IntStruct[]> getValue() {
        return this.map;
    }

    @Override
    public String getValidationValue() {
        return this.validationValue;
    }

    @Override
    public String getStringTestValue() {
        return this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toPrintableArray((IntStruct[])e.getValue()))).toString();
    }

    private String toPrintableArray(IntStruct[] _array) {
        String values = Stream.of(_array).map(IntStruct::toSimpleString).collect(Collectors.joining(","));
        return String.format("[%s]", values);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

