/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.helper.cross;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Peer;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.helper.interfaces.Binding;
import org.freedesktop.dbus.test.helper.interfaces.SamplesInterface;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossTestClient
implements Binding.SampleClient,
DBusSigHandler<Binding.SampleSignals.Triggered> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrossTestClient.class);
    private final DBusConnection conn;
    public final Set<String> passed = new TreeSet<String>();
    public final Map<String, List<String>> failed = new HashMap<String, List<String>>();

    public CrossTestClient(DBusConnection _conn) {
        this.conn = _conn;
        ArrayList<String> l = new ArrayList<String>();
        l.add("Signal never arrived");
        this.failed.put("org.freedesktop.DBus.Binding.TestSignals.Triggered", l);
        l = new ArrayList();
        l.add("Method never called");
        this.failed.put("org.freedesktop.DBus.Binding.TestClient.Response", l);
    }

    public boolean isRemote() {
        return false;
    }

    public String getObjectPath() {
        return null;
    }

    public void handle(Binding.SampleSignals.Triggered _t) {
        this.failed.remove("org.freedesktop.DBus.Binding.TestSignals.Triggered");
        if (new UInt64(21389479283L).equals((Object)_t.getSampleUint64()) && "/Test".equals(_t.getPath())) {
            this.pass("org.freedesktop.DBus.Binding.TestSignals.Triggered");
        } else if (!new UInt64(21389479283L).equals((Object)_t.getSampleUint64())) {
            this.fail("org.freedesktop.DBus.Binding.TestSignals.Triggered", "Incorrect signal content; expected 21389479283 got " + String.valueOf(_t.getSampleUint64()));
        } else if (!"/Test".equals(_t.getPath())) {
            this.fail("org.freedesktop.DBus.Binding.TestSignals.Triggered", "Incorrect signal source object; expected /Test got " + _t.getPath());
        }
    }

    @Override
    public void Response(UInt16 _a, double _b) {
        this.failed.remove("org.freedesktop.DBus.Binding.TestClient.Response");
        if (_a.equals((Object)new UInt16(15)) && _b == 12.5) {
            this.pass("org.freedesktop.DBus.Binding.TestClient.Response");
        } else {
            this.fail("org.freedesktop.DBus.Binding.TestClient.Response", "Incorrect parameters; expected 15, 12.5 got " + String.valueOf(_a) + ", " + _b);
        }
    }

    public void pass(String _test) {
        this.passed.add(_test.replaceAll("[$]", "."));
    }

    public void fail(String _test, String _reason) {
        String test = _test.replaceAll("[$]", ".");
        List reasons = this.failed.computeIfAbsent(test, k -> new ArrayList());
        reasons.add(_reason);
    }

    public void test(Class<? extends DBusInterface> _iface, Object _proxy, String _method, Object _rv, Object ... _parameters) {
        try {
            Method[] ms = _iface.getMethods();
            Method m = null;
            for (Method t : ms) {
                if (!t.getName().equals(_method)) continue;
                m = t;
                break;
            }
            Object o = m.invoke(_proxy, _parameters);
            Object msg = "Incorrect return value; sent ( ";
            if (null != _parameters) {
                for (Object po : _parameters) {
                    if (null == po) continue;
                    msg = (String)msg + CrossTestClient.collapseArray(po) + ",";
                }
            }
            msg = ((String)msg).replaceAll(".$", ");");
            msg = (String)msg + " expected " + CrossTestClient.collapseArray(_rv) + " got " + CrossTestClient.collapseArray(o);
            if (null != _rv && _rv.getClass().isArray()) {
                this.compareArray(_iface.getName() + "." + _method, _rv, o);
            } else if (_rv instanceof Map) {
                if (o instanceof Map) {
                    Map a = (Map)o;
                    Map b = (Map)_rv;
                    if (a.keySet().size() != b.keySet().size()) {
                        this.fail(_iface.getName() + "." + _method, (String)msg);
                    } else {
                        for (Object k : a.keySet()) {
                            if (a.get(k) instanceof List) {
                                if (b.get(k) instanceof List) {
                                    if (CrossTestClient.setCompareLists((List)a.get(k), (List)b.get(k))) continue;
                                    this.fail(_iface.getName() + "." + _method, (String)msg);
                                    continue;
                                }
                                this.fail(_iface.getName() + "." + _method, (String)msg);
                                continue;
                            }
                            if (a.get(k).equals(b.get(k))) continue;
                            this.fail(_iface.getName() + "." + _method, (String)msg);
                            return;
                        }
                    }
                    this.pass(_iface.getName() + "." + _method);
                } else {
                    this.fail(_iface.getName() + "." + _method, (String)msg);
                }
            } else if (Objects.equals(o, _rv)) {
                this.pass(_iface.getName() + "." + _method);
            } else {
                this.fail(_iface.getName() + "." + _method, (String)msg);
            }
        }
        catch (InvocationTargetException _exIt) {
            _exIt.printStackTrace();
            this.fail(_iface.getName() + "." + _method, "Error occurred during execution: " + _exIt.getCause().getClass().getName() + " " + _exIt.getCause().getMessage());
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
            this.fail(_iface.getName() + "." + _method, "Error occurred during execution: " + _ex.getClass().getName() + " " + _ex.getMessage());
        }
    }

    public static String collapseArray(Object _array) {
        if (null == _array) {
            return "null";
        }
        if (_array.getClass().isArray()) {
            Object s = "{ ";
            for (int i = 0; i < Array.getLength(_array); ++i) {
                s = (String)s + CrossTestClient.collapseArray(Array.get(_array, i)) + ",";
            }
            s = ((String)s).replaceAll(".$", " }");
            return s;
        }
        if (_array instanceof List) {
            Object s = "{ ";
            for (Object o : (List)_array) {
                s = (String)s + CrossTestClient.collapseArray(o) + ",";
            }
            s = ((String)s).replaceAll(".$", " }");
            return s;
        }
        if (_array instanceof Map) {
            Object s = "{ ";
            for (Object o : ((Map)_array).keySet()) {
                s = (String)s + CrossTestClient.collapseArray(o) + " => " + CrossTestClient.collapseArray(((Map)_array).get(o)) + ",";
            }
            s = ((String)s).replaceAll(".$", " }");
            return s;
        }
        return _array.toString();
    }

    public static <T> boolean setCompareLists(List<T> _a, List<T> _b) {
        if (_a.size() != _b.size()) {
            return false;
        }
        for (T v : _a) {
            if (_b.contains(v)) continue;
            return false;
        }
        return true;
    }

    public static List<Variant<Object>> primitizeRecurse(Object _a, Type _t) {
        ArrayList<Variant<Object>> vs = new ArrayList<Variant<Object>>();
        if (_t instanceof ParameterizedType) {
            Class c = (Class)((ParameterizedType)_t).getRawType();
            if (List.class.isAssignableFrom(c)) {
                Object[] os = _a instanceof List ? ((List)_a).toArray() : _a;
                Type[] ts = ((ParameterizedType)_t).getActualTypeArguments();
                for (int i = 0; i < Array.getLength(os); ++i) {
                    vs.addAll(CrossTestClient.primitizeRecurse(Array.get(os, i), ts[0]));
                }
            } else if (Map.class.isAssignableFrom(c)) {
                Object[] os = ((Map)_a).keySet().toArray();
                Object[] ks = ((Map)_a).values().toArray();
                Type[] ts = ((ParameterizedType)_t).getActualTypeArguments();
                for (Object element : ks) {
                    vs.addAll(CrossTestClient.primitizeRecurse(element, ts[0]));
                }
                for (Object element : os) {
                    vs.addAll(CrossTestClient.primitizeRecurse(element, ts[1]));
                }
            } else if (Struct.class.isAssignableFrom(c)) {
                Object[] os = ((Struct)_a).getParameters();
                Type[] ts = ((ParameterizedType)_t).getActualTypeArguments();
                for (int i = 0; i < os.length; ++i) {
                    vs.addAll(CrossTestClient.primitizeRecurse(os[i], ts[i]));
                }
            } else if (Variant.class.isAssignableFrom(c)) {
                vs.addAll(CrossTestClient.primitizeRecurse(((Variant)_a).getValue(), ((Variant)_a).getType()));
            }
        } else if (Variant.class.isAssignableFrom((Class)_t)) {
            vs.addAll(CrossTestClient.primitizeRecurse(((Variant)_a).getValue(), ((Variant)_a).getType()));
        } else if (_t instanceof Class && ((Class)_t).isArray()) {
            Class<?> t2 = ((Class)_t).getComponentType();
            for (int i = 0; i < Array.getLength(_a); ++i) {
                vs.addAll(CrossTestClient.primitizeRecurse(Array.get(_a, i), t2));
            }
        } else {
            vs.add(new Variant((Object)_a));
        }
        return vs;
    }

    public List<Variant<Object>> primitize(Variant<Object> _a) {
        return CrossTestClient.primitizeRecurse(_a.getValue(), _a.getType());
    }

    public void primitizeTest(SamplesInterface _tests, Object _input) {
        Variant in = new Variant(_input);
        List<Variant<Object>> vs = this.primitize((Variant<Object>)in);
        try {
            List<Variant<Object>> res = _tests.Primitize((Variant<Object>)in);
            if (CrossTestClient.setCompareLists(res, vs)) {
                this.pass("org.freedesktop.DBus.Binding.Tests.Primitize");
            } else {
                this.fail("org.freedesktop.DBus.Binding.Tests.Primitize", "Wrong Return Value; expected " + CrossTestClient.collapseArray(vs) + " got " + CrossTestClient.collapseArray(res));
            }
        }
        catch (Exception _ex) {
            LOGGER.debug("", (Throwable)_ex);
            this.fail("org.freedesktop.DBus.Binding.Tests.Primitize", "Exception occurred during test: (" + _ex.getClass().getName() + ") " + _ex.getMessage());
        }
    }

    public void doTests(Peer _peer, Introspectable _intro, Introspectable _rootintro, SamplesInterface _tests, Binding.SingleSample _singletests) {
        Random r = new Random();
        this.test(Peer.class, _peer, "Ping", null, new Object[0]);
        try {
            if (_intro.Introspect().startsWith("<!DOCTYPE")) {
                this.pass("org.freedesktop.DBus.Introspectable.Introspect");
            } else {
                this.fail("org.freedesktop.DBus.Introspectable.Introspect", "Didn't get valid xml data back when introspecting /Test");
            }
        }
        catch (DBusExecutionException _ex) {
            LOGGER.debug("", (Throwable)_ex);
            this.fail("org.freedesktop.DBus.Introspectable.Introspect", "Got exception during introspection on /Test (" + ((Object)((Object)_ex)).getClass().getName() + "): " + _ex.getMessage());
        }
        try {
            if (_rootintro.Introspect().startsWith("<!DOCTYPE")) {
                this.pass("org.freedesktop.DBus.Introspectable.Introspect");
            } else {
                this.fail("org.freedesktop.DBus.Introspectable.Introspect", "Didn't get valid xml data back when introspecting /");
            }
        }
        catch (DBusExecutionException _ex) {
            LOGGER.debug("", (Throwable)_ex);
            this.fail("org.freedesktop.DBus.Introspectable.Introspect", "Got exception during introspection on / (" + ((Object)((Object)_ex)).getClass().getName() + "): " + _ex.getMessage());
        }
        this.test(SamplesInterface.class, _tests, "Identity", new Variant((Object)1), new Variant((Object)1));
        this.test(SamplesInterface.class, _tests, "Identity", new Variant((Object)"Hello"), new Variant((Object)"Hello"));
        this.test(SamplesInterface.class, _tests, "IdentityBool", false, false);
        this.test(SamplesInterface.class, _tests, "IdentityBool", true, true);
        this.test(SamplesInterface.class, _tests, "Invert", false, true);
        this.test(SamplesInterface.class, _tests, "Invert", true, false);
        this.test(SamplesInterface.class, _tests, "IdentityByte", (byte)0, (byte)0);
        this.test(SamplesInterface.class, _tests, "IdentityByte", (byte)1, (byte)1);
        this.test(SamplesInterface.class, _tests, "IdentityByte", (byte)-1, (byte)-1);
        this.test(SamplesInterface.class, _tests, "IdentityByte", (byte)127, (byte)127);
        this.test(SamplesInterface.class, _tests, "IdentityByte", (byte)-128, (byte)-128);
        int i = r.nextInt();
        this.test(SamplesInterface.class, _tests, "IdentityByte", (byte)i, (byte)i);
        this.test(SamplesInterface.class, _tests, "IdentityInt16", (short)0, (short)0);
        this.test(SamplesInterface.class, _tests, "IdentityInt16", (short)1, (short)1);
        this.test(SamplesInterface.class, _tests, "IdentityInt16", (short)-1, (short)-1);
        this.test(SamplesInterface.class, _tests, "IdentityInt16", (short)Short.MAX_VALUE, (short)Short.MAX_VALUE);
        this.test(SamplesInterface.class, _tests, "IdentityInt16", (short)Short.MIN_VALUE, (short)Short.MIN_VALUE);
        i = r.nextInt();
        this.test(SamplesInterface.class, _tests, "IdentityInt16", (short)i, (short)i);
        this.test(SamplesInterface.class, _tests, "IdentityInt32", 0, 0);
        this.test(SamplesInterface.class, _tests, "IdentityInt32", 1, 1);
        this.test(SamplesInterface.class, _tests, "IdentityInt32", -1, -1);
        this.test(SamplesInterface.class, _tests, "IdentityInt32", Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.test(SamplesInterface.class, _tests, "IdentityInt32", Integer.MIN_VALUE, Integer.MIN_VALUE);
        i = r.nextInt();
        this.test(SamplesInterface.class, _tests, "IdentityInt32", i, i);
        this.test(SamplesInterface.class, _tests, "IdentityInt64", 0L, 0L);
        this.test(SamplesInterface.class, _tests, "IdentityInt64", 1L, 1L);
        this.test(SamplesInterface.class, _tests, "IdentityInt64", -1L, -1L);
        this.test(SamplesInterface.class, _tests, "IdentityInt64", Long.MAX_VALUE, Long.MAX_VALUE);
        this.test(SamplesInterface.class, _tests, "IdentityInt64", Long.MIN_VALUE, Long.MIN_VALUE);
        i = r.nextInt();
        this.test(SamplesInterface.class, _tests, "IdentityInt64", i, i);
        this.test(SamplesInterface.class, _tests, "IdentityUInt16", new UInt16(0), new UInt16(0));
        this.test(SamplesInterface.class, _tests, "IdentityUInt16", new UInt16(1), new UInt16(1));
        this.test(SamplesInterface.class, _tests, "IdentityUInt16", new UInt16(65535), new UInt16(65535));
        this.test(SamplesInterface.class, _tests, "IdentityUInt16", new UInt16(0), new UInt16(0));
        i = r.nextInt();
        i = i > 0 ? i : -i;
        this.test(SamplesInterface.class, _tests, "IdentityUInt16", new UInt16(i % 65535), new UInt16(i % 65535));
        this.test(SamplesInterface.class, _tests, "IdentityUInt32", new UInt32(0L), new UInt32(0L));
        this.test(SamplesInterface.class, _tests, "IdentityUInt32", new UInt32(1L), new UInt32(1L));
        this.test(SamplesInterface.class, _tests, "IdentityUInt32", new UInt32(0xFFFFFFFFL), new UInt32(0xFFFFFFFFL));
        this.test(SamplesInterface.class, _tests, "IdentityUInt32", new UInt32(0L), new UInt32(0L));
        i = r.nextInt();
        i = i > 0 ? i : -i;
        this.test(SamplesInterface.class, _tests, "IdentityUInt32", new UInt32((long)i % 0xFFFFFFFFL), new UInt32((long)i % 0xFFFFFFFFL));
        this.test(SamplesInterface.class, _tests, "IdentityUInt64", new UInt64(0L), new UInt64(0L));
        this.test(SamplesInterface.class, _tests, "IdentityUInt64", new UInt64(1L), new UInt64(1L));
        this.test(SamplesInterface.class, _tests, "IdentityUInt64", new UInt64(Long.MAX_VALUE), new UInt64(Long.MAX_VALUE));
        this.test(SamplesInterface.class, _tests, "IdentityUInt64", new UInt64(UInt64.MAX_BIG_VALUE), new UInt64(UInt64.MAX_BIG_VALUE));
        this.test(SamplesInterface.class, _tests, "IdentityUInt64", new UInt64(0L), new UInt64(0L));
        i = r.nextInt();
        i = i > 0 ? i : -i;
        this.test(SamplesInterface.class, _tests, "IdentityUInt64", new UInt64((long)i % Long.MAX_VALUE), new UInt64((long)i % Long.MAX_VALUE));
        this.test(SamplesInterface.class, _tests, "IdentityDouble", 0.0, 0.0);
        this.test(SamplesInterface.class, _tests, "IdentityDouble", 1.0, 1.0);
        this.test(SamplesInterface.class, _tests, "IdentityDouble", -1.0, -1.0);
        this.test(SamplesInterface.class, _tests, "IdentityDouble", Double.MAX_VALUE, Double.MAX_VALUE);
        this.test(SamplesInterface.class, _tests, "IdentityDouble", Double.MIN_VALUE, Double.MIN_VALUE);
        i = r.nextInt();
        this.test(SamplesInterface.class, _tests, "IdentityDouble", i, i);
        this.test(SamplesInterface.class, _tests, "IdentityString", "", "");
        this.test(SamplesInterface.class, _tests, "IdentityString", "The Quick Brown Fox Jumped Over The Lazy Dog", "The Quick Brown Fox Jumped Over The Lazy Dog");
        this.test(SamplesInterface.class, _tests, "IdentityString", "\u3072\u3089\u304c\u306a\u30b2\u30fc\u30e0 - \u304b\u306a\u3076\u3093", "\u3072\u3089\u304c\u306a\u30b2\u30fc\u30e0 - \u304b\u306a\u3076\u3093");
        this.testArray(SamplesInterface.class, _tests, "IdentityBoolArray", Boolean.TYPE, null);
        this.testArray(SamplesInterface.class, _tests, "IdentityByteArray", Byte.TYPE, null);
        this.testArray(SamplesInterface.class, _tests, "IdentityInt16Array", Short.TYPE, null);
        this.testArray(SamplesInterface.class, _tests, "IdentityInt32Array", Integer.TYPE, null);
        this.testArray(SamplesInterface.class, _tests, "IdentityInt64Array", Long.TYPE, null);
        this.testArray(SamplesInterface.class, _tests, "IdentityDoubleArray", Double.TYPE, null);
        Variant content = new Variant((Object)"aoeu");
        this.testArray(SamplesInterface.class, _tests, "IdentityArray", Variant.class, content);
        this.testArray(SamplesInterface.class, _tests, "IdentityUInt16Array", UInt16.class, new UInt16(12));
        this.testArray(SamplesInterface.class, _tests, "IdentityUInt32Array", UInt32.class, new UInt32(190L));
        this.testArray(SamplesInterface.class, _tests, "IdentityUInt64Array", UInt64.class, new UInt64(103948L));
        this.testArray(SamplesInterface.class, _tests, "IdentityStringArray", String.class, "asdf");
        int[] is = new int[]{};
        this.test(SamplesInterface.class, _tests, "Sum", 0L, new Object[]{is});
        int len = r.nextInt() % 100 + 15;
        len = (len < 0 ? -len : len) + 15;
        is = new int[len];
        long result = 0L;
        for (i = 0; i < len; ++i) {
            is[i] = r.nextInt();
            result += (long)is[i];
        }
        this.test(SamplesInterface.class, _tests, "Sum", result, new Object[]{is});
        byte[] bs = new byte[]{};
        this.test(Binding.SingleSample.class, _singletests, "Sum", new UInt32(0L), new Object[]{bs});
        len = r.nextInt() % 100;
        len = (len < 0 ? -len : len) + 15;
        bs = new byte[len];
        int res = 0;
        for (i = 0; i < len; ++i) {
            bs[i] = (byte)r.nextInt();
            res += bs[i] < 0 ? bs[i] + 256 : bs[i];
        }
        this.test(Binding.SingleSample.class, _singletests, "Sum", new UInt32((long)res % 0x100000000L), new Object[]{bs});
        this.test((Class<? extends DBusInterface>)SamplesInterface.class, _tests, "DeStruct", new Binding.Triplet<String, UInt32, Short>("hi", new UInt32(12L), (short)99), new Object[]{new Binding.CrossSampleStruct("hi", new UInt32(12L), (short)99)});
        HashMap<String, String> in = new HashMap<String, String>();
        HashMap out = new HashMap();
        this.test(SamplesInterface.class, _tests, "InvertMapping", out, in);
        in.put("hi", "there");
        in.put("to", "there");
        in.put("from", "here");
        in.put("in", "out");
        ArrayList<String> l = new ArrayList<String>();
        l.add("hi");
        l.add("to");
        out.put("there", l);
        l = new ArrayList();
        l.add("from");
        out.put("here", l);
        l = new ArrayList();
        l.add("in");
        out.put("out", l);
        this.test(SamplesInterface.class, _tests, "InvertMapping", out, in);
        this.primitizeTest(_tests, 1);
        this.primitizeTest(_tests, new Variant((Object)new Variant((Object)new Variant((Object)new Variant((Object)"Hi")))));
        this.primitizeTest(_tests, new Variant(in, (Type)new DBusMapType(String.class, String.class)));
        this.test(SamplesInterface.class, _tests, "Trigger", null, "/Test", new UInt64(21389479283L));
        try {
            this.conn.sendMessage((Message)new Binding.SampleClient.Trigger("/Test", new UInt16(15), 12.5));
        }
        catch (DBusException _ex) {
            LOGGER.debug("", (Throwable)_ex);
            throw new DBusExecutionException(_ex.getMessage(), (Throwable)_ex);
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.test(SamplesInterface.class, _tests, "Exit", null, new Object[0]);
    }

    public void testArray(Class<? extends DBusInterface> _iface, Object _proxy, String _method, Class<? extends Object> _arrayType, Object _content) {
        Object array = Array.newInstance(_arrayType, 0);
        this.test(_iface, _proxy, _method, array, array);
        Random r = new Random();
        int l = r.nextInt() % 100;
        array = Array.newInstance(_arrayType, (l < 0 ? -l : l) + 15);
        if (null != _content) {
            Arrays.fill((Object[])array, _content);
        }
        this.test(_iface, _proxy, _method, array, array);
    }

    public void compareArray(String _test, Object _a, Object _b) {
        if (!_a.getClass().equals(_b.getClass())) {
            this.fail(_test, "Incorrect return type; expected " + String.valueOf(_a.getClass()) + " got " + String.valueOf(_b.getClass()));
            return;
        }
        boolean pass = false;
        if (_a instanceof Object[]) {
            pass = Arrays.equals((Object[])_a, (Object[])_b);
        } else if (_a instanceof byte[]) {
            pass = Arrays.equals((byte[])_a, (byte[])_b);
        } else if (_a instanceof boolean[]) {
            pass = Arrays.equals((boolean[])_a, (boolean[])_b);
        } else if (_a instanceof int[]) {
            pass = Arrays.equals((int[])_a, (int[])_b);
        } else if (_a instanceof short[]) {
            pass = Arrays.equals((short[])_a, (short[])_b);
        } else if (_a instanceof long[]) {
            pass = Arrays.equals((long[])_a, (long[])_b);
        } else if (_a instanceof double[]) {
            pass = Arrays.equals((double[])_a, (double[])_b);
        }
        if (pass) {
            this.pass(_test);
        } else {
            Object s = "Incorrect return value; expected ";
            s = (String)s + CrossTestClient.collapseArray(_a);
            s = (String)s + " got ";
            s = (String)s + CrossTestClient.collapseArray(_b);
            this.fail(_test, (String)s);
        }
    }

    public Set<String> getPassed() {
        return this.passed;
    }

    public Map<String, List<String>> getFailed() {
        return this.failed;
    }
}

