/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.helper.signals.handler;

import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.types.UInt32;
import org.opentest4j.AssertionFailedError;

public class GenericHandlerWithDecode
implements DBusSigHandler<DBusSignal> {
    private final UInt32 expectedIntResult;
    private final String expectedStringResult;
    protected AssertionFailedError assertionError;
    private Object[] parameters;

    public GenericHandlerWithDecode(UInt32 _expectedIntResult, String _expectedStringResult) {
        this.expectedIntResult = _expectedIntResult;
        this.expectedStringResult = _expectedStringResult;
    }

    public void handle(DBusSignal _s) {
        try {
            this.parameters = _s.getParameters();
        }
        catch (DBusException _ex) {
            this.setFailed(false, "Unexpected DBusException", (Exception)((Object)_ex));
        }
    }

    public UInt32 getExpectedIntResult() {
        return this.expectedIntResult;
    }

    public String getExpectedStringResult() {
        return this.expectedStringResult;
    }

    public Throwable getAssertionError() {
        return this.assertionError;
    }

    protected void setFailed(boolean _condition, String _message) {
        if (!_condition) {
            this.assertionError = new AssertionFailedError(_message);
            throw this.assertionError;
        }
    }

    protected void setFailed(boolean _condition, String _message, Exception _ex) {
        if (!_condition) {
            this.assertionError = new AssertionFailedError(_message, (Throwable)_ex);
            throw this.assertionError;
        }
    }

    public void incomingSameAsExpected() {
        this.setFailed(this.parameters != null, "No parameters");
        this.setFailed(this.parameters.length == 2, "2 parameters expected but " + this.parameters.length + " found");
        if (this.expectedIntResult != null) {
            this.setFailed(this.parameters[0].equals(this.getExpectedIntResult()), "Retrieved int does not match.");
        }
        if (this.expectedStringResult != null) {
            this.setFailed(this.parameters[1].equals(this.getExpectedStringResult()), "Retrieved string does not match.");
        }
    }
}

