/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.exceptions.InvalidBusNameException;
import org.freedesktop.dbus.exceptions.InvalidObjectPathException;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.freedesktop.dbus.utils.DBusObjects;
import org.junit.jupiter.api.Test;

public class DBusObjectsTest
extends AbstractBaseTest {
    @Test
    void testRequireBusName() {
        DBusObjectsTest.assertDoesNotThrow(() -> DBusObjects.requireBusName((String)"org.freedesktop.DBus"));
        DBusObjectsTest.assertThrows(InvalidBusNameException.class, () -> DBusObjects.requireBusName(null));
        DBusObjectsTest.assertThrows(InvalidBusNameException.class, () -> DBusObjects.requireBusName((String)""));
    }

    @Test
    void testRequireNotBusName() {
        DBusObjectsTest.assertThrows(InvalidBusNameException.class, () -> DBusObjects.requireNotBusName((String)"org.freedesktop.DBus", (String)"test"));
        DBusObjectsTest.assertThrows(InvalidBusNameException.class, () -> DBusObjects.requireNotBusName(null, (String)"test"));
        DBusObjectsTest.assertThrows(InvalidBusNameException.class, () -> DBusObjects.requireNotBusName((String)"", (String)"test"));
    }

    @Test
    void testRequireObjectPath() {
        DBusObjectsTest.assertDoesNotThrow(() -> DBusObjects.requireObjectPath((DBusPath)new DBusPath("/")));
        DBusObjectsTest.assertDoesNotThrow(() -> DBusObjects.requireObjectPath((String)"/obj/path"));
        DBusObjectsTest.assertThrows(InvalidObjectPathException.class, () -> DBusObjects.requireObjectPath((String)"blabla"));
        DBusObjectsTest.assertThrows(InvalidObjectPathException.class, () -> DBusObjects.requireObjectPath((String)"bla/bla"));
    }

    @Test
    void testRequireBusNameOrConnectionId() {
        DBusObjectsTest.assertDoesNotThrow(() -> DBusObjects.requireBusNameOrConnectionId((String)"org.freedesktop.DBus"));
        DBusObjectsTest.assertDoesNotThrow(() -> DBusObjects.requireBusNameOrConnectionId((String)":1.0"));
    }

    @Test
    void testRequireNotNull() {
        IllegalStateException ex = (IllegalStateException)DBusObjectsTest.assertThrows(IllegalStateException.class, () -> DBusObjects.requireNotNull(null, () -> new IllegalStateException("evil null")));
        DBusObjectsTest.assertEquals((Object)"evil null", (Object)ex.getMessage());
    }
}

