/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.freedesktop.dbus.utils.LoggingHelper;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class LoggingHelperTest
extends AbstractBaseTest {
    @Test
    void testDeepString() {
        LinkedHashMap<String, String> testMap = new LinkedHashMap<String, String>();
        testMap.put("mapkey", "mapval");
        testMap.put("mapkey2", "mapval2");
        LinkedHashSet<String> testSet = new LinkedHashSet<String>();
        testSet.addAll(List.of("Set", "of", "stuff"));
        Object[] objArr = new Object[]{List.of("test", "collection"), "String Item", 1, new String[]{"String", "Array"}, new int[]{10, 20, 30}, testSet, new char[]{'h', 'i'}, new Long[]{2L, 4L}, testMap, 47.11, new boolean[][]{{true}, {false}}, new Object[]{"String", 5, new byte[]{97, 98}}};
        LoggingHelperTest.assertEquals((Object)"[test, collection], String Item, 1, [String, Array], [10, 20, 30], [Set, of, stuff], [h, i], [2, 4], {mapkey=mapval, mapkey2=mapval2}, 47.11, [[true], [false]], [String, 5, [97, 98]]", (Object)LoggingHelper.arraysVeryDeepString((Object[])objArr));
    }

    @ParameterizedTest(name="[{index}] -> {0}")
    @MethodSource(value={"getTestData"})
    void testConvertPrimitiveArray(TestValues _val) {
        LoggingHelperTest.assertEquals((Object)_val.expected, (Object)LoggingHelper.convertToString((Object)_val.input));
    }

    private static Stream<TestValues> getTestData() {
        return Stream.of(new TestValues(new boolean[]{true, false, false, true}, "[true, false, false, true]"), new TestValues(new char[]{'a', 'c', 'D', 'C'}, "[a, c, D, C]"), new TestValues(new byte[]{72, 69, 76, 76, 79}, "[72, 69, 76, 76, 79]"), new TestValues(new int[]{1, 3, 5, 7, 9}, "[1, 3, 5, 7, 9]"), new TestValues(new long[]{2L, 4L, 6L, 8L}, "[2, 4, 6, 8]"), new TestValues(new float[]{0.1f, 0.2f, 0.3f}, "[0.1, 0.2, 0.3]"), new TestValues(new double[]{1.0, 2.0, 3.0}, "[1.0, 2.0, 3.0]"));
    }

    private static class TestValues {
        private final Object input;
        private final String expected;

        TestValues(Object _input, String _expected) {
            this.input = _input;
            this.expected = _expected;
        }

        public String toString() {
            return this.input.getClass().getTypeName().replace("[]", "Array") + "Test";
        }
    }
}

