/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.util.stream.Stream;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.freedesktop.dbus.utils.PrimitiveUtils;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class PrimitiveUtilsTest
extends AbstractBaseTest {
    static Stream<PrimitiveWrapperTestData> createComparePrimitiveWrapperData() {
        return Stream.of(new PrimitiveWrapperTestData("Equal types", Boolean.class, Boolean.class, true), new PrimitiveWrapperTestData("Equal primitve types", Boolean.TYPE, Boolean.TYPE, true), new PrimitiveWrapperTestData("Equal object and primitive", Boolean.class, Boolean.TYPE, true), new PrimitiveWrapperTestData("Equal primitive and object", Boolean.class, Boolean.TYPE, true), new PrimitiveWrapperTestData("Unequal types", Boolean.class, String.class, false), new PrimitiveWrapperTestData("Unequal primitive types", Integer.TYPE, Long.TYPE, false), new PrimitiveWrapperTestData("Unequal primitive and object", Boolean.TYPE, String.class, false), new PrimitiveWrapperTestData("Unequal object and primitive", Byte.class, Integer.TYPE, false));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"createComparePrimitiveWrapperData"})
    void testComparePrimitiveWrapper(PrimitiveWrapperTestData _testData) {
        PrimitiveUtilsTest.assertEquals((Object)_testData.expected(), (Object)PrimitiveUtils.isCompatiblePrimitiveOrWrapper(_testData.clz1(), _testData.clz2()));
    }

    record PrimitiveWrapperTestData(String name, Class<?> clz1, Class<?> clz2, boolean expected) {
        @Override
        public String toString() {
            return this.name;
        }
    }
}

