/*
 * Decompiled with CFR 0.152.
 */
package sample.issue;

import org.freedesktop.dbus.bin.EmbeddedDBusDaemon;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.junit.jupiter.api.Test;

public class Issue244Test
extends AbstractBaseTest {
    @Test
    public void testSharedConnection() {
        String busType = (String)TransportBuilder.getRegisteredBusTypes().get(0);
        String addr = TransportBuilder.createDynamicSession((String)busType, (boolean)false);
        BusAddress clientAddress = BusAddress.of((String)addr);
        BusAddress serverAddress = BusAddress.of((String)addr).getListenerAddress();
        this.logger.info("Creating {} based DBus daemon on address {}", (Object)busType, (Object)serverAddress);
        try (EmbeddedDBusDaemon edbus = new EmbeddedDBusDaemon(serverAddress);){
            edbus.startInBackgroundAndWait(MAX_WAIT);
            try (DBusConnection con = DBusConnectionBuilder.forAddress((BusAddress)clientAddress).build();){
                Issue244Test.assertTrue((boolean)con.isConnected(), (String)"First connection attempt must work");
                edbus.close();
                Thread.sleep(1000L);
                Issue244Test.assertFalse((boolean)con.isConnected(), (String)"No connection expected after first disconnect");
            }
            edbus.startInBackgroundAndWait(MAX_WAIT);
            con = DBusConnectionBuilder.forAddress((BusAddress)clientAddress).build();
            try {
                Issue244Test.assertTrue((boolean)con.isConnected(), (String)"Second connection attempt must work");
                edbus.close();
                Thread.sleep(1000L);
                Issue244Test.assertFalse((boolean)con.isConnected(), (String)"No connection expected after second disconnect");
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (Exception _ex) {
            Issue244Test.fail((String)"No exception expected", (Throwable)_ex);
        }
    }
}

