/*
 * Decompiled with CFR 0.152.
 */
package sample.issue;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.AbstractDBusDaemonBaseTest;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.Test;

public class Issue268Test
extends AbstractDBusDaemonBaseTest {
    private static final String BUS_NAME = Issue268Test.class.getName();
    private static final String OBJECT_PATH = "/" + Issue268Test.class.getSimpleName().toLowerCase();
    private final CountDownLatch waitLatch = new CountDownLatch(1);

    @Test
    void testSignal() throws Exception {
        ArrayList<DBusSignal> failed = new ArrayList<DBusSignal>();
        try (DBusConnection exportDBusConn = this.export(failed);
             DBusConnection receiveDBusConn = this.receive();){
            exportDBusConn.sendMessage((Message)new Issue268Signal.MessageReceivedV2(OBJECT_PATH, System.currentTimeMillis(), "sender", new byte[0], "message", Map.of()));
            this.waitLatch.await(10L, TimeUnit.SECONDS);
            Issue268Test.assertTrue((boolean)failed.isEmpty(), (String)"Expected all signals to be handled properly");
        }
    }

    DBusConnection export(List<DBusSignal> _failed) throws Exception {
        DBusConnection dBusConn = ((DBusConnectionBuilder)DBusConnectionBuilder.forType((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION).withUnknownSignalHandler(s -> {
            _failed.add((DBusSignal)s);
            this.logger.debug("Signal handling failed");
            this.waitLatch.countDown();
        })).build();
        dBusConn.requestBusName(BUS_NAME);
        dBusConn.exportObject(() -> OBJECT_PATH);
        return dBusConn;
    }

    DBusConnection receive() throws Exception {
        DBusConnection dBusConn = DBusConnectionBuilder.forType((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION).build();
        Issue268Signal signal = (Issue268Signal)dBusConn.getRemoteObject(BUS_NAME, OBJECT_PATH, Issue268Signal.class);
        DBusSigHandler dbusMsgHandler = messageReceived -> {
            this.logger.debug("Received proper signal");
            this.waitLatch.countDown();
        };
        dBusConn.addSigHandler(Issue268Signal.MessageReceivedV2.class, (DBusInterface)signal, dbusMsgHandler);
        return dBusConn;
    }

    public static interface Issue268Signal
    extends DBusInterface {

        public static class MessageReceivedV2
        extends DBusSignal {
            private final long timestamp;
            private final String sender;
            private final byte[] groupId;
            private final String message;
            private final Map<String, Variant<?>> extras;

            public MessageReceivedV2(String _objectpath, long _timestamp, String _sender, byte[] _groupId, String _message, Map<String, Variant<?>> _extras) throws DBusException {
                super(_objectpath, new Object[]{_timestamp, _sender, _groupId, _message, _extras});
                this.timestamp = _timestamp;
                this.sender = _sender;
                this.groupId = _groupId;
                this.message = _message;
                this.extras = _extras;
            }

            public long getTimestamp() {
                return this.timestamp;
            }

            public String getSender() {
                return this.sender;
            }

            public byte[] getGroupId() {
                return this.groupId;
            }

            public String getMessage() {
                return this.message;
            }

            public Map<String, Variant<?>> getExtras() {
                return this.extras;
            }
        }
    }
}

