/*
 * Decompiled with CFR 0.152.
 */
package sample.issue;

import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusDaemonBaseTest;
import org.freedesktop.dbus.types.UInt16;
import org.junit.jupiter.api.Test;

public class Issue271Test
extends AbstractDBusDaemonBaseTest {
    @Test
    void testExportTuple() {
        Issue271Test.assertDoesNotThrow(() -> {
            try (DBusConnection connection = DBusConnectionBuilder.forSessionBus().build();){
                Issue271Mock mock = new Issue271Mock();
                connection.requestBusName(Issue271Test.class.getPackageName());
                connection.exportObject(mock.getObjectPath(), (DBusInterface)mock);
            }
        });
    }

    public static class Issue271Mock
    implements Issue271Interface {
        public String getObjectPath() {
            return "/issue271";
        }

        @Override
        public Issue271Tuple GetDetails() {
            return new Issue271Tuple(0, new UInt16(11));
        }
    }

    public static interface Issue271Interface
    extends DBusInterface {
        public Issue271Tuple GetDetails();
    }

    public static class Issue271Tuple
    extends Tuple {
        @Position(value=0)
        private byte info;
        @Position(value=1)
        private UInt16 field;

        public Issue271Tuple(byte _info, UInt16 _field) {
            this.info = _info;
            this.field = _field;
        }

        public byte getInfo() {
            return this.info;
        }

        public void setInfo(byte _info) {
            this.info = _info;
        }

        public UInt16 getField() {
            return this.field;
        }

        public void setField(UInt16 _field) {
            this.field = _field;
        }
    }
}

