/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import com.github.hypfvieh.util.FileIoUtil;
import com.github.hypfvieh.util.StringUtil;
import com.github.hypfvieh.util.xml.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.utils.generator.ClassBuilderInfo;
import org.freedesktop.dbus.utils.generator.StructTreeBuilder;
import org.freedesktop.dbus.utils.generator.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class InterfaceCodeGenerator {
    private final DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String nodeName;
    private String busName;
    private String introspectionData;

    public InterfaceCodeGenerator(String _introspectionData, String _objectPath, String _busName) {
        this.introspectionData = _introspectionData;
        this.nodeName = _objectPath;
        this.busName = _busName;
    }

    public Map<File, String> analyze(boolean _ignoreDtd) throws Exception {
        if (_ignoreDtd) {
            this.docFac.setValidating(false);
            this.docFac.setNamespaceAware(true);
            this.docFac.setFeature("http://xml.org/sax/features/namespaces", false);
            this.docFac.setFeature("http://xml.org/sax/features/validation", false);
            this.docFac.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            this.docFac.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        DocumentBuilder builder = this.docFac.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(this.introspectionData)));
        Element root = document.getDocumentElement();
        if (!(StringUtil.isBlank((String)this.nodeName) || StringUtil.isBlank((String)root.getAttribute("name")) || this.nodeName.equals(root.getAttribute("name")))) {
            this.logger.error("Retrieved node '{}' does not match requested node name '{}'!", (Object)root.getAttribute("name"), (Object)this.nodeName);
            return null;
        }
        List<Element> interfaceElements = InterfaceCodeGenerator.convertToElementList(root.getChildNodes());
        LinkedHashMap<File, String> filesAndContents = new LinkedHashMap<File, String>();
        for (Element ife : interfaceElements) {
            if (!StringUtil.isBlank((String)this.busName) && ife.getAttribute("name").startsWith(this.busName)) {
                filesAndContents.putAll(this.extractAll(ife));
                continue;
            }
            filesAndContents.putAll(this.extractAll(ife));
        }
        return filesAndContents;
    }

    static List<Element> convertToElementList(NodeList _nodeList) {
        ArrayList<Element> elemList = new ArrayList<Element>();
        for (int i = 0; i < _nodeList.getLength(); ++i) {
            if (!(_nodeList.item(i) instanceof Element)) continue;
            Element elem = (Element)_nodeList.item(i);
            elemList.add(elem);
        }
        return elemList;
    }

    private Map<File, String> extractAll(Element _ife) throws IOException, DBusException {
        String interfaceName = _ife.getAttribute("name");
        Map<DbusInterfaceToFqcn, String> fqcn = DbusInterfaceToFqcn.toFqcn(interfaceName);
        String packageName = fqcn.get((Object)DbusInterfaceToFqcn.PACKAGENAME);
        String className = fqcn.get((Object)DbusInterfaceToFqcn.CLASSNAME);
        this.logger.info("Creating interface: {}.{}", (Object)packageName, (Object)className);
        LinkedHashMap<File, String> filesToCreate = new LinkedHashMap<File, String>();
        ClassBuilderInfo interfaceClass = new ClassBuilderInfo();
        interfaceClass.setClassType(ClassBuilderInfo.ClassType.INTERFACE);
        interfaceClass.setPackageName(packageName);
        interfaceClass.setClassName(className);
        ArrayList<ClassBuilderInfo> additionalClasses = new ArrayList<ClassBuilderInfo>();
        List<Element> interfaceElements = InterfaceCodeGenerator.convertToElementList(_ife.getChildNodes());
        for (Element element : interfaceElements) {
            switch (element.getTagName().toLowerCase()) {
                case "method": {
                    additionalClasses.addAll(this.extractMethods(element, interfaceClass));
                    break;
                }
                case "signal": {
                    additionalClasses.addAll(this.extractSignals(element, interfaceClass));
                }
            }
        }
        filesToCreate.put(new File(interfaceClass.getFileName()), interfaceClass.createClassFileContent());
        for (ClassBuilderInfo cbi : additionalClasses) {
            filesToCreate.put(new File(cbi.getFileName()), cbi.createClassFileContent());
        }
        return filesToCreate;
    }

    private List<ClassBuilderInfo> extractSignals(Element _signalElement, ClassBuilderInfo _clzBldr) throws IOException, DBusException {
        ArrayList<ClassBuilderInfo> additionalClasses = new ArrayList<ClassBuilderInfo>();
        if (!_signalElement.hasChildNodes()) {
            this.logger.warn("Signal without any input/output arguments. These are not supported yet, please open a ticket at github!");
            return additionalClasses;
        }
        String className = _signalElement.getAttribute("name");
        if (className.contains(".")) {
            className = className.substring(className.lastIndexOf("."));
        }
        ClassBuilderInfo innerClass = new ClassBuilderInfo();
        innerClass.setClassType(ClassBuilderInfo.ClassType.CLASS);
        innerClass.setExtendClass(DBusSignal.class.getSimpleName());
        innerClass.getImports().add(DBusSignal.class.getName());
        innerClass.setClassName(className);
        _clzBldr.getInnerClasses().add(innerClass);
        List signalArgs = XmlUtil.convertToElementList((NodeList)XmlUtil.applyXpathExpressionToDocument((String)"arg", (Node)_signalElement));
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        int unknownArgCnt = 0;
        for (Element element : signalArgs) {
            String argType = TypeConverter.getJavaTypeFromDBusType(element.getAttribute("type"), _clzBldr.getImports());
            String argName = element.getAttribute("name");
            if (StringUtil.isBlank((String)argName)) {
                argName = "arg" + unknownArgCnt;
                ++unknownArgCnt;
            }
            args.put(argName, TypeConverter.getProperJavaClass(argType, _clzBldr.getImports()));
        }
        for (Map.Entry entry : args.entrySet()) {
            innerClass.getMembers().add(new ClassBuilderInfo.ClassMember((String)entry.getKey(), (String)entry.getValue(), true));
        }
        ClassBuilderInfo.ClassConstructor classConstructor = new ClassBuilderInfo.ClassConstructor();
        Map map = args.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (k1, k2) -> k1, LinkedHashMap::new));
        classConstructor.getArguments().putAll(map);
        classConstructor.getSuperArguments().addAll(args.keySet());
        return additionalClasses;
    }

    private List<ClassBuilderInfo> extractMethods(Element _methodElement, ClassBuilderInfo _clzBldr) throws IOException, DBusException {
        ArrayList<ClassBuilderInfo> additionalClasses = new ArrayList<ClassBuilderInfo>();
        if (_methodElement.hasChildNodes()) {
            List<Element> methodArgs = InterfaceCodeGenerator.convertToElementList(XmlUtil.applyXpathExpressionToDocument((String)"./arg", (Node)_methodElement));
            LinkedHashMap<String, String> inputArgs = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> outputArgs = new LinkedHashMap<String, String>();
            int unknownArgNameCnt = 0;
            for (Element argElm : methodArgs) {
                String structPart;
                String parentType;
                String argName = argElm.getAttribute("name");
                String argType = argElm.getAttribute("type").contains("(") ? ((parentType = this.buildStructClass(structPart = argElm.getAttribute("type").replaceAll("(\\(.+\\))", "$1"), _methodElement.getAttribute("name") + "Struct", _clzBldr, additionalClasses)) != null ? parentType : null) : TypeConverter.getJavaTypeFromDBusType(argElm.getAttribute("type"), _clzBldr.getImports());
                if (StringUtil.isBlank((String)argName)) {
                    argName = "arg" + unknownArgNameCnt;
                    ++unknownArgNameCnt;
                }
                if ("in".equals(argElm.getAttribute("direction"))) {
                    inputArgs.put(argName, TypeConverter.getProperJavaClass(argType, _clzBldr.getImports()));
                    continue;
                }
                if (!"out".equals(argElm.getAttribute("direction"))) continue;
                outputArgs.put(argName, TypeConverter.getProperJavaClass(argType, _clzBldr.getImports()));
            }
            if (outputArgs.size() > 1) {
                this.logger.debug("Found method with multiple return values: {}", (Object)_methodElement.getAttribute("name"));
                String string = this.createTuple(outputArgs, _methodElement.getAttribute("name") + "Tuple", _clzBldr, additionalClasses);
            }
            this.logger.debug("Found method with arguments: {}({})", (Object)_methodElement.getAttribute("name"), inputArgs);
            String resultType = outputArgs.isEmpty() ? "void" : (String)outputArgs.get(new ArrayList(outputArgs.keySet()).get(0));
            ClassBuilderInfo.ClassMethod classMethod = new ClassBuilderInfo.ClassMethod(_methodElement.getAttribute("name"), resultType, false);
            classMethod.getArguments().putAll(inputArgs);
            _clzBldr.getMethods().add(classMethod);
        } else {
            ClassBuilderInfo.ClassMethod classMethod = new ClassBuilderInfo.ClassMethod(_methodElement.getAttribute("name"), "void", false);
            _clzBldr.getMethods().add(classMethod);
        }
        return additionalClasses;
    }

    private String createTuple(Map<String, String> _outputArgs, String _className, ClassBuilderInfo _parentClzBldr, List<ClassBuilderInfo> _additionalClasses) {
        if (_outputArgs == null || _outputArgs.isEmpty() || _additionalClasses == null) {
            return null;
        }
        ClassBuilderInfo info = new ClassBuilderInfo();
        info.setClassName(_className);
        info.setPackageName(_parentClzBldr.getPackageName());
        info.setExtendClass(Tuple.class.getName());
        if (!_outputArgs.isEmpty()) {
            info.getImports().add(Position.class.getName());
        }
        int position = 0;
        for (Map.Entry<String, String> entry : _outputArgs.entrySet()) {
            ClassBuilderInfo.ClassMember member = new ClassBuilderInfo.ClassMember(entry.getKey(), entry.getValue(), true);
            member.getAnnotations().add("@Position(" + position + ")");
        }
        ClassBuilderInfo.ClassConstructor cnstrct = new ClassBuilderInfo.ClassConstructor();
        cnstrct.getArguments().putAll(_outputArgs);
        _additionalClasses.add(info);
        return info.getFqcn();
    }

    private String buildStructClass(String _dbusTypeStr, String _structName, ClassBuilderInfo _packageName, List<ClassBuilderInfo> _structClasses) throws DBusException {
        return new StructTreeBuilder().buildStructClasses(_dbusTypeStr, _structName, _packageName, _structClasses);
    }

    static void writeToFile(String _outputDir, Map<File, String> _filesToGenerate) {
        for (Map.Entry<File, String> entry : _filesToGenerate.entrySet()) {
            File outputFile = new File(_outputDir, entry.getKey().getPath());
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            FileIoUtil.writeTextFile((String)outputFile.getAbsolutePath(), (String)entry.getValue(), (Charset)Charset.defaultCharset(), (boolean)false);
        }
    }

    public static void main(String[] args) {
        String busName = null;
        String outputDir = null;
        DBusConnection.DBusBusType busType = null;
        boolean ignoreDtd = true;
        String objectPath = "/";
        for (int i = 0; i < args.length; ++i) {
            String p = args[i];
            if ("--system".equals(p) || "-y".equals(p)) {
                busType = DBusConnection.DBusBusType.SYSTEM;
                continue;
            }
            if ("--session".equals(p) || "-s".equals(p)) {
                busType = DBusConnection.DBusBusType.SESSION;
                continue;
            }
            if ("--enable-dtd-validation".equals(p)) {
                ignoreDtd = false;
                continue;
            }
            if ("--help".equals(p) || "-h".equals(p)) {
                InterfaceCodeGenerator.printHelp();
                System.exit(0);
                continue;
            }
            if ("--version".equals(p) || "-v".equals(p)) {
                InterfaceCodeGenerator.version();
                System.exit(0);
                continue;
            }
            if ("--outputDir".equals(p) || "-o".equals(p)) {
                if (args.length > i) {
                    outputDir = args[i++];
                    continue;
                }
                InterfaceCodeGenerator.printHelp();
                System.exit(0);
                continue;
            }
            if (null == busName) {
                busName = p;
                continue;
            }
            if (null == objectPath) {
                objectPath = p;
                continue;
            }
            InterfaceCodeGenerator.printHelp();
            System.exit(1);
        }
        if (outputDir == null) {
            throw new RuntimeException("No output directory (--outputDir) given!");
        }
        Logger logger = LoggerFactory.getLogger(InterfaceCodeGenerator.class);
        String introspectionData = null;
        if (!StringUtil.isBlank(busName)) {
            try {
                logger.info("Introspecting: { Interface: {}, Busname: {} }", (Object)objectPath, busName);
                DBusConnection conn = DBusConnection.getConnection((DBusConnection.DBusBusType)busType);
                Introspectable in = (Introspectable)conn.getRemoteObject(busName, objectPath, Introspectable.class);
                introspectionData = in.Introspect();
                if (StringUtil.isBlank((String)introspectionData)) {
                    logger.error("Failed to get introspection data");
                    System.exit(1);
                }
                conn.disconnect();
            }
            catch (DBusException | DBusExecutionException _ex) {
                logger.error("Failure in DBus Communications. ", _ex);
                System.exit(1);
            }
            InterfaceCodeGenerator ci2 = new InterfaceCodeGenerator(introspectionData, objectPath, busName);
            try {
                Map<File, String> analyze = ci2.analyze(ignoreDtd);
                InterfaceCodeGenerator.writeToFile(outputDir, analyze);
            }
            catch (Exception _ex) {
                logger.error("Error while analyzing introspection data", (Throwable)_ex);
            }
        }
    }

    private static void version() {
        System.out.println("Java D-Bus Version " + System.getProperty("Version"));
        System.exit(1);
    }

    private static void printHelp() {
        System.out.println("Syntax: <options> [busname object]");
        System.out.println("        Options: ");
        System.out.println("        --system          | -y           Use SYSTEM DBus");
        System.out.println("        --session         | -s           Use SESSION DBus");
        System.out.println("        --outputDir <Dir> | -o <Dir>     Use <Dir> as output directory for all generated files");
        System.out.println("");
        System.out.println("        --enable-dtd-validation          Enable DTD validation of introspection XML");
        System.out.println("        --version                        Show version information");
        System.out.println("        --help                           Show this help");
    }

    static enum DbusInterfaceToFqcn {
        PACKAGENAME,
        CLASSNAME;


        public static Map<DbusInterfaceToFqcn, String> toFqcn(String _interfaceName) {
            String packageName = _interfaceName.contains(".") ? _interfaceName.substring(0, _interfaceName.lastIndexOf(".")) : _interfaceName;
            String className = _interfaceName.substring(_interfaceName.lastIndexOf(".") + 1);
            LinkedHashMap<DbusInterfaceToFqcn, String> map = new LinkedHashMap<DbusInterfaceToFqcn, String>();
            map.put(CLASSNAME, StringUtil.upperCaseFirstChar((String)className));
            map.put(PACKAGENAME, packageName.toLowerCase());
            return map;
        }
    }
}

