/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import com.github.hypfvieh.util.StringUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.Variant;

public class TypeConverter {
    private static final Map<String, String> CLASS_MAP = new HashMap<String, String>();

    public static String getProperJavaClass(String _argType, Set<String> _includes) {
        String clazzName = null;
        if (_argType == null) {
            return _argType;
        }
        if (_argType.contains("<")) {
            clazzName = _argType;
            for (Map.Entry<String, String> clzzNames : CLASS_MAP.entrySet()) {
                if (!clazzName.contains(clzzNames.getKey())) continue;
                clazzName = clazzName.replace(clzzNames.getKey(), clzzNames.getValue());
                if (clzzNames.getKey().startsWith("java.lang.")) continue;
                _includes.add(clzzNames.getKey());
            }
        } else {
            clazzName = _argType.substring(_argType.lastIndexOf(".") + 1);
            return TypeConverter.convertJavaType(clazzName, true);
        }
        clazzName = clazzName.replace("java.lang.", "");
        return clazzName;
    }

    private static String convertJavaType(String _fqcn, boolean _usePrimitives) {
        if (_fqcn == null) {
            return _fqcn;
        }
        String clazzName = _fqcn;
        if (_fqcn.contains(".")) {
            clazzName = _fqcn.substring(_fqcn.lastIndexOf(".") + 1);
        }
        if (CLASS_MAP.containsKey(_fqcn)) {
            return CLASS_MAP.get(_fqcn);
        }
        if (clazzName.equals("CharSequence")) {
            return "String";
        }
        return _usePrimitives ? TypeConverter.convertJavaBoxedTypeToPrimitive(clazzName) : clazzName;
    }

    private static String convertJavaBoxedTypeToPrimitive(String _clazzName) {
        switch (_clazzName) {
            case "Boolean": {
                return "boolean";
            }
            case "Integer": {
                return "int";
            }
            case "Long": {
                return "long";
            }
            case "Double": {
                return "double";
            }
            case "Float": {
                return "float";
            }
            case "Byte": {
                return "byte";
            }
            case "Char": {
                return "char";
            }
        }
        return _clazzName;
    }

    public static String getJavaTypeFromDBusType(String _dbusType, Set<String> _javaIncludes) throws DBusException {
        String type;
        ArrayList dataType = new ArrayList();
        if (StringUtil.isBlank((String)_dbusType)) {
            return null;
        }
        if (_dbusType.length() == 1) {
            Marshalling.getJavaType((String)_dbusType, dataType, (int)1);
            type = dataType.stream().map(t -> t.getTypeName()).collect(Collectors.joining(""));
            _javaIncludes.add(type);
        } else {
            type = TypeConverter.getTypeAdv(_dbusType, _javaIncludes);
        }
        return type;
    }

    private static Map<String, List<String>> getTypeAdv(Type _type, List<String> _innerGenerics) throws DBusException {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        if (_type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)_type;
            ArrayList<String> generics = new ArrayList<String>();
            result.put(pType.getRawType().getTypeName(), generics);
            for (Type t : pType.getActualTypeArguments()) {
                if (t instanceof ParameterizedType) {
                    result.putAll(TypeConverter.getTypeAdv(t, generics));
                    continue;
                }
                generics.add(t.getTypeName());
            }
        } else {
            result.put(_type.getTypeName(), new ArrayList());
        }
        return result;
    }

    private static String getTypeAdv(String _dbusType, Set<String> _javaIncludes) throws DBusException {
        if (StringUtil.isBlank((String)_dbusType)) {
            return null;
        }
        ArrayList dataType = new ArrayList();
        Marshalling.getJavaType((String)_dbusType, dataType, (int)1);
        if (dataType.get(0) instanceof DBusListType || dataType.get(0) instanceof DBusMapType) {
            ParameterizedType dBusListType = (ParameterizedType)dataType.get(0);
            Type[] actualTypeArguments = dBusListType.getActualTypeArguments();
            String actualArgTypeVal = "?";
            String retVal = dBusListType.getRawType().getTypeName();
            if (actualTypeArguments.length > 0) {
                Map<String, List<String>> typeAdv = TypeConverter.getTypeAdv(actualTypeArguments[0], null);
                actualArgTypeVal = "";
                for (Map.Entry<String, List<String>> e : typeAdv.entrySet()) {
                    if (!e.getValue().isEmpty()) {
                        actualArgTypeVal = actualArgTypeVal + e.getKey() + "<";
                        actualArgTypeVal = actualArgTypeVal + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)e.getValue());
                        actualArgTypeVal = actualArgTypeVal + ">";
                        _javaIncludes.addAll((Collection<String>)e.getValue());
                        continue;
                    }
                    actualArgTypeVal = e.getKey();
                }
            }
            return retVal + "<" + actualArgTypeVal + ">";
        }
        return ((Type)dataType.get(0)).getTypeName();
    }

    static {
        CLASS_MAP.put("java.lang.CharSequence", "String");
        CLASS_MAP.put("java.util.List", "List");
        CLASS_MAP.put("java.util.Set", "Set");
        CLASS_MAP.put("java.util.Map", "Map");
        CLASS_MAP.put(Variant.class.getName(), "Variant<?>");
    }
}

