/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import com.github.hypfvieh.util.FileIoUtil;
import java.util.Map;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.utils.generator.InterfaceCodeGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InterfaceCodeGeneratorTest {
    InterfaceCodeGeneratorTest() {
    }

    @Test
    void testCreateSelectedFirewallInterfaces() {
        String objectPath = "/org/fedoraproject/FirewallD1";
        String busName = "org.fedoraproject.FirewallD1";
        boolean ignoreDtd = true;
        Logger logger = LoggerFactory.getLogger(InterfaceCodeGenerator.class);
        if (!StringUtils.isBlank((String)busName)) {
            String introspectionData = FileIoUtil.readFileToString((String)"src/test/resources/CreateInterface/firewall/org.fedoraproject.FirewallD1.xml");
            InterfaceCodeGenerator ci2 = new InterfaceCodeGenerator(introspectionData, objectPath, busName);
            try {
                Map analyze = ci2.analyze(ignoreDtd);
                Assertions.assertEquals((int)9, (int)analyze.size());
            }
            catch (Exception _ex) {
                logger.error("Error while analyzing introspection data", (Throwable)_ex);
            }
        }
    }

    @Test
    void testCreateAllFirewallInterfaces() {
        String objectPath = "/org/fedoraproject/FirewallD1";
        String busName = "*";
        boolean ignoreDtd = true;
        Logger logger = LoggerFactory.getLogger(InterfaceCodeGenerator.class);
        if (!StringUtils.isBlank((String)busName)) {
            String introspectionData = FileIoUtil.readFileToString((String)"src/test/resources/CreateInterface/firewall/org.fedoraproject.FirewallD1.xml");
            InterfaceCodeGenerator ci2 = new InterfaceCodeGenerator(introspectionData, objectPath, busName);
            try {
                Map analyze = ci2.analyze(ignoreDtd);
                Assertions.assertEquals((int)20, (int)analyze.size());
            }
            catch (Exception _ex) {
                logger.error("Error while analyzing introspection data", (Throwable)_ex);
            }
        }
    }

    @Test
    void testCreateNetworkManagerWirelessInterface() {
        String objectPath = "/";
        String busName = "org.freedesktop.NetworkManager.Device.Wireless";
        boolean ignoreDtd = true;
        Logger logger = LoggerFactory.getLogger(InterfaceCodeGenerator.class);
        if (!StringUtils.isBlank((String)busName)) {
            String introspectionData = FileIoUtil.readFileToString((String)"src/test/resources/CreateInterface/networkmanager/org.freedesktop.NetworkManager.Device.Wireless.xml");
            InterfaceCodeGenerator ci2 = new InterfaceCodeGenerator(introspectionData, objectPath, busName);
            try {
                Map analyze = ci2.analyze(ignoreDtd);
                Assertions.assertEquals((int)1, (int)analyze.size());
                String clzContent = (String)analyze.get(analyze.keySet().iterator().next());
                Assertions.assertTrue((boolean)clzContent.contains("@" + DBusInterfaceName.class.getSimpleName() + "(\"" + busName + "\")"));
                Assertions.assertFalse((boolean)clzContent.contains("this._properties"));
                Assertions.assertFalse((boolean)clzContent.contains("this._path"));
                Assertions.assertFalse((boolean)clzContent.contains("this._interfaceName"));
            }
            catch (Exception _ex) {
                logger.error("Error while analyzing introspection data", (Throwable)_ex);
            }
        }
    }
}

