/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.Position;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.TypeRef;
import org.freedesktop.dbus.annotations.DBusProperty;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.dbus.utils.Util;
import org.freedesktop.dbus.utils.XmlUtil;
import org.freedesktop.dbus.utils.generator.ClassBuilderInfo;
import org.freedesktop.dbus.utils.generator.StructTreeBuilder;
import org.freedesktop.dbus.utils.generator.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class InterfaceCodeGenerator {
    private final DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String nodeName;
    private String busName;
    private String introspectionData;

    public InterfaceCodeGenerator(String _introspectionData, String _objectPath, String _busName) {
        this.introspectionData = _introspectionData;
        this.nodeName = _objectPath;
        this.busName = Util.isBlank((String)_busName) ? "*" : _busName;
    }

    public Map<File, String> analyze(boolean _ignoreDtd) throws Exception {
        if (_ignoreDtd) {
            this.docFac.setValidating(false);
            this.docFac.setNamespaceAware(true);
            this.docFac.setFeature("http://xml.org/sax/features/namespaces", false);
            this.docFac.setFeature("http://xml.org/sax/features/validation", false);
            this.docFac.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            this.docFac.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        DocumentBuilder builder = this.docFac.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(this.introspectionData)));
        Element root = document.getDocumentElement();
        if (!(Util.isBlank((String)this.nodeName) || Util.isBlank((String)root.getAttribute("name")) || this.nodeName.equals(root.getAttribute("name")))) {
            this.logger.error("Retrieved node '{}' does not match requested node name '{}'!", (Object)root.getAttribute("name"), (Object)this.nodeName);
            return null;
        }
        List<Element> interfaceElements = InterfaceCodeGenerator.convertToElementList(root.getChildNodes());
        LinkedHashMap<File, String> filesAndContents = new LinkedHashMap<File, String>();
        boolean noBusnameGiven = "*".equals(this.busName);
        for (Element ife : interfaceElements) {
            String nameAttrib = ife.getAttribute("name");
            if (!noBusnameGiven && !nameAttrib.startsWith(this.busName)) {
                this.logger.info("Skipping: {} - does not match given busName: {}", (Object)nameAttrib, (Object)this.busName);
                continue;
            }
            if (noBusnameGiven) {
                filesAndContents.putAll(this.extractAll(ife));
                continue;
            }
            filesAndContents.putAll(this.extractAll(ife));
        }
        return filesAndContents;
    }

    static List<Element> convertToElementList(NodeList _nodeList) {
        ArrayList<Element> elemList = new ArrayList<Element>();
        for (int i = 0; i < _nodeList.getLength(); ++i) {
            if (!(_nodeList.item(i) instanceof Element)) continue;
            Element elem = (Element)_nodeList.item(i);
            elemList.add(elem);
        }
        return elemList;
    }

    private Map<File, String> extractAll(Element _ife) throws IOException, DBusException {
        String interfaceName = _ife.getAttribute("name");
        Map<DbusInterfaceToFqcn, String> fqcn = DbusInterfaceToFqcn.toFqcn(interfaceName);
        String packageName = fqcn.get((Object)DbusInterfaceToFqcn.PACKAGENAME);
        String className = fqcn.get((Object)DbusInterfaceToFqcn.CLASSNAME);
        this.logger.info("Creating interface: {}.{}", (Object)packageName, (Object)className);
        LinkedHashMap<File, String> filesToCreate = new LinkedHashMap<File, String>();
        ClassBuilderInfo interfaceClass = new ClassBuilderInfo();
        interfaceClass.setClassType(ClassBuilderInfo.ClassType.INTERFACE);
        interfaceClass.setPackageName(packageName);
        interfaceClass.setDbusPackageName(fqcn.get((Object)DbusInterfaceToFqcn.DBUS_INTERFACE_NAME));
        interfaceClass.setClassName(className);
        interfaceClass.setExtendClass(DBusInterface.class.getName());
        ArrayList<ClassBuilderInfo> additionalClasses = new ArrayList<ClassBuilderInfo>();
        List<Element> interfaceElements = InterfaceCodeGenerator.convertToElementList(_ife.getChildNodes());
        for (Element element : interfaceElements) {
            switch (element.getTagName().toLowerCase()) {
                case "method": {
                    additionalClasses.addAll(this.extractMethods(element, interfaceClass));
                    break;
                }
                case "property": {
                    additionalClasses.addAll(this.extractProperties(element, interfaceClass));
                    break;
                }
                case "signal": {
                    additionalClasses.addAll(this.extractSignals(element, interfaceClass));
                }
            }
        }
        filesToCreate.put(new File(interfaceClass.getFileName()), interfaceClass.createClassFileContent());
        for (ClassBuilderInfo cbi : additionalClasses) {
            filesToCreate.put(new File(cbi.getFileName()), cbi.createClassFileContent());
        }
        return filesToCreate;
    }

    private List<ClassBuilderInfo> extractSignals(Element _signalElement, ClassBuilderInfo _clzBldr) throws IOException, DBusException {
        ArrayList<ClassBuilderInfo> additionalClasses = new ArrayList<ClassBuilderInfo>();
        if (!_signalElement.hasChildNodes()) {
            this.logger.warn("Signal without any input/output arguments. These are not supported yet, please open a ticket at github!");
            return additionalClasses;
        }
        String className = _signalElement.getAttribute("name");
        if (className.contains(".")) {
            className = className.substring(className.lastIndexOf("."));
        }
        ClassBuilderInfo innerClass = new ClassBuilderInfo();
        innerClass.setClassType(ClassBuilderInfo.ClassType.CLASS);
        innerClass.setExtendClass(DBusSignal.class.getName());
        innerClass.getImports().add(DBusSignal.class.getName());
        innerClass.getImports().add(DBusException.class.getName());
        innerClass.setClassName(className);
        _clzBldr.getInnerClasses().add(innerClass);
        List signalArgs = XmlUtil.convertToElementList((NodeList)XmlUtil.applyXpathExpressionToDocument((String)"arg", (Node)_signalElement));
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        int unknownArgCnt = 0;
        for (Element element : signalArgs) {
            String argType = TypeConverter.getJavaTypeFromDBusType(element.getAttribute("type"), _clzBldr.getImports());
            String argName = Util.snakeToCamelCase((String)element.getAttribute("name"));
            if (Util.isBlank((String)argName)) {
                argName = "arg" + unknownArgCnt;
                ++unknownArgCnt;
            }
            args.put(argName, TypeConverter.getProperJavaClass(argType, _clzBldr.getImports()));
        }
        for (Map.Entry entry : args.entrySet()) {
            innerClass.getMembers().add(new ClassBuilderInfo.MemberOrArgument((String)entry.getKey(), (String)entry.getValue(), true));
        }
        ClassBuilderInfo.ClassConstructor classConstructor = new ClassBuilderInfo.ClassConstructor();
        ArrayList<ClassBuilderInfo.MemberOrArgument> arrayList = new ArrayList<ClassBuilderInfo.MemberOrArgument>();
        for (Map.Entry e : args.entrySet()) {
            arrayList.add(new ClassBuilderInfo.MemberOrArgument("_" + (String)e.getKey(), (String)e.getValue(), false));
        }
        classConstructor.getArguments().addAll(arrayList);
        classConstructor.getThrowArguments().add(DBusException.class.getSimpleName());
        classConstructor.getSuperArguments().add(new ClassBuilderInfo.MemberOrArgument("_path", "String", false));
        classConstructor.getSuperArguments().add(new ClassBuilderInfo.MemberOrArgument("_interfaceName", "String", false));
        innerClass.getConstructors().add(classConstructor);
        return additionalClasses;
    }

    private List<ClassBuilderInfo> extractMethods(Element _methodElement, ClassBuilderInfo _clzBldr) throws IOException, DBusException {
        ArrayList<ClassBuilderInfo> additionalClasses = new ArrayList<ClassBuilderInfo>();
        if (_methodElement.hasChildNodes()) {
            List<Element> methodArgs = InterfaceCodeGenerator.convertToElementList(XmlUtil.applyXpathExpressionToDocument((String)"./arg", (Node)_methodElement));
            ArrayList<ClassBuilderInfo.MemberOrArgument> inputArgs = new ArrayList<ClassBuilderInfo.MemberOrArgument>();
            ArrayList<ClassBuilderInfo.MemberOrArgument> outputArgs = new ArrayList<ClassBuilderInfo.MemberOrArgument>();
            int unknownArgNameCnt = 0;
            for (Element argElm : methodArgs) {
                String structPart;
                String parentType;
                String argName = argElm.getAttribute("name");
                String argType = argElm.getAttribute("type").contains("(") ? ((parentType = this.buildStructClass(structPart = argElm.getAttribute("type").replaceAll("(\\(.+\\))", "$1"), _methodElement.getAttribute("name") + "Struct", _clzBldr, additionalClasses)) != null ? parentType : null) : TypeConverter.getJavaTypeFromDBusType(argElm.getAttribute("type"), _clzBldr.getImports());
                if (Util.isBlank((String)argName)) {
                    argName = "arg" + unknownArgNameCnt;
                    ++unknownArgNameCnt;
                } else {
                    argName = Util.snakeToCamelCase((String)argName);
                }
                if ("in".equals(argElm.getAttribute("direction"))) {
                    inputArgs.add(new ClassBuilderInfo.MemberOrArgument(argName, TypeConverter.getProperJavaClass(argType, _clzBldr.getImports())));
                    continue;
                }
                if (!"out".equals(argElm.getAttribute("direction"))) continue;
                outputArgs.add(new ClassBuilderInfo.MemberOrArgument(argName, TypeConverter.getProperJavaClass(argType, _clzBldr.getImports()), false));
            }
            if (outputArgs.size() > 1) {
                this.logger.debug("Found method with multiple return values: {}", (Object)_methodElement.getAttribute("name"));
                String string = this.createTuple(outputArgs, _methodElement.getAttribute("name") + "Tuple", _clzBldr, additionalClasses);
            }
            this.logger.debug("Found method with arguments: {}({})", (Object)_methodElement.getAttribute("name"), inputArgs);
            String resultType = outputArgs.isEmpty() ? "void" : ((ClassBuilderInfo.MemberOrArgument)outputArgs.get(0)).getFullType(new HashSet<String>());
            ClassBuilderInfo.ClassMethod classMethod = new ClassBuilderInfo.ClassMethod(_methodElement.getAttribute("name"), resultType, false);
            classMethod.getArguments().addAll(inputArgs);
            _clzBldr.getMethods().add(classMethod);
        } else {
            ClassBuilderInfo.ClassMethod classMethod = new ClassBuilderInfo.ClassMethod(_methodElement.getAttribute("name"), "void", false);
            _clzBldr.getMethods().add(classMethod);
        }
        return additionalClasses;
    }

    private List<ClassBuilderInfo> extractProperties(Element _propertyElement, ClassBuilderInfo _clzBldr) throws DBusException {
        String clzzName;
        boolean isComplex;
        String type;
        ArrayList<ClassBuilderInfo> additionalClasses = new ArrayList<ClassBuilderInfo>();
        String attrName = _propertyElement.getAttribute("name");
        String attrAccess = _propertyElement.getAttribute("access");
        String attrType = _propertyElement.getAttribute("type");
        String access = DBusProperty.Access.READ.getAccessName().equals(attrAccess) ? DBusProperty.Access.READ.name() : (DBusProperty.Access.WRITE.getAccessName().equals(attrAccess) ? DBusProperty.Access.WRITE.name() : DBusProperty.Access.READ_WRITE.name());
        _clzBldr.getImports().add(DBusProperty.Access.class.getCanonicalName());
        if ("av".equals(attrType)) {
            type = List.class.getName();
            _clzBldr.getImports().add(type);
        } else if ("a{vv}".equals(attrType)) {
            type = Map.class.getName();
            _clzBldr.getImports().add(type);
        } else if (attrType.contains("(")) {
            String structPart = attrType.replaceAll("(\\(.+\\))", "$1");
            type = this.buildStructClass(structPart, "Property" + attrName + "Struct", _clzBldr, additionalClasses);
        } else {
            type = TypeConverter.getJavaTypeFromDBusType(attrType, _clzBldr.getImports());
        }
        if (type == null) {
            type = Variant.class.getName();
        }
        if (!(isComplex = (type = type.replaceAll(CharSequence.class.getName(), String.class.getName())).contains("<"))) {
            clzzName = ClassBuilderInfo.getClassName(type);
        } else {
            type = TypeRef.class.getName() + "<" + type + ">";
            String typeRefInterfaceName = "Property" + attrName + "Type";
            ClassBuilderInfo propertyTypeRef = new ClassBuilderInfo();
            propertyTypeRef.setClassType(ClassBuilderInfo.ClassType.INTERFACE);
            propertyTypeRef.setClassName(typeRefInterfaceName);
            propertyTypeRef.setExtendClass(type);
            _clzBldr.getInnerClasses().add(propertyTypeRef);
            clzzName = _clzBldr.getClassName() + "." + typeRefInterfaceName;
        }
        String annotationParams = "name = \"" + attrName + "\", type = " + clzzName + ".class, access = " + DBusProperty.Access.class.getSimpleName() + "." + access;
        ClassBuilderInfo.AnnotationInfo annotationInfo = new ClassBuilderInfo.AnnotationInfo(DBusProperty.class, annotationParams);
        _clzBldr.getAnnotations().add(annotationInfo);
        return additionalClasses;
    }

    private String createTuple(List<ClassBuilderInfo.MemberOrArgument> _outputArgs, String _className, ClassBuilderInfo _parentClzBldr, List<ClassBuilderInfo> _additionalClasses) {
        if (_outputArgs == null || _outputArgs.isEmpty() || _additionalClasses == null) {
            return null;
        }
        ClassBuilderInfo info = new ClassBuilderInfo();
        info.setClassName(_className);
        info.setPackageName(_parentClzBldr.getPackageName());
        info.setExtendClass(Tuple.class.getName());
        if (!_outputArgs.isEmpty()) {
            info.getImports().add(Position.class.getName());
        }
        int position = 0;
        for (ClassBuilderInfo.MemberOrArgument entry : _outputArgs) {
            entry.getAnnotations().add("@Position(" + position + ")");
        }
        ClassBuilderInfo.ClassConstructor cnstrct = new ClassBuilderInfo.ClassConstructor();
        cnstrct.getArguments().addAll(_outputArgs);
        _additionalClasses.add(info);
        return info.getFqcn();
    }

    private String buildStructClass(String _dbusTypeStr, String _structName, ClassBuilderInfo _packageName, List<ClassBuilderInfo> _structClasses) throws DBusException {
        return new StructTreeBuilder().buildStructClasses(_dbusTypeStr, _structName, _packageName, _structClasses);
    }

    static void writeToFile(String _outputDir, Map<File, String> _filesToGenerate) {
        for (Map.Entry<File, String> entry : _filesToGenerate.entrySet()) {
            File outputFile = new File(_outputDir, entry.getKey().getPath());
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            if (Util.writeTextFile((String)outputFile.getAbsolutePath(), (String)entry.getValue(), (Charset)Charset.defaultCharset(), (boolean)false)) {
                LoggerFactory.getLogger(InterfaceCodeGenerator.class).info("Created class file {}", (Object)outputFile.getAbsolutePath());
                continue;
            }
            LoggerFactory.getLogger(InterfaceCodeGenerator.class).error("Could not write content to class file {}", (Object)outputFile.getName());
        }
    }

    public static void main(String[] args) {
        String busName = null;
        String outputDir = null;
        DBusConnection.DBusBusType busType = null;
        boolean ignoreDtd = true;
        String objectPath = null;
        String inputFile = null;
        for (int i = 0; i < args.length; ++i) {
            String p = args[i];
            if ("--system".equals(p) || "-y".equals(p)) {
                busType = DBusConnection.DBusBusType.SYSTEM;
                continue;
            }
            if ("--session".equals(p) || "-s".equals(p)) {
                busType = DBusConnection.DBusBusType.SESSION;
                continue;
            }
            if ("--enable-dtd-validation".equals(p)) {
                ignoreDtd = false;
                continue;
            }
            if ("--help".equals(p) || "-h".equals(p)) {
                InterfaceCodeGenerator.printHelp();
                System.exit(0);
                continue;
            }
            if ("--version".equals(p) || "-v".equals(p)) {
                InterfaceCodeGenerator.version();
                System.exit(0);
                continue;
            }
            if ("--outputDir".equals(p) || "-o".equals(p)) {
                if (args.length > i) {
                    outputDir = args[++i];
                    continue;
                }
                InterfaceCodeGenerator.printHelp();
                System.exit(0);
                continue;
            }
            if ("--inputFile".equals(p) || "-i".equals(p)) {
                if (args.length > i) {
                    inputFile = args[++i];
                    continue;
                }
                InterfaceCodeGenerator.printHelp();
                System.exit(0);
                continue;
            }
            if (null == busName) {
                busName = p;
                continue;
            }
            if (null == objectPath) {
                objectPath = p;
                continue;
            }
            InterfaceCodeGenerator.printHelp();
            System.exit(1);
        }
        if (objectPath == null) {
            objectPath = "/";
        }
        if (outputDir == null) {
            throw new RuntimeException("No output directory (--outputDir) given!");
        }
        Logger logger = LoggerFactory.getLogger(InterfaceCodeGenerator.class);
        String introspectionData = null;
        if (!Util.isBlank(inputFile)) {
            File file = new File(inputFile);
            if (!file.exists()) {
                logger.error("Given input file {} does not exist", (Object)file);
                System.exit(1);
            }
            introspectionData = Util.readFileToString((File)file);
        } else if (!Util.isBlank(busName)) {
            try {
                logger.info("Introspecting: { Interface: {}, Busname: {} }", (Object)objectPath, busName);
                DBusConnection conn = DBusConnection.getConnection((DBusConnection.DBusBusType)busType);
                Introspectable in = (Introspectable)conn.getRemoteObject(busName, objectPath, Introspectable.class);
                introspectionData = in.Introspect();
                if (Util.isBlank((String)introspectionData)) {
                    logger.error("Failed to get introspection data");
                    System.exit(1);
                }
                conn.disconnect();
            }
            catch (DBusException | DBusExecutionException _ex) {
                logger.error("Failure in DBus Communications. ", _ex);
                System.exit(1);
            }
        } else {
            logger.error("Busname missing!");
            System.exit(1);
        }
        InterfaceCodeGenerator ci2 = new InterfaceCodeGenerator(introspectionData, objectPath, busName);
        try {
            Map<File, String> analyze = ci2.analyze(ignoreDtd);
            if (analyze == null) {
                logger.error("Unable to create interface files");
                return;
            }
            InterfaceCodeGenerator.writeToFile(outputDir, analyze);
            logger.info("Interface creation finished");
        }
        catch (Exception _ex) {
            logger.error("Error while analyzing introspection data", (Throwable)_ex);
        }
    }

    private static void version() {
        System.out.println("Java D-Bus Version " + System.getProperty("Version"));
        System.exit(1);
    }

    private static void printHelp() {
        System.out.println("Syntax: <options> [busname object] [object path]");
        System.out.println("        Options: ");
        System.out.println("        --system           | -y           Use SYSTEM DBus");
        System.out.println("        --session          | -s           Use SESSION DBus");
        System.out.println("        --outputDir <Dir>  | -o <Dir>     Use <Dir> as output directory for all generated files");
        System.out.println("        --inputFile <File> | -i <File>    Use <File> as XML introspection input file instead of querying DBus");
        System.out.println("");
        System.out.println("        --enable-dtd-validation          Enable DTD validation of introspection XML");
        System.out.println("        --version                        Show version information");
        System.out.println("        --help                           Show this help");
        System.out.println("");
        System.out.println("If --inputFile is given busname object argument can be skipped (or * can be used), that will force the util to extract all interfaces found in the given file.");
        System.out.println("If busname (not empty, blank and not '*') is given, then only interfaces starting with the given busname will be extracted.");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum DbusInterfaceToFqcn {
        PACKAGENAME,
        ORIG_PKGNAME,
        CLASSNAME,
        DBUS_INTERFACE_NAME;


        public static Map<DbusInterfaceToFqcn, String> toFqcn(String _interfaceName) {
            String packageName = _interfaceName.contains(".") ? _interfaceName.substring(0, _interfaceName.lastIndexOf(".")) : _interfaceName;
            String className = _interfaceName.substring(_interfaceName.lastIndexOf(".") + 1);
            LinkedHashMap<DbusInterfaceToFqcn, String> map = new LinkedHashMap<DbusInterfaceToFqcn, String>();
            map.put(CLASSNAME, Util.upperCaseFirstChar((String)className));
            map.put(PACKAGENAME, packageName.toLowerCase());
            if (!packageName.equals(packageName.toLowerCase())) {
                map.put(ORIG_PKGNAME, packageName);
                map.put(DBUS_INTERFACE_NAME, packageName + "." + className);
            }
            return map;
        }
    }
}

