/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import java.util.Set;
import org.freedesktop.dbus.utils.generator.ClassBuilderInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ClassBuilderInfoTest {
    ClassBuilderInfoTest() {
    }

    @Test
    void testGetSimpleTypeClasses() {
        Assertions.assertEquals((Object)"Class1", (Object)ClassBuilderInfo.getSimpleTypeClasses((String)"Class1"));
        Assertions.assertEquals((Object)"Class1", (Object)ClassBuilderInfo.getSimpleTypeClasses((String)"com.example.Class1"));
        Assertions.assertEquals((Object)"Map<Class1, List<String>>", (Object)ClassBuilderInfo.getSimpleTypeClasses((String)"java.util.Map<com.example.Class1, java.util.List<java.lang.String>>"));
        Assertions.assertEquals((Object)"Map<Class1, List<String>>", (Object)ClassBuilderInfo.getSimpleTypeClasses((String)"java.util.Map<Class1, java.util.List<java.lang.String>>"));
        Assertions.assertEquals((Object)"Map<Class1, List<String>>", (Object)ClassBuilderInfo.getSimpleTypeClasses((String)"Map<com.example.Class1, java.util.List<java.lang.String>>"));
        Assertions.assertEquals((Object)"Map<Class1, List<String>>", (Object)ClassBuilderInfo.getSimpleTypeClasses((String)"java.util.Map<com.example.Class1, List<String>>"));
        Assertions.assertEquals((Object)"Map<?, List<?>>", (Object)ClassBuilderInfo.getSimpleTypeClasses((String)"java.util.Map<?, java.util.List<?>>"));
    }

    @Test
    void testGetImportsForType() {
        Set imports = ClassBuilderInfo.getImportsForType((String)"com.example.Class1");
        Assertions.assertEquals((int)1, (int)imports.size());
        Assertions.assertTrue((boolean)imports.contains("com.example.Class1"));
        imports = ClassBuilderInfo.getImportsForType((String)"Class1");
        Assertions.assertEquals((int)0, (int)imports.size());
        imports = ClassBuilderInfo.getImportsForType((String)"java.lang.String");
        Assertions.assertEquals((int)0, (int)imports.size());
        imports = ClassBuilderInfo.getImportsForType((String)"java.util.Map<com.example.Class1, java.util.List<java.lang.String>>");
        Assertions.assertEquals((int)3, (int)imports.size());
        Assertions.assertTrue((boolean)imports.contains("java.util.Map"));
        Assertions.assertTrue((boolean)imports.contains("com.example.Class1"));
        Assertions.assertTrue((boolean)imports.contains("java.util.List"));
        imports = ClassBuilderInfo.getImportsForType((String)"java.util.Map<?, java.util.List<?>>");
        Assertions.assertEquals((int)2, (int)imports.size());
        Assertions.assertTrue((boolean)imports.contains("java.util.Map"));
        Assertions.assertTrue((boolean)imports.contains("java.util.List"));
        imports = ClassBuilderInfo.getImportsForType((String)"java.util.List<Class1>");
        Assertions.assertEquals((int)1, (int)imports.size());
        Assertions.assertTrue((boolean)imports.contains("java.util.List"));
    }
}

