/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.translator;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.DBusStructType;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DBusTypeStringToJava {
    private static final String INDENT = "   ";

    public static void main(String[] _args) throws DBusException {
        if (_args == null || _args.length < 1) {
            System.err.println("Signature [e.g. a(ia{sv})] as first argument required");
            return;
        }
        String sig = _args[0];
        System.out.println("Parsing DBus signature: " + sig);
        ArrayList dataType = new ArrayList();
        int readBytes = Marshalling.getJavaType((String)sig, dataType, (int)-1);
        System.out.println(readBytes + " of " + sig.length() + " bytes read");
        System.out.println("Object-Tree:");
        System.out.println("=====================");
        System.out.println();
        for (Type t : dataType) {
            DBusTypeStringToJava.recursive(t, 1);
        }
        System.out.println();
        System.out.println("=====================");
        System.out.println("Done");
    }

    private static void recursive(Type _t, int _indent) {
        if (_t instanceof DBusListType) {
            DBusListType l = (DBusListType)_t;
            System.out.println(DBusTypeStringToJava.repeat(INDENT, _indent) + List.class.getName());
            Type type = l.getActualTypeArguments()[0];
            DBusTypeStringToJava.recursive(type, _indent + 1);
        } else if (_t instanceof DBusMapType) {
            DBusMapType m = (DBusMapType)_t;
            System.out.println(DBusTypeStringToJava.repeat(INDENT, _indent) + Map.class.getName());
            DBusTypeStringToJava.recursive(m.getActualTypeArguments()[0], _indent + 2);
            DBusTypeStringToJava.recursive(m.getActualTypeArguments()[1], _indent + 2);
        } else if (_t instanceof DBusStructType) {
            DBusStructType s = (DBusStructType)_t;
            System.out.println(DBusTypeStringToJava.repeat(INDENT, _indent) + Struct.class.getName());
            for (Type ty : s.getActualTypeArguments()) {
                DBusTypeStringToJava.recursive(ty, _indent + 2);
            }
        } else {
            String str = _t.getTypeName();
            if (str.equals("java.lang.CharSequence")) {
                str = String.class.getName();
            }
            System.out.println(DBusTypeStringToJava.repeat(INDENT, _indent) + str);
        }
    }

    private static String repeat(String _string, int _cnt) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < _cnt; ++i) {
            sb.append(_string);
        }
        return sb.toString();
    }
}

