/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBus;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.viewer.DBusEntry;
import org.freedesktop.dbus.viewer.DBusTableModel;
import org.freedesktop.dbus.viewer.IntrospectAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DBusViewer {
    private static final Map<String, DBusConnection.DBusBusType> CONNECTION_TYPES = new HashMap<String, DBusConnection.DBusBusType>();
    private List<DBusConnection> connections;
    private static final String DOC_TYPE = "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\"\n\"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">";

    public DBusViewer(final Map<String, DBusConnection.DBusBusType> connectionTypes) {
        this.connections = new ArrayList<DBusConnection>(connectionTypes.size());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTabbedPane tabbedPane = new JTabbedPane();
                DBusViewer.this.addTabs(tabbedPane, connectionTypes);
                final JFrame frame = new JFrame("Dbus Viewer");
                frame.setContentPane(tabbedPane);
                frame.setSize(600, 400);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        frame.dispose();
                        for (DBusConnection connection : DBusViewer.this.connections) {
                            connection.disconnect();
                        }
                        System.exit(0);
                    }
                });
                frame.setVisible(true);
            }
        });
    }

    public static void main(String[] args) {
        new DBusViewer(CONNECTION_TYPES);
    }

    private void addTabs(final JTabbedPane tabbedPane, final Map<String, DBusConnection.DBusBusType> connectionTypes) {
        for (String key : connectionTypes.keySet()) {
            JLabel label = new JLabel("Processing DBus for " + key);
            tabbedPane.addTab(key, label);
        }
        Runnable loader = new Runnable(){

            @Override
            public void run() {
                boolean users = true;
                boolean owners = true;
                for (final String key : connectionTypes.keySet()) {
                    try {
                        DBusConnection conn = DBusConnection.getConnection((DBusConnection.DBusBusType)((DBusConnection.DBusBusType)connectionTypes.get(key)));
                        DBusViewer.this.connections.add(conn);
                        final DBusTableModel tableModel = DBusViewer.this.listDBusConnection(users, owners, conn);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int index = tabbedPane.indexOfTab(key);
                                JTable table = new JTable(tableModel);
                                JScrollPane scrollPane = new JScrollPane(table);
                                JPanel tab = new JPanel(new BorderLayout());
                                tab.add((Component)scrollPane, "Center");
                                JPanel southPanel = new JPanel();
                                JButton button = new JButton(new IntrospectAction(table));
                                southPanel.add(button);
                                tab.add((Component)southPanel, "South");
                                tabbedPane.setComponentAt(index, tab);
                            }
                        });
                    }
                    catch (DBusException e) {
                        e.printStackTrace();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int index = tabbedPane.indexOfTab(key);
                                JLabel label = (JLabel)tabbedPane.getComponentAt(index);
                                label.setText("Could not load Dbus information for " + key + ":" + e.getMessage());
                            }
                        });
                    }
                    catch (DBusExecutionException e) {
                        e.printStackTrace();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int index = tabbedPane.indexOfTab(key);
                                JLabel label = (JLabel)tabbedPane.getComponentAt(index);
                                label.setText("Could not load Dbus information for " + key + ":" + e.getMessage());
                            }
                        });
                    }
                }
            }
        };
        Thread thread = new Thread(loader);
        thread.setName("DBus Loader");
        thread.start();
    }

    private DBusTableModel listDBusConnection(boolean users, boolean owners, DBusConnection conn) throws DBusException {
        DBusTableModel model = new DBusTableModel();
        DBus dbus = (DBus)conn.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        String[] names = dbus.ListNames();
        ParsingContext p = new ParsingContext(conn);
        for (String name : names) {
            List<Object> results = new ArrayList();
            try {
                p.visitNode(name, "/");
            }
            catch (DBusException e) {
                e.printStackTrace();
            }
            catch (DBusExecutionException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            results = p.getResult();
            p.reset();
            if (results.size() <= 0) continue;
            if (users) {
                try {
                    UInt32 user = dbus.GetConnectionUnixUser(name);
                    for (DBusEntry dBusEntry : results) {
                        dBusEntry.setUser(user);
                    }
                }
                catch (DBusExecutionException user) {
                    // empty catch block
                }
            }
            if (!name.startsWith(":") && owners) {
                try {
                    String owner = dbus.GetNameOwner(name);
                    for (DBusEntry dBusEntry : results) {
                        dBusEntry.setOwner(owner);
                    }
                }
                catch (DBusExecutionException dBusExecutionException) {
                    // empty catch block
                }
            }
            for (DBusEntry dBusEntry : results) {
                model.add(dBusEntry);
            }
        }
        return model;
    }

    static {
        CONNECTION_TYPES.put("System", DBusConnection.DBusBusType.SYSTEM);
        CONNECTION_TYPES.put("Session", DBusConnection.DBusBusType.SESSION);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class ParsingContext {
        private DBusConnection conn;
        private DocumentBuilder builder;
        private List<DBusEntry> result;

        ParsingContext(DBusConnection _conn) {
            this.conn = _conn;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                this.builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException exPc) {
                throw new RuntimeException("Error during parser init: " + exPc.getMessage(), exPc);
            }
            this.reset();
        }

        DBusEntry addEntry(String name, String path) throws DBusException {
            DBusEntry entry = new DBusEntry();
            entry.setName(name);
            entry.setPath(path);
            Introspectable introspectable = (Introspectable)this.conn.getRemoteObject(name, path, Introspectable.class);
            entry.setIntrospectable(introspectable);
            this.result.add(entry);
            return entry;
        }

        public void visitNode(String name, String path) throws DBusException, SAXException, IOException {
            System.out.println("visit " + name + ":" + path);
            if ("/org/freedesktop/DBus/Local".equals(path)) {
                return;
            }
            DBusEntry e = this.addEntry(name, path);
            String introspectData = e.getIntrospectable().Introspect();
            Document document = this.builder.parse(new InputSource(new StringReader(introspectData.replace(DBusViewer.DOC_TYPE, ""))));
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node nameNode;
                Node node = children.item(i);
                if (1 != node.getNodeType() || !"node".equals(node.getNodeName()) || (nameNode = node.getAttributes().getNamedItem("name")) == null) continue;
                try {
                    if (path.endsWith("/")) {
                        this.visitNode(name, path + nameNode.getNodeValue());
                        continue;
                    }
                    this.visitNode(name, path + '/' + nameNode.getNodeValue());
                    continue;
                }
                catch (DBusException ex) {
                    ex.printStackTrace();
                }
            }
        }

        public List<DBusEntry> getResult() {
            return this.result;
        }

        void reset() {
            this.result = new ArrayList<DBusEntry>();
        }
    }
}

