/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.bin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.types.DBusStructType;
import org.freedesktop.dbus.utils.bin.IdentifierMangler;
import org.freedesktop.dbus.utils.bin.IterableNodeList;
import org.freedesktop.dbus.utils.bin.PrintStreamFactory;
import org.freedesktop.dbus.utils.bin.StructStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Deprecated
public class CreateInterface {
    private static final Logger logger = LoggerFactory.getLogger(CreateInterface.class);
    public String comment = "";
    boolean builtin;
    private HashMap<String, List<StructStruct>> structPackages = new HashMap();
    private final PrintStreamFactory factory;

    private static String collapseType(Type t, Set<String> imports, Map<StructStruct, Type[]> structs, boolean container, boolean fullnames) throws DBusException {
        if (t instanceof ParameterizedType) {
            Type[] ts;
            Class c = (Class)((ParameterizedType)t).getRawType();
            if (null != structs && t instanceof DBusStructType) {
                int num = 1;
                String name = "Struct";
                while (null != structs.get(new StructStruct(name + num))) {
                    ++num;
                }
                name = name + num;
                structs.put(new StructStruct(name), ((ParameterizedType)t).getActualTypeArguments());
                return name;
            }
            if (null != imports) {
                imports.add(c.getName());
            }
            if (fullnames) {
                return c.getName();
            }
            String s = c.getSimpleName();
            s = s + '<';
            for (Type st : ts = ((ParameterizedType)t).getActualTypeArguments()) {
                s = s + CreateInterface.collapseType(st, imports, structs, true, fullnames) + ',';
            }
            s = s.replaceAll(",$", ">");
            return s;
        }
        if (t instanceof Class) {
            Class c = (Class)t;
            if (c.isArray()) {
                return CreateInterface.collapseType(c.getComponentType(), imports, structs, container, fullnames) + "[]";
            }
            Package p = c.getPackage();
            if (null != imports && !"java.lang".equals(p.getName())) {
                imports.add(c.getName());
            }
            if (container) {
                if (fullnames) {
                    return c.getName();
                }
                return c.getSimpleName();
            }
            try {
                Field f = c.getField("TYPE");
                Class d = (Class)f.get(c);
                return d.getSimpleName();
            }
            catch (Exception e) {
                return c.getSimpleName();
            }
        }
        return "";
    }

    private static String getJavaType(String dbus, Set<String> imports, Map<StructStruct, Type[]> structs, boolean container, boolean fullnames) throws DBusException {
        if (null == dbus || "".equals(dbus)) {
            return "";
        }
        ArrayList v = new ArrayList();
        Marshalling.getJavaType((String)dbus, v, (int)1);
        Type t = (Type)v.get(0);
        return CreateInterface.collapseType(t, imports, structs, container, fullnames);
    }

    public CreateInterface(PrintStreamFactory _factory, boolean _builtin) {
        this.factory = _factory;
        this.builtin = _builtin;
    }

    String parseReturns(List<Element> out, Set<String> imports, Map<String, Integer> tuples, Map<StructStruct, Type[]> structs, String pack) throws DBusException {
        logger.debug("parseReturns");
        String[] names = new String[]{"Pair", "Triplet", "Quad", "Quintuple", "Sextuple", "Septuple"};
        String sig = "";
        String name = null;
        switch (out.size()) {
            case 0: {
                sig = sig + "void ";
                break;
            }
            case 1: {
                sig = sig + CreateInterface.getJavaType(out.get(0).getAttribute("type"), imports, structs, false, false) + " ";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                name = names[out.size() - 2];
            }
            default: {
                if (null == name) {
                    name = "NTuple" + out.size();
                }
                tuples.put(name, out.size());
                imports.add(pack + "." + name);
                sig = sig + name + "<";
                for (Element arg : out) {
                    sig = sig + CreateInterface.getJavaType(arg.getAttribute("type"), imports, structs, true, false) + ", ";
                }
                sig = sig.replaceAll(", $", "> ");
            }
        }
        return sig;
    }

    String parseMethod(Element meth, Set<String> imports, Map<String, Integer> tuples, Map<StructStruct, Type[]> structs, Set<String> exceptions, Set<String> anns, String pack) throws DBusException {
        ArrayList<Element> in = new ArrayList<Element>();
        ArrayList<Element> out = new ArrayList<Element>();
        if (null == meth.getAttribute("name") || "".equals(meth.getAttribute("name"))) {
            System.err.println("ERROR: Method name was blank, failed");
            System.exit(1);
        }
        String annotations = "";
        String throwses = null;
        logger.debug("parseMethod '{}'", (Object)meth.getAttribute("name"));
        for (Node a : new IterableNodeList(meth.getChildNodes())) {
            if (1 != a.getNodeType()) continue;
            CreateInterface.checkNode(a, "arg", "annotation");
            if ("arg".equals(a.getNodeName())) {
                Element arg = (Element)a;
                if ("out".equals(arg.getAttribute("direction"))) {
                    out.add(arg);
                    continue;
                }
                in.add(arg);
                continue;
            }
            if (!"annotation".equals(a.getNodeName())) continue;
            Element e = (Element)a;
            if (e.getAttribute("name").equals("org.freedesktop.DBus.Method.Error")) {
                throwses = null == throwses ? e.getAttribute("value") : throwses + ", " + e.getAttribute("value");
                exceptions.add(e.getAttribute("value"));
                continue;
            }
            annotations = annotations + this.parseAnnotation(e, imports, anns);
        }
        String sig = "";
        this.comment = "";
        sig = sig + this.parseReturns(out, imports, tuples, structs, pack);
        sig = sig + IdentifierMangler.mangle(meth.getAttribute("name")) + "(";
        char defaultname = 'a';
        String params = "";
        for (Element arg : in) {
            String type = CreateInterface.getJavaType(arg.getAttribute("type"), imports, structs, false, false);
            String name = arg.getAttribute("name");
            if (null == name || "".equals(name)) {
                char c = defaultname;
                defaultname = (char)(defaultname + 1);
                name = "" + c;
            }
            params = params + type + " " + IdentifierMangler.mangle(name) + ", ";
        }
        return ("".equals(this.comment) ? "" : "   /**\n" + this.comment + "   */\n") + annotations + "  public " + sig + params.replaceAll("..$", "") + ")" + (null == throwses ? "" : " throws " + throwses) + ";";
    }

    String parseSignal(Element signal, Set<String> imports, Map<StructStruct, Type[]> structs, Set<String> anns) throws DBusException {
        logger.debug("parseSignal");
        HashMap<String, String> params = new HashMap<String, String>();
        ArrayList<String> porder = new ArrayList<String>();
        char defaultname = 'a';
        imports.add("org.freedesktop.dbus.messages.DBusSignal");
        imports.add("org.freedesktop.dbus.exceptions.DBusException");
        String annotations = "";
        for (Node a : new IterableNodeList(signal.getChildNodes())) {
            if (1 != a.getNodeType()) continue;
            CreateInterface.checkNode(a, "arg", "annotation");
            if ("annotation".equals(a.getNodeName())) {
                annotations = annotations + this.parseAnnotation((Element)a, imports, anns);
                continue;
            }
            Element arg = (Element)a;
            String type = CreateInterface.getJavaType(arg.getAttribute("type"), imports, structs, false, false);
            String name = arg.getAttribute("name");
            if (null == name || "".equals(name)) {
                char c = defaultname;
                defaultname = (char)(defaultname + 1);
                name = "" + c;
            }
            params.put(IdentifierMangler.mangle(name), type);
            porder.add(IdentifierMangler.mangle(name));
        }
        String out = "";
        out = out + annotations;
        out = out + "   public static class " + signal.getAttribute("name");
        out = out + " extends DBusSignal\n   {\n";
        for (String name : porder) {
            out = out + "      public final " + (String)params.get(name) + " " + name + ";\n";
        }
        out = out + "      public " + signal.getAttribute("name") + "(String path";
        for (String name : porder) {
            out = out + ", " + (String)params.get(name) + " " + name;
        }
        out = out + ") throws DBusException\n      {\n         super(path";
        for (String name : porder) {
            out = out + ", " + name;
        }
        out = out + ");\n";
        for (String name : porder) {
            out = out + "         this." + name + " = " + name + ";\n";
        }
        out = out + "      }\n";
        out = out + "   }\n";
        return out;
    }

    String parseAnnotation(Element ann, Set<String> imports, Set<String> annotations) {
        logger.debug("parseAnnotation");
        String s = "  @" + ann.getAttribute("name").replaceAll(".*\\.([^.]*)$", "$1") + "(";
        if (null != ann.getAttribute("value") && !"".equals(ann.getAttribute("value"))) {
            s = s + '\"' + ann.getAttribute("value") + '\"';
        }
        imports.add(ann.getAttribute("name"));
        annotations.add(ann.getAttribute("name"));
        s = s + ")\n";
        return s;
    }

    InterfaceDefinition parseInterface(Element iface, Map<String, Integer> tuples, Map<StructStruct, Type[]> structs, Set<String> exceptions, Set<String> anns, String pack) throws DBusException {
        if (null == iface.getAttribute("name") || "".equals(iface.getAttribute("name"))) {
            System.err.println("ERROR: Interface name was blank, failed");
            System.exit(1);
        }
        logger.info("  - create interface '{}'", (Object)iface.getAttribute("name"));
        InterfaceDefinition def = new InterfaceDefinition();
        def.interfaceName = iface.getAttribute("name");
        def.packageName = def.interfaceName.replaceAll("\\.[^.]*$", "");
        String parentPack = def.interfaceName.replaceAll("\\.[^.]*$", "");
        String interfaceName = def.interfaceName.replaceAll("^.*\\.([^.]*)$", "$1");
        def.className = "I" + interfaceName.substring(0, 1).toUpperCase() + interfaceName.substring(1);
        def.file = parentPack.replaceAll("\\.", "/") + "/" + def.className + ".java";
        def.path = def.file.replaceAll("/[^/]*$", "");
        def.annotations = String.format("\n@DBusInterfaceName(value = \"%s\")", def.interfaceName);
        def.imports.add("org.freedesktop.dbus.interfaces.DBusInterface");
        def.imports.add("org.freedesktop.dbus.annotations.DBusInterfaceName");
        for (Node meth : new IterableNodeList(iface.getChildNodes())) {
            if (1 != meth.getNodeType()) continue;
            CreateInterface.checkNode(meth, "method", "signal", "property", "annotation");
            if ("method".equals(meth.getNodeName())) {
                def.methods = def.methods + this.parseMethod((Element)meth, def.imports, tuples, structs, exceptions, anns, pack) + "\n";
                continue;
            }
            if ("signal".equals(meth.getNodeName())) {
                def.signals = def.signals + this.parseSignal((Element)meth, def.imports, structs, anns);
                continue;
            }
            if ("property".equals(meth.getNodeName())) {
                logger.debug("WARNING: Ignoring property");
                continue;
            }
            if (!"annotation".equals(meth.getNodeName())) continue;
            def.annotations = def.annotations + this.parseAnnotation((Element)meth, def.imports, anns);
        }
        return def;
    }

    void createException(String name, String pack, PrintStream out) throws DBusException {
        logger.info("  - create exception '{}'", (Object)name);
        out.println("package " + pack + ";");
        out.println("import org.freedesktop.dbus.exceptions.DBusExecutionException;");
        out.print("public class " + name);
        out.println(" extends DBusExecutionException");
        out.println("{");
        out.println("   public " + name + "(String message)");
        out.println("   {");
        out.println("      super(message);");
        out.println("   }");
        out.println("}");
    }

    void createAnnotation(String name, String pack, PrintStream out) throws DBusException {
        logger.info("  - create annotation '{}'", (Object)name);
        out.println("package " + pack + ";");
        out.println("import java.lang.annotation.Retention;");
        out.println("import java.lang.annotation.RetentionPolicy;");
        out.println("@Retention(RetentionPolicy.RUNTIME)");
        out.println("public @interface " + name);
        out.println("{");
        out.println("   String value();");
        out.println("}");
    }

    void createStruct(String name, Type[] type, String pack, PrintStream out, Map<StructStruct, Type[]> existing) throws DBusException, IOException {
        logger.info("  - create struct '{}.{}'", (Object)pack, (Object)name);
        out.println("package " + pack + ";");
        TreeSet<String> imports = new TreeSet<String>();
        imports.add("org.freedesktop.dbus.annotations.Position");
        imports.add("org.freedesktop.dbus.Struct");
        imports.add(pack + ".*");
        Map<StructStruct, Type[]> structs = new HashMap<StructStruct, Type[]>(existing);
        String[] types = new String[type.length];
        for (int i = 0; i < type.length; ++i) {
            types[i] = CreateInterface.collapseType(type[i], imports, structs, false, false);
        }
        for (String im : imports) {
            out.println("import " + im + ";");
        }
        out.println("public final class " + name + " extends Struct");
        out.println("{");
        int i = 0;
        char c = 'a';
        String params = "";
        for (String t : types) {
            out.println("   @Position(" + i++ + ")");
            out.println("   public final " + t + " " + c + ";");
            params = params + t + " " + c + ", ";
            c = (char)(c + '\u0001');
        }
        out.println("  public " + name + "(" + params.replaceAll("..$", "") + ")");
        out.println("  {");
        for (char d = 'a'; d < c; d = (char)(d + '\u0001')) {
            out.println("   this." + d + " = " + d + ";");
        }
        out.println("  }");
        out.println("}");
        structs = StructStruct.fillPackages(structs, pack);
        HashMap<StructStruct, Type[]> tocreate = new HashMap<StructStruct, Type[]>(structs);
        for (StructStruct ss : existing.keySet()) {
            tocreate.remove(ss);
        }
        this.createStructs(tocreate, structs);
    }

    void createTuple(String name, int num, String pack, PrintStream out) throws DBusException {
        logger.info("  - create tuple '{}'", (Object)name);
        out.println("package " + pack + ";");
        out.println("import org.freedesktop.dbus.annotations.Position;");
        out.println("import org.freedesktop.dbus.Tuple;");
        out.println("/** Just a typed container class */");
        out.print("public final class " + name);
        String types = " <";
        for (char v = 'A'; v < 65 + num; v = (char)(v + '\u0001')) {
            types = types + v + ",";
        }
        out.print(types.replaceAll(",$", "> "));
        out.println("extends Tuple");
        out.println("{");
        char t = 'A';
        char n = 'a';
        int i = 0;
        while (i < num) {
            out.println("   @Position(" + i + ")");
            out.println("   public final " + t + " " + n + ";");
            ++i;
            t = (char)(t + '\u0001');
            n = (char)(n + '\u0001');
        }
        out.print("   public " + name + "(");
        String sig = "";
        t = 'A';
        n = 'a';
        int i2 = 0;
        while (i2 < num) {
            sig = sig + t + " " + n + ", ";
            ++i2;
            t = (char)(t + '\u0001');
            n = (char)(n + '\u0001');
        }
        out.println(sig.replaceAll(", $", ")"));
        out.println("   {");
        for (char v = 'a'; v < 97 + num; v = (char)(v + '\u0001')) {
            out.println("      this." + v + " = " + v + ";");
        }
        out.println("   }");
        out.println("}");
    }

    void parseRoot(Element root) throws DBusException, IOException {
        ArrayList<InterfaceDefinition> interfaceDefs = new ArrayList<InterfaceDefinition>();
        Map<StructStruct, Type[]> structs = new HashMap<StructStruct, Type[]>();
        TreeSet<String> exceptions = new TreeSet<String>();
        TreeSet<String> annotations = new TreeSet<String>();
        for (Node iface : new IterableNodeList(root.getChildNodes())) {
            if (1 != iface.getNodeType()) continue;
            CreateInterface.checkNode(iface, "interface", "node");
            if ("interface".equals(iface.getNodeName())) {
                HashMap<String, Integer> tuples = new HashMap<String, Integer>();
                String name = ((Element)iface).getAttribute("name");
                String pack = name;
                if (pack.startsWith("org.freedesktop.DBus") && !this.builtin) continue;
                InterfaceDefinition def = this.parseInterface((Element)iface, tuples, structs, exceptions, annotations, pack);
                interfaceDefs.add(def);
                structs = StructStruct.fillPackages(structs, pack);
                this.createTuples(tuples, pack);
                continue;
            }
            if ("node".equals(iface.getNodeName())) {
                this.parseRoot((Element)iface);
                continue;
            }
            System.err.println("ERROR: Unknown node: " + iface.getNodeName());
            System.exit(1);
        }
        this.createStructs(structs, structs);
        this.createExceptions(exceptions);
        this.createAnnotations(annotations);
        for (InterfaceDefinition def : interfaceDefs) {
            for (String sspack : this.structPackages.keySet()) {
                def.imports.add(sspack + ".*");
            }
            logger.info("  - writing interface {}.{}", (Object)def.packageName, (Object)def.className);
            this.factory.init(def.file, def.path);
            def.write(this.factory.createPrintStream(def.file));
        }
    }

    private void createAnnotations(Set<String> annotations) throws DBusException, IOException {
        logger.debug("createAnnotations");
        for (String fqn : annotations) {
            String name = fqn.replaceAll("^.*\\.([^.]*)$", "$1");
            String pack = fqn.replaceAll("\\.[^.]*$", "");
            if (pack.startsWith("org.freedesktop.DBus") && !this.builtin) continue;
            String path = pack.replaceAll("\\.", "/");
            String file = name.replaceAll("\\.", "/") + ".java";
            this.factory.init(file, path);
            this.createAnnotation(name, pack, this.factory.createPrintStream(path, name));
        }
    }

    private void createExceptions(Set<String> exceptions) throws DBusException, IOException {
        logger.debug("createExceptions");
        for (String fqn : exceptions) {
            String name = fqn.replaceAll("^.*\\.([^.]*)$", "$1");
            String pack = fqn.replaceAll("\\.[^.]*$", "");
            if (pack.startsWith("org.freedesktop.DBus") && !this.builtin) continue;
            String path = pack.replaceAll("\\.", "/");
            String file = name.replaceAll("\\.", "/") + ".java";
            this.factory.init(file, path);
            this.createException(name, pack, this.factory.createPrintStream(path, name));
        }
    }

    private void createStructs(Map<StructStruct, Type[]> structs, Map<StructStruct, Type[]> existing) throws DBusException, IOException {
        logger.debug("createStructs");
        for (StructStruct ss : structs.keySet()) {
            List<Object> packageStructs;
            String file = ss.name.replaceAll("\\.", "/") + ".java";
            String path = ss.pack.replaceAll("\\.", "/");
            this.factory.init(file, path);
            this.createStruct(ss.name, structs.get(ss), ss.pack, this.factory.createPrintStream(path, ss.name), existing);
            if (this.structPackages.containsKey(ss.pack)) {
                packageStructs = this.structPackages.get(ss.pack);
            } else {
                packageStructs = new ArrayList();
                this.structPackages.put(ss.pack, packageStructs);
            }
            packageStructs.add(ss);
        }
    }

    private void createTuples(Map<String, Integer> typeMap, String pack) throws DBusException, IOException {
        logger.debug("createTuples");
        for (String tname : typeMap.keySet()) {
            this.createTuple(tname, typeMap.get(tname), pack, this.factory.createPrintStream(pack.replaceAll("\\.", "/"), tname));
        }
    }

    static void checkNode(Node n, String ... names) {
        String expected = "";
        for (String name : names) {
            if (name.equals(n.getNodeName())) {
                return;
            }
            expected = expected + name + " or ";
        }
        System.err.println(String.format("ERROR: Expected %s, got %s, failed.", expected.replaceAll("....$", ""), n.getNodeName()));
        System.exit(1);
    }

    static void printSyntax() {
        CreateInterface.printSyntax(System.err);
    }

    static void printSyntax(PrintStream o) {
        o.println("Syntax: CreateInterface <options> [file | busname object]");
        o.println("        Options: --no-ignore-builtin  --enable-dtd-validation --system -y --session -s --create-files -f --help -h --version -v");
    }

    public static void version() {
        System.out.println("Java D-Bus Version " + System.getProperty("Version"));
        System.exit(1);
    }

    static Config parseParams(String[] args) {
        Config config = new Config();
        for (String p : args) {
            if ("--system".equals(p) || "-y".equals(p)) {
                config.bus = DBusConnection.DBusBusType.SYSTEM;
                continue;
            }
            if ("--session".equals(p) || "-s".equals(p)) {
                config.bus = DBusConnection.DBusBusType.SESSION;
                continue;
            }
            if ("--no-ignore-builtin".equals(p)) {
                config.builtin = true;
                continue;
            }
            if ("--create-files".equals(p) || "-f".equals(p)) {
                config.fileout = true;
                continue;
            }
            if ("--print-tree".equals(p) || "-p".equals(p)) {
                config.printtree = true;
                continue;
            }
            if ("--enable-dtd-validation".equals(p)) {
                config.ignoreDtd = false;
                continue;
            }
            if ("--help".equals(p) || "-h".equals(p)) {
                CreateInterface.printSyntax(System.out);
                System.exit(0);
                continue;
            }
            if ("--version".equals(p) || "-v".equals(p)) {
                CreateInterface.version();
                System.exit(0);
                continue;
            }
            if (p.startsWith("-")) {
                System.err.println("ERROR: Unknown option: " + p);
                CreateInterface.printSyntax();
                System.exit(1);
                continue;
            }
            if (null == config.busname) {
                config.busname = p;
                continue;
            }
            if (null == config.object) {
                config.object = p;
                continue;
            }
            CreateInterface.printSyntax();
            System.exit(1);
        }
        if (null == config.busname) {
            CreateInterface.printSyntax();
            System.exit(1);
        } else if (null == config.object) {
            config.datafile = new File(config.busname);
            config.busname = null;
        }
        return config;
    }

    public static void main(String[] args) throws Exception {
        Config config = CreateInterface.parseParams(args);
        Reader introspectdata = null;
        if (null != config.busname) {
            try {
                logger.info("Introspecting:");
                logger.info("  - interface '{}'", (Object)config.busname);
                logger.info("  - objectPath '{}'", (Object)config.object);
                DBusConnection conn = DBusConnection.getConnection((DBusConnection.DBusBusType)config.bus);
                Introspectable in = (Introspectable)conn.getRemoteObject(config.busname, config.object, Introspectable.class);
                String id = in.Introspect();
                if (null == id) {
                    System.err.println("ERROR: Failed to get introspection data");
                    System.exit(1);
                }
                introspectdata = new StringReader(id);
                conn.disconnect();
            }
            catch (DBusException exD) {
                System.err.println("ERROR: Failure in DBus Communications: " + exD.getMessage());
                System.exit(1);
            }
            catch (DBusExecutionException exDee) {
                System.err.println("ERROR: Failure in DBus Communications: " + exDee.getMessage());
                System.exit(1);
            }
        } else if (null != config.datafile) {
            try {
                introspectdata = new InputStreamReader(new FileInputStream(config.datafile));
            }
            catch (FileNotFoundException exFnf) {
                System.err.println("ERROR: Could not find introspection file: " + exFnf.getMessage());
                System.exit(1);
            }
        }
        try {
            logger.info("Generating code: ");
            PrintStreamFactory factory = config.fileout ? new FileStreamFactory() : new ConsoleStreamFactory();
            CreateInterface createInterface = new CreateInterface(factory, config.builtin);
            createInterface.createInterface(introspectdata, config);
        }
        catch (DBusException exD) {
            System.err.println("ERROR: " + exD.getMessage());
            System.exit(1);
        }
    }

    public void createInterface(Reader _introspectdata, Config _config) throws ParserConfigurationException, SAXException, IOException, DBusException {
        DocumentBuilderFactory lfactory = DocumentBuilderFactory.newInstance();
        if (_config != null && _config.ignoreDtd) {
            lfactory.setValidating(false);
            lfactory.setNamespaceAware(true);
            lfactory.setFeature("http://xml.org/sax/features/namespaces", false);
            lfactory.setFeature("http://xml.org/sax/features/validation", false);
            lfactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            lfactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        DocumentBuilder builder = lfactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(_introspectdata));
        Element root = document.getDocumentElement();
        CreateInterface.checkNode(root, "node");
        this.parseRoot(root);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public class InterfaceDefinition {
        String interfaceName;
        String packageName;
        String className;
        String file;
        String path;
        Set<String> imports = new TreeSet<String>();
        String methods = "";
        String signals = "";
        String annotations;

        void write(PrintStream out) {
            out.println("package " + this.packageName + ";");
            out.println();
            if (this.imports.size() > 0) {
                for (String i : this.imports) {
                    out.println("import " + i + ";");
                }
            }
            out.println(this.annotations);
            out.print("public interface " + this.className);
            out.println(" extends DBusInterface");
            out.println("{");
            out.println(this.signals);
            out.println(this.methods);
            out.println("}");
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Config {
        DBusConnection.DBusBusType bus = DBusConnection.DBusBusType.SESSION;
        String busname = null;
        String object = null;
        File datafile = null;
        boolean printtree = false;
        boolean fileout = false;
        boolean builtin = false;
        boolean ignoreDtd = true;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class FileStreamFactory
    extends PrintStreamFactory {
        FileStreamFactory() {
        }

        @Override
        public void init(String file, String path) {
            new File(path).mkdirs();
        }

        @Override
        public PrintStream createPrintStream(String file) throws IOException {
            logger.debug("Writing to {}", (Object)file);
            return new PrintStream(new FileOutputStream(file));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class ConsoleStreamFactory
    extends PrintStreamFactory {
        ConsoleStreamFactory() {
        }

        @Override
        public void init(String file, String path) {
        }

        @Override
        public PrintStream createPrintStream(String file) throws IOException {
            logger.debug("Writing to {}", (Object)file);
            System.out.println("/* File: " + file + " */");
            return System.out;
        }

        @Override
        public PrintStream createPrintStream(String path, String tname) throws IOException {
            return super.createPrintStream(path, tname);
        }
    }
}

