/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.dbus.utils.Util;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TypeConverter {
    private static final Map<String, String> CLASS_MAP = new HashMap<String, String>();

    public static String getProperJavaClass(String _argType, Set<String> _includes) {
        String clazzName = null;
        if (_argType == null) {
            return _argType;
        }
        if (_argType.contains("<")) {
            clazzName = _argType;
            for (Map.Entry<String, String> clzzNames : CLASS_MAP.entrySet()) {
                if (!clazzName.contains(clzzNames.getKey())) continue;
                clazzName = clazzName.replace(clzzNames.getKey(), clzzNames.getValue());
                if (clzzNames.getKey().startsWith("java.lang.")) continue;
                _includes.add(clzzNames.getKey());
            }
            clazzName = clazzName.replace("java.lang.", "");
            Pattern compile = Pattern.compile("([^, <>]+)");
            Matcher matcher = compile.matcher(clazzName);
            while (matcher.find()) {
                String match = matcher.group();
                if (!_includes.contains(match)) continue;
                String plainClazzName = match.substring(match.lastIndexOf(".") + 1);
                clazzName = clazzName.replace(match, plainClazzName);
            }
        } else {
            clazzName = _argType.substring(_argType.lastIndexOf(".") + 1);
            return TypeConverter.convertJavaType(clazzName, true);
        }
        return clazzName;
    }

    private static String convertJavaType(String _fqcn, boolean _usePrimitives) {
        if (_fqcn == null) {
            return _fqcn;
        }
        String clazzName = _fqcn;
        if (_fqcn.contains(".")) {
            clazzName = _fqcn.substring(_fqcn.lastIndexOf(".") + 1);
        }
        if (CLASS_MAP.containsKey(_fqcn)) {
            return CLASS_MAP.get(_fqcn);
        }
        if (clazzName.equals("CharSequence")) {
            return "String";
        }
        if (clazzName.equals("Variant")) {
            return "Variant<?>";
        }
        return _usePrimitives ? TypeConverter.convertJavaBoxedTypeToPrimitive(clazzName) : clazzName;
    }

    private static String convertJavaBoxedTypeToPrimitive(String _clazzName) {
        switch (_clazzName) {
            case "Boolean": {
                return "boolean";
            }
            case "Integer": {
                return "int";
            }
            case "Long": {
                return "long";
            }
            case "Double": {
                return "double";
            }
            case "Float": {
                return "float";
            }
            case "Byte": {
                return "byte";
            }
            case "Char": {
                return "char";
            }
        }
        return _clazzName;
    }

    public static String getJavaTypeFromDBusType(String _dbusType, Set<String> _javaIncludes) throws DBusException {
        String type;
        ArrayList dataType = new ArrayList();
        if (Util.isBlank((String)_dbusType)) {
            return null;
        }
        if (_dbusType.length() == 1) {
            Marshalling.getJavaType((String)_dbusType, dataType, (int)1);
            type = dataType.stream().map(t -> t.getTypeName()).collect(Collectors.joining(""));
            _javaIncludes.add(type);
        } else {
            type = TypeConverter.getTypeAdv(_dbusType, _javaIncludes);
        }
        return type;
    }

    private static Map<String, List<String>> getTypeAdv(Type _type, List<String> _innerGenerics) throws DBusException {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        if (_type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)_type;
            ArrayList<String> generics = new ArrayList<String>();
            result.put(pType.getRawType().getTypeName(), generics);
            for (Type t : pType.getActualTypeArguments()) {
                if (t instanceof ParameterizedType) {
                    result.putAll(TypeConverter.getTypeAdv(t, generics));
                    continue;
                }
                generics.add(t.getTypeName());
            }
        } else {
            result.put(_type.getTypeName(), new ArrayList());
        }
        return result;
    }

    private static String getTypeAdv(String _dbusType, Set<String> _javaIncludes) throws DBusException {
        if (Util.isBlank((String)_dbusType)) {
            return null;
        }
        ArrayList dataType = new ArrayList();
        Marshalling.getJavaType((String)_dbusType, dataType, (int)1);
        if (dataType.get(0) instanceof DBusListType || dataType.get(0) instanceof DBusMapType) {
            ParameterizedType dBusListType = (ParameterizedType)dataType.get(0);
            Type[] actualTypeArguments = dBusListType.getActualTypeArguments();
            String retVal = dBusListType.getRawType().getTypeName();
            ArrayList<String> internalTypes = new ArrayList<String>();
            if (actualTypeArguments.length > 0) {
                LinkedHashMap<String, List<String>> allAdvTypes = new LinkedHashMap<String, List<String>>();
                for (Type type : actualTypeArguments) {
                    Map<String, List<String>> typeAdv = TypeConverter.getTypeAdv(type, null);
                    allAdvTypes.putAll(typeAdv);
                }
                for (Map.Entry entry : allAdvTypes.entrySet()) {
                    if (!((List)entry.getValue()).isEmpty()) {
                        String actualArgTypeVal = (String)entry.getKey() + "<";
                        actualArgTypeVal = actualArgTypeVal + String.join((CharSequence)", ", (Iterable)entry.getValue());
                        actualArgTypeVal = actualArgTypeVal + ">";
                        internalTypes.add(actualArgTypeVal);
                        _javaIncludes.addAll((Collection)entry.getValue());
                        continue;
                    }
                    internalTypes.add((String)entry.getKey());
                }
            }
            if (dataType.get(0) instanceof DBusMapType && internalTypes.size() == 1) {
                internalTypes.add((String)internalTypes.get(0));
            }
            return retVal + "<" + String.join((CharSequence)", ", internalTypes) + ">";
        }
        return ((Type)dataType.get(0)).getTypeName();
    }

    static {
        CLASS_MAP.put("java.lang.CharSequence", "String");
        CLASS_MAP.put("java.util.List", "List");
        CLASS_MAP.put("java.util.Set", "Set");
        CLASS_MAP.put("java.util.Map", "Map");
        CLASS_MAP.put(Variant.class.getName(), "Variant<?>");
    }
}

