/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freedesktop.dbus.viewer.TabbedSaveAction;
import org.freedesktop.dbus.viewer.TextFile;

class SaveFileAction
extends TabbedSaveAction
implements ChangeListener {
    SaveFileAction(JTabbedPane tabbedPane) {
        super(tabbedPane);
        this.enableAndSetName();
        tabbedPane.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.enableAndSetName();
    }

    void enableAndSetName() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        boolean enabled = selectedIndex > -1;
        this.putValue("Name", "Save " + this.getFileName(selectedIndex) + "...");
        this.setEnabled(enabled);
    }

    @Override
    public Iterator<TextFile> iterator() {
        return new SelectedTabIterator();
    }

    private class SelectedTabIterator
    implements Iterator<TextFile> {
        boolean iterated = false;

        private SelectedTabIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.iterated;
        }

        @Override
        public TextFile next() {
            if (this.iterated) {
                throw new NoSuchElementException("Already iterated");
            }
            this.iterated = true;
            return SaveFileAction.this.getTextFile(SaveFileAction.this.tabbedPane.getSelectedIndex());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

