/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.utils.Util;
import org.freedesktop.dbus.utils.generator.TypeConverter;

public class ClassBuilderInfo {
    private static final Set<String> RESERVED = new HashSet<String>();
    private final Set<String> imports = new TreeSet<String>();
    private final List<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();
    private final List<MemberOrArgument> members = new ArrayList<MemberOrArgument>();
    private final Set<String> implementedInterfaces = new LinkedHashSet<String>();
    private final List<ClassMethod> methods = new ArrayList<ClassMethod>();
    private final List<ClassBuilderInfo> innerClasses = new ArrayList<ClassBuilderInfo>();
    private final List<ClassConstructor> constructors = new ArrayList<ClassConstructor>();
    private String className;
    private String packageName;
    private String dbusPackageName;
    private ClassType classType;
    private String extendClass;

    public Set<String> getImports() {
        return this.imports;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String _packageName) {
        this.packageName = _packageName;
    }

    public String getDbusPackageName() {
        return this.dbusPackageName;
    }

    public void setDbusPackageName(String _dbusPackageName) {
        this.dbusPackageName = _dbusPackageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String _className) {
        this.className = _className;
    }

    public ClassType getClassType() {
        return this.classType;
    }

    public void setClassType(ClassType _classType) {
        this.classType = _classType;
    }

    public List<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    public Set<String> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public String getExtendClass() {
        return this.extendClass;
    }

    public void setExtendClass(String _extendClass) {
        this.extendClass = _extendClass;
    }

    public List<ClassMethod> getMethods() {
        return this.methods;
    }

    public List<MemberOrArgument> getMembers() {
        return this.members;
    }

    public List<ClassBuilderInfo> getInnerClasses() {
        return this.innerClasses;
    }

    public List<ClassConstructor> getConstructors() {
        return this.constructors;
    }

    public String createClassFileContent() {
        List<String> result = this.createClassFileContent(false, new LinkedHashSet<String>());
        return String.join((CharSequence)System.lineSeparator(), result);
    }

    private List<String> createClassFileContent(boolean _staticClass, Set<String> _otherImports) {
        ArrayList<String> content = new ArrayList<String>();
        String classIndent = _staticClass ? "    " : "";
        String memberIndent = _staticClass ? "        " : "    ";
        TreeSet<String> allImports = new TreeSet<String>();
        allImports.addAll(this.getImports());
        if (_otherImports != null) {
            allImports.addAll(_otherImports);
        }
        if (!_staticClass) {
            content.add("package " + this.getPackageName() + ";");
            content.add("");
            content.add("/**");
            content.add(" * Auto-generated class.");
            content.add(" */");
        } else {
            content.add("");
        }
        if (this.getDbusPackageName() != null) {
            allImports.add(DBusInterfaceName.class.getName());
            content.add(classIndent + "@" + DBusInterfaceName.class.getSimpleName() + "(\"" + this.getDbusPackageName() + "\")");
        }
        for (AnnotationInfo annotation : this.annotations) {
            allImports.add(annotation.getAnnotationClass().getName());
            String annotationCode = classIndent + "@" + annotation.getAnnotationClass().getSimpleName();
            if (annotation.getAnnotationParams() != null) {
                annotationCode = annotationCode + "(" + annotation.getAnnotationParams() + ")";
            }
            content.add(annotationCode);
        }
        String bgn = classIndent + "public " + (_staticClass ? "static " : "") + (this.getClassType() == ClassType.INTERFACE ? "interface" : "class");
        bgn = bgn + " " + this.getClassName();
        if (this.getExtendClass() != null) {
            Set<String> imports = ClassBuilderInfo.getImportsForType(this.getExtendClass());
            this.getImports().addAll(imports);
            allImports.addAll(imports);
            bgn = bgn + " extends " + ClassBuilderInfo.getSimpleTypeClasses(this.getExtendClass());
        }
        if (!this.getImplementedInterfaces().isEmpty()) {
            bgn = bgn + " implements " + this.getImplementedInterfaces().stream().map(e -> ClassBuilderInfo.getClassName(e)).collect(Collectors.joining(", "));
            this.getImports().addAll(this.getImplementedInterfaces().stream().filter(s -> !s.startsWith("java.lang.")).collect(Collectors.toList()));
        }
        bgn = bgn + " {";
        content.add(bgn);
        if (_staticClass) {
            content.add("");
        }
        for (MemberOrArgument member : this.members) {
            if (!member.getAnnotations().isEmpty()) {
                content.addAll(member.getAnnotations().stream().map(l -> memberIndent + l).collect(Collectors.toList()));
            }
            content.add(memberIndent + "private " + member.asOneLineString(allImports, false) + ";");
        }
        if (!this.getConstructors().isEmpty()) {
            content.add("");
            for (ClassConstructor constructor : this.getConstructors()) {
                String innerIndent;
                String outerIndent = _staticClass ? "        " : "    ";
                String cstr = outerIndent + "public " + this.getClassName() + "(";
                ArrayList<MemberOrArgument> filteredSuperArguments = new ArrayList<MemberOrArgument>(constructor.getSuperArguments());
                filteredSuperArguments.removeIf(e -> constructor.getArguments().contains(e));
                if (!filteredSuperArguments.isEmpty()) {
                    cstr = cstr + filteredSuperArguments.stream().map(e -> e.asOneLineString(allImports, false)).collect(Collectors.joining(", "));
                    if (!constructor.getArguments().isEmpty()) {
                        cstr = cstr + ", ";
                    }
                }
                if (!constructor.getArguments().isEmpty()) {
                    cstr = cstr + constructor.argumentsAsString(allImports);
                }
                cstr = constructor.getThrowArguments().isEmpty() ? cstr + ") {" : cstr + ") throws " + String.join((CharSequence)", ", constructor.getThrowArguments()) + " {";
                content.add(cstr);
                String string = innerIndent = _staticClass ? "            " : "        ";
                if (!constructor.getSuperArguments().isEmpty()) {
                    content.add(innerIndent + "super(" + constructor.getSuperArguments().stream().map(c -> c.getName()).collect(Collectors.joining(", ")) + ");");
                }
                if (!constructor.getArguments().isEmpty()) {
                    for (MemberOrArgument e2 : constructor.getArguments()) {
                        content.add(innerIndent + "this." + e2.getName().replaceFirst("^_(.+)", "$1") + " = " + e2.getName() + ";");
                    }
                }
                content.add(outerIndent + "}");
            }
        }
        content.add("");
        for (MemberOrArgument member : this.members) {
            Object memberType = TypeConverter.getProperJavaClass(member.getType(), allImports);
            if (!member.getGenerics().isEmpty()) {
                memberType = (String)memberType + "<" + member.getGenerics().stream().map(c -> TypeConverter.getProperJavaClass(c, allImports)).collect(Collectors.joining(", ")) + ">";
            }
            String getterSetterName = Util.snakeToCamelCase((String)Util.upperCaseFirstChar((String)member.getName()));
            if (!member.isFinalArg()) {
                content.add(memberIndent + "public void set" + getterSetterName + "(" + (String)memberType + " arg) {");
                content.add(memberIndent + "    " + member.getName() + " = arg;");
                content.add(memberIndent + "}");
            }
            content.add("");
            content.add(memberIndent + "public " + (String)memberType + " get" + getterSetterName + "() {");
            content.add(memberIndent + "    return " + member.getName() + ";");
            content.add(memberIndent + "}");
        }
        content.add("");
        for (ClassMethod mth : this.getMethods()) {
            if (!mth.getAnnotations().isEmpty()) {
                content.addAll(mth.getAnnotations().stream().map(a -> memberIndent + a).collect(Collectors.toList()));
            }
            String clzMth = memberIndent + "public " + (String)(mth.getReturnType() == null ? "void " : TypeConverter.getProperJavaClass(mth.getReturnType(), allImports) + " ");
            clzMth = clzMth + mth.getName() + "(";
            if (!mth.getArguments().isEmpty()) {
                clzMth = clzMth + mth.getArguments().stream().map(e -> e.asOneLineString(allImports, true)).collect(Collectors.joining(", "));
            }
            clzMth = clzMth + ");";
            content.add(clzMth);
        }
        content.add("");
        for (ClassBuilderInfo inner : this.getInnerClasses()) {
            content.addAll(inner.createClassFileContent(true, allImports));
            allImports.addAll(inner.getImports());
        }
        content.add(classIndent + "}");
        if (!_staticClass) {
            content.add(2, "");
            content.addAll(2, allImports.stream().filter(l -> !l.startsWith("java.lang.")).map(l -> "import " + l + ";").collect(Collectors.toList()));
        }
        return content;
    }

    public String getFileName() {
        if (this.getClassName() == null) {
            return null;
        }
        if (this.getPackageName() == null) {
            return this.getClassName() + ".java";
        }
        return this.getPackageName().replace(".", File.separator) + File.separator + this.getClassName() + ".java";
    }

    public String getFqcn() {
        return Util.isBlank((String)this.getPackageName()) ? this.getClassName() : this.getPackageName() + "." + this.getClassName();
    }

    static String getClassName(String _fqcn) {
        if (_fqcn == null) {
            return null;
        }
        String clzzName = _fqcn;
        if (clzzName.contains(".")) {
            clzzName = clzzName.substring(clzzName.lastIndexOf(46) + 1);
        }
        return clzzName;
    }

    static String getSimpleTypeClasses(String _type) {
        if (_type == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Pattern compile = Pattern.compile("([^, <>?]+)");
        Matcher matcher = compile.matcher(_type);
        while (matcher.find()) {
            String match = matcher.group();
            matcher.appendReplacement(sb, ClassBuilderInfo.getClassName(match));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static Set<String> getImportsForType(String _type) {
        HashSet<String> imports = new HashSet<String>();
        if (!_type.contains("<")) {
            if (!_type.startsWith("java.lang.") && _type.contains(".")) {
                imports.add(_type);
            }
            return imports;
        }
        Pattern compile = Pattern.compile("([^, <>?]+)");
        Matcher matcher = compile.matcher(_type);
        while (matcher.find()) {
            String match = matcher.group();
            if (match.startsWith("java.lang.") || !match.contains(".")) continue;
            imports.add(match);
        }
        return imports;
    }

    static {
        RESERVED.add("abstract");
        RESERVED.add("assert");
        RESERVED.add("boolean");
        RESERVED.add("break");
        RESERVED.add("byte");
        RESERVED.add("case");
        RESERVED.add("catch");
        RESERVED.add("char");
        RESERVED.add("class");
        RESERVED.add("const");
        RESERVED.add("continue");
        RESERVED.add("default");
        RESERVED.add("do");
        RESERVED.add("double");
        RESERVED.add("else");
        RESERVED.add("enum");
        RESERVED.add("extends");
        RESERVED.add("final");
        RESERVED.add("finally");
        RESERVED.add("float");
        RESERVED.add("for");
        RESERVED.add("goto");
        RESERVED.add("if");
        RESERVED.add("implements");
        RESERVED.add("import");
        RESERVED.add("instanceof");
        RESERVED.add("int");
        RESERVED.add("interface");
        RESERVED.add("long");
        RESERVED.add("native");
        RESERVED.add("new");
        RESERVED.add("null");
        RESERVED.add("package");
        RESERVED.add("private");
        RESERVED.add("protected");
        RESERVED.add("public");
        RESERVED.add("return");
        RESERVED.add("short");
        RESERVED.add("static");
        RESERVED.add("strictfp");
        RESERVED.add("super");
        RESERVED.add("switch");
        RESERVED.add("synchronized");
        RESERVED.add("this");
        RESERVED.add("throw");
        RESERVED.add("throws");
        RESERVED.add("transient");
        RESERVED.add("try");
        RESERVED.add("void");
        RESERVED.add("volatile");
        RESERVED.add("while");
    }

    public static enum ClassType {
        INTERFACE,
        CLASS;

    }

    public static class AnnotationInfo {
        private final Class<? extends Annotation> annotationClass;
        private final String annotationParams;

        public AnnotationInfo(Class<? extends Annotation> _annotationClass, String _annotationParams) {
            this.annotationClass = _annotationClass;
            this.annotationParams = _annotationParams;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        public String getAnnotationParams() {
            return this.annotationParams;
        }
    }

    public static class MemberOrArgument {
        private final String name;
        private final String type;
        private final boolean finalArg;
        private final List<String> generics = new ArrayList<String>();
        private final List<String> annotations = new ArrayList<String>();

        public MemberOrArgument(String _name, String _type, boolean _finalMember) {
            this.name = RESERVED.contains(_name) ? _name + "param" : _name;
            this.type = _type;
            this.finalArg = _finalMember;
        }

        public MemberOrArgument(String _name, String _type) {
            this(_name, _type, false);
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isFinalArg() {
            return this.finalArg;
        }

        public List<String> getGenerics() {
            return this.generics;
        }

        public String getFullType(Set<String> _allImports) {
            StringBuilder sb = new StringBuilder();
            sb.append(TypeConverter.getProperJavaClass(this.getType(), _allImports));
            if (!this.getGenerics().isEmpty()) {
                sb.append("<").append(this.getGenerics().stream().map(c -> TypeConverter.getProperJavaClass(c, _allImports)).collect(Collectors.joining(", "))).append(">");
            }
            return sb.toString();
        }

        public String asOneLineString(Set<String> _allImports, boolean _includeAnnotations) {
            StringBuilder sb = new StringBuilder();
            if (this.isFinalArg()) {
                sb.append("final ");
            }
            if (_includeAnnotations && !this.getAnnotations().isEmpty()) {
                sb.append(String.join((CharSequence)" ", this.getAnnotations())).append(" ");
            }
            sb.append(this.getFullType(_allImports));
            sb.append(" ");
            sb.append(this.getName());
            return sb.toString();
        }
    }

    public static class ClassConstructor {
        private final List<MemberOrArgument> arguments = new ArrayList<MemberOrArgument>();
        private final List<MemberOrArgument> superArguments = new ArrayList<MemberOrArgument>();
        private final List<String> throwArguments = new ArrayList<String>();

        public List<String> getThrowArguments() {
            return this.throwArguments;
        }

        public List<MemberOrArgument> getArguments() {
            return this.arguments;
        }

        public List<MemberOrArgument> getSuperArguments() {
            return this.superArguments;
        }

        public String argumentsAsString(Set<String> _allImports) {
            return this.getArguments().stream().map(a -> a.asOneLineString(_allImports, true)).collect(Collectors.joining(", "));
        }
    }

    public static class ClassMethod {
        private final String name;
        private final String returnType;
        private final boolean finalMethod;
        private final List<MemberOrArgument> arguments = new ArrayList<MemberOrArgument>();
        private final List<String> annotations = new ArrayList<String>();

        public ClassMethod(String _name, String _returnType, boolean _finalMethod) {
            this.name = _name;
            this.returnType = _returnType;
            this.finalMethod = _finalMethod;
        }

        public String getName() {
            return this.name;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public boolean isFinalMethod() {
            return this.finalMethod;
        }

        public List<MemberOrArgument> getArguments() {
            return this.arguments;
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }
    }
}

