/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.text.JTextComponent;
import org.freedesktop.dbus.viewer.FileSaver;
import org.freedesktop.dbus.viewer.TextFile;

abstract class TabbedSaveAction
extends AbstractAction
implements Iterable<TextFile> {
    private static final long serialVersionUID = -1L;
    private static JFileChooser chooser;
    protected final JTabbedPane tabbedPane;

    protected TabbedSaveAction(JTabbedPane _tabbedPane) {
        this.tabbedPane = _tabbedPane;
    }

    protected TabbedSaveAction(JTabbedPane _tabbedPane, String _name) {
        super(_name);
        this.tabbedPane = _tabbedPane;
    }

    protected TextFile getTextFile(int _index) {
        JScrollPane scrollPane = (JScrollPane)this.tabbedPane.getComponentAt(_index);
        JTextComponent textComponent = (JTextComponent)scrollPane.getViewport().getView();
        String sourceCode = textComponent.getText();
        String fileName = this.getFileName(_index);
        TextFile textFile = new TextFile(fileName, sourceCode);
        return textFile;
    }

    protected String getFileName(int _index) {
        return _index > -1 ? this.tabbedPane.getTitleAt(_index) : "";
    }

    @Override
    public final void actionPerformed(ActionEvent _event) {
        if (chooser == null) {
            chooser = new JFileChooser();
        }
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Select parent directory for saving");
        int result = chooser.showDialog(this.tabbedPane, "Select");
        if (result == 0) {
            File parentDirectory = chooser.getSelectedFile();
            if (parentDirectory.exists() || parentDirectory.mkdirs()) {
                if (parentDirectory.canWrite()) {
                    FileSaver runnable = new FileSaver(this.tabbedPane, parentDirectory, this);
                    new Thread(runnable).start();
                } else {
                    JOptionPane.showMessageDialog(this.tabbedPane, "Could not write to parent directory", "Invalid Parent Directory", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this.tabbedPane, "Could not access parent directory", "Invalid Parent Directory", 0);
            }
        }
    }
}

