/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import java.io.File;
import java.util.Map;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.utils.Util;
import org.freedesktop.dbus.utils.generator.InterfaceCodeGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.util.StringUtils;

class InterfaceCodeGeneratorTest {
    InterfaceCodeGeneratorTest() {
    }

    static InterfaceCodeGenerator loadDBusXmlFile(File _inputFile, String _objectPath, String _busName) {
        if (!StringUtils.isBlank((String)_busName)) {
            String introspectionData = Util.readFileToString((File)_inputFile);
            InterfaceCodeGenerator ci2 = new InterfaceCodeGenerator(introspectionData, _objectPath, _busName);
            return ci2;
        }
        Assertions.fail((String)"No valid busName given");
        Assertions.fail((String)("Unable to load file: " + _inputFile));
        return null;
    }

    @Test
    void testCreateSelectedFirewallInterfaces() throws Exception {
        InterfaceCodeGenerator ci2 = InterfaceCodeGeneratorTest.loadDBusXmlFile(new File("src/test/resources/CreateInterface/firewall/org.fedoraproject.FirewallD1.xml"), "/org/fedoraproject/FirewallD1", "org.fedoraproject.FirewallD1");
        Map analyze = ci2.analyze(true);
        Assertions.assertEquals((int)9, (int)analyze.size());
    }

    @Test
    void testCreateAllFirewallInterfaces() throws Exception {
        InterfaceCodeGenerator ci2 = InterfaceCodeGeneratorTest.loadDBusXmlFile(new File("src/test/resources/CreateInterface/firewall/org.fedoraproject.FirewallD1.xml"), "/org/fedoraproject/FirewallD1", "*");
        Map analyze = ci2.analyze(true);
        Assertions.assertEquals((int)20, (int)analyze.size());
    }

    @Test
    void testCreateNetworkManagerWirelessInterface() throws Exception {
        InterfaceCodeGenerator ci2 = InterfaceCodeGeneratorTest.loadDBusXmlFile(new File("src/test/resources/CreateInterface/networkmanager/org.freedesktop.NetworkManager.Device.Wireless.xml"), "/", "org.freedesktop.NetworkManager.Device.Wireless");
        Map analyze = ci2.analyze(true);
        Assertions.assertEquals((int)1, (int)analyze.size());
        String clzContent = (String)analyze.get(analyze.keySet().iterator().next());
        Assertions.assertTrue((boolean)clzContent.contains("@" + DBusInterfaceName.class.getSimpleName() + "(\"org.freedesktop.NetworkManager.Device.Wireless\")"));
        Assertions.assertFalse((boolean)clzContent.contains("this._properties"));
        Assertions.assertFalse((boolean)clzContent.contains("this._path"));
        Assertions.assertFalse((boolean)clzContent.contains("this._interfaceName"));
    }

    @Test
    void testCreateSampleStructArgs() throws Exception {
        InterfaceCodeGenerator ci2 = InterfaceCodeGeneratorTest.loadDBusXmlFile(new File("src/test/resources/CreateInterface/sample_struct_args.xml"), "/", "org.example");
        Map analyze = ci2.analyze(true);
        Assertions.assertEquals((int)2, (int)analyze.size());
        String clzContent = (String)analyze.get(new File("org", "ExampleMethodStruct.java"));
        Assertions.assertTrue((boolean)clzContent.contains("@Position(0)"), (String)"Position annotation expected");
        Assertions.assertTrue((boolean)clzContent.contains("private final List<Integer> member0;"), (String)"Final List<Integer> member expected");
        Assertions.assertTrue((boolean)clzContent.contains("public ExampleMethodStruct(List<Integer> member0)"), (String)"Constructor using List<Integer> expected");
        Assertions.assertTrue((boolean)clzContent.contains("public List<Integer> getMember0()"), (String)"Getter for Member of type List<Integer> expected");
    }
}

